#!/bin/bash

source ../cascade-make/lib/cascade-lib.bash GEXTGNOME .. $*

# The standard list of packages
# For Mac Yosemite we found that PKG-CONFIG is dependent on GLIB, so we've moved GLIB ahead of PKG-CONFIG in the list
# removing expat and xmlparser
pkglist="LIBZ LIBBZ2 LIBPNG READLINE INTLTOOL GETTEXT LIBFFI PCRE GLIB PKG-CONFIG LIBXML LIBXSLT LIBGSF"

# libiconv was found to be necessary on the latest DL mac (2013)
# This triggered the need for 'cups' as well, not because libiconv needed it, but due to
# glib getting a conflict during its configure stage over the version of iconv

# Mac 11/12 (Lion/Mountain Lion and possibly later versions) need CUPS. Mac 9/10 (Leopard, Snow Leopard) don't need it and gnome-lib fails to compile with it.
# 14 Oct 2016: Mac 15 (El Capitan and possibly later versions) changed matters again: DYLD_LIBRARY_PATH gets wiped out, leading to libiconv problems
# The solution was that, since MacOS come with their own special compatible libconv (see https://discussions.apple.com/thread/1931034?start=0&tstart=0),
# to let MacOS machines use the system libiconv rather than compiling up the one in gnome-lib or the other one used by indexers' jni and mgpp/text, etc.
# Since CUPS was only included to get libiconv to work, neither are now compiled up with gnome-lib:   
osversion=`uname -r | sed 's/\..*$//'`;
if [ "x$GSDLOS" = "xdarwin" -a $osversion -ge 11 ] ; then
#    pkglist="LIBZ LIBBZ2 EXPAT LIBPNG READLINE XMLPARSER INTLTOOL CUPS LIBICONV GETTEXT GLIB PKG-CONFIG LIBXML LIBFFI LIBGSF"    
    pkglist="LIBZ LIBBZ2 EXPAT LIBPNG READLINE XMLPARSER INTLTOOL GETTEXT LIBFFI PCRE GLIB PKG-CONFIG LIBXML LIBXSLT LIBGSF"    
fi

if [ "x$crossOS" != "x" ] ; then
  # cross compiling
  windows_pkglist="LIBZ LIBBZ2 EXPAT LIBPNG READLINE INTLTOOL LIBICONV GETTEXT GLIB LIBXML LIBGSF"

  android_pkglist="LIBZ LIBBZ2 EXPAT LIBPNG READLINE INTLTOOL LIBICONV GETTEXT LIBFFI GLIB LIBXML DBUS LIBGSF"


  if [ $crossOS = "android" ] ; then
    pkglist=$android_pkglist
  elif [ $crossOS = "windows" ] ; then
    pkglist=$windows_pkglist
  fi

fi

for d in $pkglist; do
 
    echo "    Running CASCADE-MAKE/$d.sh"

    ./CASCADE-MAKE/$d.sh $*

    if [ $? != 0 ] ; then
	echo "Error encountered running CASCADE-MAKE/$d.sh"
	exit 1
    fi
done

if [ $install = "1" ] ; then
  touch "$GEXTGNOME_INSTALLED/lib/pkgconfig/.fixed-prefix.awk"
fi

if [ $makedist = "1" ] ; then
  rm -f "$GEXTGNOME_INSTALLED/lib/pkgconfig/.fixed-prefix.awk"
  lalist=`find $GEXTGNOME_INSTALLED/lib -name "*.la"`
  if [ -n "$lalist" ] ; then
    rm -f $lalist
  fi
fi
