#!/bin/bash

if [ -d cascade-make ] ; then
  source cascade-make/lib/cascade-lib.bash GEXTGNOME . $*
fi

if [ -z $GEXTGNOME ] ; then
  source ./setup.bash_old
fi

if [ -z $GEXTGNOME_DEVEL ] ; then
	# Set environment variable so we can tell devel.bash has been sourced
	export GEXTGNOME_DEVEL=$GEXTGNOME
	
	export PATH="$GEXTGNOME_INSTALLED/bin:$PATH"
	export CFLAGS="-I$GEXTGNOME_INSTALLED/include -I$GEXTGNOME_INSTALLED/include/libxml2 $CFLAGS"
	export CPPFLAGS="-I$GEXTGNOME_INSTALLED/include -I$GEXTGNOME_INSTALLED/include/libxml2 $CPPFLAGS"
	export CXXFLAGS="-I$GEXTGNOME_INSTALLED/include -I$GEXTGNOME_INSTALLED/include/libxml2 $CXXFLAGS"
	export LDFLAGS="-L$GEXTGNOME_INSTALLED/lib $LDFLAGS"
	export PKG_CONFIG_PATH="$GEXTGNOME_INSTALLED/lib/pkgconfig:$PKG_CONFIG_PATH"
	
	echo "+Your environment is now setup to compile with the GNOME Support Library"

	if [ -d "$GEXTGNOME_INSTALLED/lib/pkgconfig" ] ; then
  	    echo ""
        echo "+Testing that pkg-config is correctly configured..."

	    pushd $GEXTGNOME_INSTALLED/lib/pkgconfig

  	    if [ ! -e .fixed-prefix.awk ] ; then

		    echo "Configuring ..."

            echo "/^prefix=/ { print \"prefix=$GEXTGNOME_INSTALLED\" ; next }" > .fixed-prefix.awk 
		    echo "	{ print \$0 }" >> .fixed-prefix.awk

		    for file in *.pc ; do
		        cat $file | awk -f .fixed-prefix.awk > $file.new && \
	              /bin/mv $file.new $file
   		    done
		    echo "... done"
        else
            echo "No configuration needed"
        fi

	    popd
    fi
else
	echo "+Your environment is already setup to compile with the GNOME Support Library"
fi
