<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
      		xmlns:xsltutil="xalan://org.nzdl.gsdl.ApplyXSLTUtil"
		exclude-result-prefixes="xsltutil">

  <xsl:output method="html" indent="yes"/>

  <!--
  <xsl:template name="escapeQuote">
    <xsl:param name="pText" select="."/>
    
    <xsl:if test="string-length($pText) >0">
      <xsl:value-of select="substring-before(concat($pText, '&quot;'), '&quot;')"/>
      
      <xsl:if test="contains($pText, '&quot;')">
        <xsl:text>\"</xsl:text>
	
        <xsl:call-template name="escapeQuote">
          <xsl:with-param name="pText" select=
			  "substring-after($pText, '&quot;')"/>
        </xsl:call-template>
      </xsl:if>
    </xsl:if>
  </xsl:template>
  -->
  

  <xsl:template match="/Archive">
    <html>
      <head>
        <xsl:comment>
  	  HTML representation of a Greenstone doc.xml file,
	  designed for ingest in OpenAI's GPTs dashboard
        </xsl:comment>	
      </head>
      <body>
        <xsl:apply-templates/>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="/Archive/Section">
    <div class="document-article">
      <xsl:apply-templates/>
    </div>    
  </xsl:template>

  <xsl:template match="Section">
    <div class="nested-section">
      <xsl:apply-templates/>
    </div>    
  </xsl:template>

  <xsl:template match="/Archive/Section/Description">
    <xsl:variable name="docoid"><xsl:value-of select="Metadata[@name='Identifier']"/></xsl:variable>
    <div class="document-metadata-block">      
      <div>
	<span>Document Identifier: </span>
	<span><xsl:value-of select="$docoid"/></span>
      </div>
      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="Description">
    <div class="section-metadata-block">      
      <xsl:apply-templates/>
    </div>
  </xsl:template>
  
  <xsl:template match="Metadata">
    <xsl:variable name="metaname" select="@name"/>
    <!--
    <xsl:variable name="metaval"><xsl:call-template name="escapeQuote"><xsl:with-param name="pText" select="text()"/></xsl:call-template></xsl:variable>
    -->
    <xsl:variable name="metaval"><xsl:value-of select="text()"/></xsl:variable>
    <!--
    <xsl:if test="not(starts-with($metaname,'gsdlassoc'))">
    </xsl:if>      
    -->
    <xsl:if test="starts-with($metaname,'tw.')">      
      <div>
	<span>Metadata <xsl:value-of select="$metaname"/><xsl:text>: </xsl:text></span>
	<span><xsl:value-of select="$metaval"/></span>
      </div>
    </xsl:if>      
  </xsl:template>
  
  <xsl:template match="Content">
    <xsl:value-of select="text()" disable-output-escaping="yes"/>
  </xsl:template>

</xsl:stylesheet>

