
/* 
 * UNIX getpass function.
 */
# include <stdio.h> 
char *getpass (const char *prompt)
{
  static char pass[1024];
  char *p = pass;
  int k;

  if (prompt) {
    while (*prompt) {
      putc (*prompt++, stderr);
    }
  }

  do {
    k = getch ();
    if (p < pass + 1023) {
      switch (k) {
      case 0x04:
      case 0x0D:
        break;
      case 0x08:
        if (p > pass) p--;
        break;
      case 0xE0:
      case 0x00:
        getch ();
        break;
      default:
        *p++ = k;
        break;
      }
    }
  }
  while (k != 0x0D && k != 0x04);
  *p = 0x00;
  if (k == 0x0D) {
    putc (0x0D, stderr);
    putc (0x0A, stderr);
  }
  return pass;
}

