/**************************************************************************
 *
 * TagInfo.cpp -- 
 * Copyright (C) 1999  Rodger McNab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include "TagInfo.h"


void TagInfo::SetDocTag (const char *cStr) {
  SetCStr (docTag, cStr, strlen(cStr));
}

void TagInfo::SetIndexLevel (const char *cStr) {
  SetCStr (indexLevel, cStr, strlen(cStr));
}
void TagInfo::AddLevelTag (const char *cStr) {
  // convert the string
  UCArray cArr;
  SetCStr (cArr, cStr, strlen(cStr));

  // insert the tag
  levelTags.insert (cArr);
}


TagInfo::TagInfo () {
  Clear ();
}

void TagInfo::Clear () {
  docTag.erase (docTag.begin(), docTag.end());
  indexLevel.erase (indexLevel.begin(), indexLevel.end());
  levelTags.erase (levelTags.begin(), levelTags.end());
}

ostream &operator<<(ostream &s, const TagInfo &t) {
  // output docTag
  s << "docTag: \"" << t.docTag << "\"\n";

  // output indexLevel
  s << "indexLevel: \"" << t.indexLevel << "\"\n";

  // output levelTags
  s << "levelTags: ";

  UCArraySet::const_iterator here = t.levelTags.begin();
  UCArraySet::const_iterator end = t.levelTags.end();
  while (here != end) {
    s << "\"" << (*here) << "\"";
    ++here;
    if (here != end) s << ", ";
  }

  s << "\n";
  
  return s;
}

