# ISIS-GDL

GSDLHOME = ..\..\..

CC = cl
AR = lib

DEBUG = 0
DLL = 0
DLLDEBUG = 0

!IF $(DEBUG)
CXXFLAGS = -DEBUG -Z7 /errorReport:prompt
LDFLAGS = -DEBUG -Z7 /errorReport:prompt
!ELSE
CXXFLAGS =
LDFLAGS =
!ENDIF

!IF $(GSDL_VC4)
CXXFLAGS = $(CXXFLAGS) -GX
!ELSE
CXXFLAGS = $(CXXFLAGS) -EHsc
!ENDIF

!IF $(DLL)
CXXFLAGS = $(CXXFLAGS) -MD 
!ELSE
!IF ($(DLLDEBUG))
CXXFLAGS = $(CXXFLAGS) -MDd
!ENDIF
!ENDIF

COMPILE = $(CC) -nologo -c $(CXXFLAGS) $(DEFS) $(INCLUDES)
LINK = $(CC) -nologo $(LDFLAGS)

.SUFFIXES:
.SUFFIXES: .cpp .obj
.cpp.obj:
	$(COMPILE) $<

ANSI2KNR = 
o = .obj
e = .exe

HEADERS = AbstractIsisDb.h  CacheMan.h  Debug.h IErrors.h IsisUtil.h  \
	XRFFile.h BlkFile.h Checking.h  Fdt.h IsisDb.h MFFile.h  mytchar.h \
	CRC32.h Compat.h  File.h IsisDef.h  Master.h  stdafx.h \
	CRCTab.h  DLLCode.h FileSystem.h  IsisTypes.h Unimarc.h  tchar.h


SOURCES = CRC32.cpp Debug.cpp  FileSystem.cpp  IsisGdl.cpp Master.cpp  \
	 stdafx.cpp CacheMan.cpp  Fdt.cpp  IErrors.cpp IsisUtil.cpp  \
	 Unimarc.cpp Checking.cpp File.cpp IsisDb.cpp MFFile.cpp XRFFile.cpp

OBJECTS = IsisGdl$o CacheMan$o Checking$o CRC32$o Fdt$o File$o Debug$o \
	FileSystem$o IErrors$o IsisDb$o IsisUtil$o Master$o MFFile$o \
	stdafx$o Unimarc$o XRFFile$o

EXEC = IsisGdl$e

DEFS = 

all: $(EXEC)

install: $(EXEC)
	if NOT EXIST "$(GSDLHOME)\bin\windows" mkdir "$(GSDLHOME)\bin\windows"
	copy $(EXEC) "$(GSDLHOME)\bin\windows"

clean:
	del *.obj
	del $(EXEC)

IsisGdl$e: $(OBJECTS) $(LIBS)
	  $(LINK) $(OBJECTS) $(LIBS)

