/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * <BR><BR>
 *
 * Author: John Thompson, Greenstone Digital Library, University of Waikato
 *
 * <BR><BR>
 *
 * Copyright (C) 1999 New Zealand Digital Library Project
 *
 * <BR><BR>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * <BR><BR>
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * <BR><BR>
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.shell;

/** Title:        The Gatherer<br>
 * Description:  The Gatherer: a tool for gathering and enriching digital collections.<br>
 * Copyright:    Copyright (c) 2001<br>
 * Company:      The University of Waikato<br>
 * Written:        /  /01<br>
 * Revised:      12/05/02 - Commented<br>
 *               29/05/02 - Moved into correct package<br>
 * @author John Thompson, Greenstone Digital Libraries
 * @version 2.1 */
import java.awt.AWTEvent;

/** This class encapsulates all the information created by an event within a <strong>GShell</strong> process. */
public class GShellEvent 
    extends AWTEvent {
    /** Allows some part of the program to prevent this message being processed by other parts. */
    private boolean vetoed = false;
    /** The status of the process at the completion of event. */
    private int status = -1;
    /** The process type (such as COPY, BUILD or IMPORT). */
    private int type = -1;
    /** Any message associated with this event. */
    private String message = null;

    /* Constructor.
     * @param source The <strong>GShell</strong> that fired this message.
     * @param id The event identifier as an <strong>int</strong>.
     * @param type The process type as an <strong>int</strong>.
     * @param message A <strong>String</strong> representing any message attatched with this event.
     * @param status The status of the process post event, as an <strong>int</strong>.
     */
    public GShellEvent(Object source, int id, int type, String message, int status) {
	super(source, id);
	this.message = message;
	this.status = status;
	this.type = type;
    }

    /** Gets the message associated with this event.
     * @return The message as a <strong>String</strong> or <i>null</i>.
     */
    public String getMessage() {
	return message;
    }

    /** Gets the status associated with this event. This status can then be matched back to the constants in <strong>GShell</strong>.
     * @return An <strong>int</strong> signifying the process status.
     */ 
    public int getStatus() {
	return status;
    }

    /** Gets the type associated with this event. This type can then be matched back to the constants in <strong>GShell</strong>.
     * @return An <strong>int</strong> signifying the process type.
     */ 
    public int getType() {
	return type;
    }

    /** Determine if this event has been vetoed by some other part of the GLI
     * @return true if the event has, and thus shouldn't be further processed, false otherwise.
     */
    public boolean isVetoed() {
	return vetoed;
    }

    /** Change the message to be displayed by this event - usually from something technical so something easier to understand.
     * @param message the new message as a String
     */
    public void setMessage(String message) {
	this.message = message;
    }

    public String toString() {
	return "org.greenstone.gatherer.shell.GShellEvent[" + message + "," + status + "," + type + "]";
    }

    /** Prevent this event being processed by other parts of the GLI.
     */
    public void veto() {
	vetoed = true;
    }
}
