package org.greenstone.gatherer.gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.util.JarTools;

public class SimpleMenuBar
    extends JMenuBar
    implements ActionListener {

    private String page_name;

    public SimpleMenuBar(String page_name) {
	this.page_name = page_name;
        this.setComponentOrientation(Dictionary.getOrientation());
	JMenu help = new JMenu();
        help.setComponentOrientation(Dictionary.getOrientation());
	help.setIcon(JarTools.getImage("help.gif"));
	help.setText(Dictionary.get("Menu.Help"));

	JMenuItem help_help = new JMenuItem(Dictionary.get("Menu.Help"));
        help_help.setComponentOrientation(Dictionary.getOrientation());
	help_help.addActionListener(this);
	
	help.add(help_help);

	add(Box.createHorizontalGlue());
	add(help);
    }

    public void actionPerformed(ActionEvent event) {
	HelpFrame.setView(page_name);
    }
}
