/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * <BR><BR>
 *
 * Author: John Thompson, Greenstone Digital Library, University of Waikato
 *
 * <BR><BR>
 *
 * Copyright (C) 1999 New Zealand Digital Library Project
 *
 * <BR><BR>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * <BR><BR>
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * <BR><BR>
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.gui;

import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.Control;

import org.greenstone.gatherer.Configuration;

public class DesignPane 
    extends BaseConfigPane {

    /** The constructor. */
    public DesignPane() {
	super();
	if (Configuration.fedora_info.isActive()) {
	    contents = new String [] { "CDM.GUI.Plugins" };
	}
	else {
	    contents = new String [] { "CDM.GUI.Plugins", "CDM.GUI.Indexes", "CDM.GUI.Subcollections",  "CDM.GUI.Classifiers" };
	}
	
    }

    protected Control getSubControls(String type) {
	if(type.equals("CDM.GUI.Plugins")) {
	    return  CollectionDesignManager.plugin_manager.getControls();
	}
	if(type.equals("CDM.GUI.Indexes")) {
	    return CollectionDesignManager.index_manager.getControls();
	}
	if(type.equals("CDM.GUI.Subcollections")) {
	    return CollectionDesignManager.subcollection_manager.getControls();
	}
	if(type.equals("CDM.GUI.Classifiers")) {
	    return CollectionDesignManager.classifier_manager.getControls();
	}

	return null;
    }

}
