@echo off
setlocal EnableDelayedExpansion

:: With a nod to the paradox that this file is currently committed
:: to the very svn repository that we are looking to svn checkout from ...

set "checkout_dir=%~1"
if not defined checkout_dir set "checkout_dir=greenstone3-svn"


REM where wget >nul 2>&1
REM if %errorlevel%==0 (
REM     echo Detected 'wget' on PATH
REM     set "wget_detected=1"
REM ) else (
REM     set "wget_detected=0"
REM )


where svn >nul 2>&1
if %errorlevel%==0 (
    echo Detected 'svn' on PATH
    set "svn_detected=1"
) else (
    set "svn_detected=0"

    echo Did not detect 'svn' on PATH
    echo Testing for 'curl' to download a portable svn binary
    
    where curl >nul 2>&1
    if !errorlevel!==0 (
        echo Detected 'curl' on PATH
        set "curl_detected=1"	
    ) else (
        echo Failed to detect 'curl' on PATH
        set "curl_detected=0"
    )

    if not exist get-subversion-windows-64bit.bat (
        curl -q https://svn.greenstone.org/main/trunk/greenstone3/ext-cli/get-subversion-windows-64bit.bat?format=txt ^
            > get-subversion-windows-64bit.bat
    )
    cmd /c .\get-subversion-windows-64bit.bat

    if not exist setup-subversion-windows-64bit.bat (
        curl -q https://svn.greenstone.org/main/trunk/greenstone3/ext-cli/setup-subversion-windows-64bit.bat?format=txt ^
            > setup-subversion-windows-64bit.bat
    )
    call .\setup-subversion-windows-64bit.bat

    REM Run the check again, this time it should be found
    where svn >nul 2>&1    
    if !errorlevel!==0 (
        set "svn_detected=1"
    ) else (
        set "svn_detected=0"
    )
)
   
   

echo.
echo Assumption(s):
echo   1. You have 'svn' installed  (check: svn=%svn_detected%)
REM echo   2. You have 'wget' or 'curl' installed (check: curl=%curl_detected%, wget=%wget_detected%)
echo   2. You have 'curl' installed (check: curl=%curl_detected%)
echo.
echo [Pausing for 3 seconds]
timeout /t 3 /nobreak >nul

if not exist "%checkout_dir%" (
    svn co https://svn.greenstone.org/main/trunk/greenstone3 "%checkout_dir%"
    set "checkout_status=!errorlevel!"
) else (
    echo Detected existing directory "%checkout_dir%" -- skipping svn checkout
    set "checkout_status=0"
)

if "%checkout_status%"=="0" (

    cd "%checkout_dir%"
    cd ext-cli

    if not exist selfcontained-jdk\ (
        if exist "get-selfcontained-jdk.bat" (
            call .\get-selfcontained-jdk.bat
        ) else if exist "get-selfcontained-jdk.sh" (
            bash -lc "./get-selfcontained-jdk.sh"
        )
    )

    if not exist selfcontained-ant\ (
        if exist "get-selfcontained-ant.bat" (
            call .\get-selfcontained-ant.bat
        ) else if exist "get-selfcontained-ant.sh" (
            bash -lc "./get-selfcontained-ant.sh"
        )
    )

    if not exist selfcontained-perl-with-cpan\ (
       if exist "get-selfcontained-perl-with-cpan.bat" (
            call .\get-selfcontained-perl-with-cpan.bat
        ) else if exist "get-selfcontained-perl-with-cpan.sh" (
            bash -lc "./get-selfcontained-perl-with-cpan.sh"
        )
    )

    REM if not exist selfcontained-python3\ (
    REM   if exist "get-selfcontained-python3.bat" (
    REM       call .\get-selfcontained-python3.bat
    REM   ) else if exist "get-selfcontained-python3.sh" (
    REM       bash -lc "./get-selfcontained-python3.sh"
    REM   )
    REM )
    
    cd ..

    if "!errorlevel!"=="0" (
        echo.
        echo Away to compile up Greenstone3
        echo This might take a while
        echo.
        echo [Pausing for 3 seconds]
        timeout /t 3 /nobreak >nul

        REM Force fresh sourcing of setup file
        set "GSDL3SRCHOME="
        set "GSDLHOME="

        REM Source setup (prefer Windows .bat; else run the .sh inside bash)
        if exist "gs3-setup.bat" (
            call .\gs3-setup.bat
        ) else if exist "gs3-setup.sh" (
            bash -lc "set -e; source ./gs3-setup.sh;"
        )

        REM Compile up with default settings
        call ant -Dproperties.ok=y prepare && call ant install	    
   
        if "!errorlevel!"=="0" (
            echo.
            echo ****
            echo * Greenstone3 successfully installed with default settings!
            echo *
            echo * To start your Greenstone3 server run:
            echo *   cd "%checkout_dir%"
            if exist "ant-start-with-exts.bat" (
                echo *   .\ant-start-with-exts.bat
            ) else (
                echo *   ./ant-start-with-exts.sh
            )
            echo *
            echo * You can then visit the installed DL in your browser via:
            echo *   http://localhost:8383/greenstone3/library
            echo ****
            echo.
        )
    )
) else (
    echo. 1>&2
    echo An error was enountered checking out Greenstone3 from svn 1>&2
    echo Enable to find '%checkout_dir%'. Do you have 'svn' installed? 1>&2
)

endlocal

REM exit /b %errorlevel%

