/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.tigris.subversion.svnant.SvnAntException;
import org.tigris.subversion.svnant.commands.Keywords;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNKeywords;

public class Keywordsset
extends Keywords {
    public void execute() throws SvnAntException {
        super.execute();
        if (this.file != null) {
            try {
                this.svnClient.setKeywords(this.file, this.keywords, false);
            }
            catch (SVNClientException sVNClientException) {
                throw new SvnAntException("Can't set keywords on file " + this.file.toString(), sVNClientException);
            }
        } else if (this.dir != null) {
            try {
                this.svnClient.setKeywords(this.dir, this.keywords, this.recurse);
            }
            catch (SVNClientException sVNClientException) {
                throw new SvnAntException("Can't set keywords on directory " + this.dir.toString(), sVNClientException);
            }
        } else if (this.filesets.size() > 0) {
            for (int i = 0; i < this.filesets.size(); ++i) {
                FileSet fileSet = (FileSet)this.filesets.elementAt(i);
                this.keywordsSet(fileSet, this.keywords);
            }
        }
    }

    private void keywordsSet(FileSet fileSet, SVNKeywords sVNKeywords) throws SvnAntException {
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
        File file = fileSet.getDir(this.getProject());
        String[] stringArray = directoryScanner.getIncludedFiles();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            try {
                this.svnClient.setKeywords(file2, sVNKeywords, false);
                continue;
            }
            catch (SVNClientException sVNClientException) {
                throw new SvnAntException("Can't set keywords on file " + file2.toString(), sVNClientException);
            }
        }
    }
}

