/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.Reader;
import org.mozilla.javascript.Context;

final class LineBuffer {
    static final int BUFLEN = 256;
    private static final int EOL_HINT_MASK = 57296;
    private Reader in;
    private char[] otherBuffer = null;
    private char[] buffer = null;
    private int offset = 0;
    private int end = 0;
    private int otherEnd;
    private int lineno;
    private int lineStart = 0;
    private int otherStart = 0;
    private int prevStart = 0;
    private boolean lastWasCR = false;
    private boolean hitEOF = false;
    private int stringStart = -1;
    private StringBuffer stringSoFar = null;
    private boolean hadCFSinceStringStart = false;
    private static final boolean checkSelf = true;

    LineBuffer(Reader reader, int n) {
        this.in = reader;
        this.lineno = n;
    }

    int read() throws IOException {
        while (this.end != this.offset || this.fill()) {
            char c = this.buffer[this.offset];
            ++this.offset;
            if ((c & 0xDFD0) == 0) {
                switch (c) {
                    case '\r': {
                        if (this.offset != this.end) {
                            if (this.buffer[this.offset] == '\n') {
                                ++this.offset;
                            }
                        } else {
                            this.lastWasCR = true;
                        }
                    }
                    case '\n': 
                    case '\u2028': 
                    case '\u2029': {
                        this.prevStart = this.lineStart;
                        this.lineStart = this.offset;
                        ++this.lineno;
                        return 10;
                    }
                }
            }
            if (c < '\u0080' || !LineBuffer.formatChar(c)) {
                return c;
            }
            this.hadCFSinceStringStart = true;
        }
        return -1;
    }

    void unread() {
        if (this.offset == 0 && !this.hitEOF) {
            Context.codeBug();
        }
        if (this.offset == 0) {
            return;
        }
        --this.offset;
        char c = this.buffer[this.offset];
        if ((c & 0xDFD0) == 0 && LineBuffer.eolChar(c)) {
            this.lineStart = this.prevStart;
            --this.lineno;
        }
    }

    private void skipFormatChar() {
        if (!LineBuffer.formatChar(this.buffer[this.offset])) {
            Context.codeBug();
        }
        if (this.stringStart >= 0 || this.stringSoFar != null) {
            this.hadCFSinceStringStart = true;
        } else if (this.offset != 0) {
            char c = this.buffer[this.offset];
            this.buffer[this.offset] = this.buffer[this.offset - 1];
            this.buffer[this.offset - 1] = c;
        } else if (this.otherEnd != 0) {
            char c = this.buffer[this.offset];
            this.buffer[this.offset] = this.otherBuffer[this.otherEnd - 1];
            this.otherBuffer[this.otherEnd - 1] = c;
        }
        ++this.offset;
    }

    int peek() throws IOException {
        while (this.end != this.offset || this.fill()) {
            char c = this.buffer[this.offset];
            if ((c & 0xDFD0) == 0 && LineBuffer.eolChar(c)) {
                return 10;
            }
            if (c < '\u0080' || !LineBuffer.formatChar(c)) {
                return c;
            }
            this.skipFormatChar();
        }
        return -1;
    }

    boolean match(int n) throws IOException {
        if ((n & 0xDFD0) == 0 && LineBuffer.eolChar(n)) {
            Context.codeBug();
        }
        if (n >= 128 && LineBuffer.formatChar(n)) {
            Context.codeBug();
        }
        while (this.end != this.offset || this.fill()) {
            char c = this.buffer[this.offset];
            if (n == c) {
                ++this.offset;
                return true;
            }
            if (c < '\u0080' || !LineBuffer.formatChar(c)) {
                return false;
            }
            this.skipFormatChar();
        }
        return false;
    }

    String getLine() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.lineStart;
        if (n >= this.offset) {
            if (this.otherStart < this.otherEnd) {
                stringBuffer.append(this.otherBuffer, this.otherStart, this.otherEnd - this.otherStart);
            }
            n = 0;
        }
        stringBuffer.append(this.buffer, n, this.offset - n);
        int n2 = this.offset;
        while (true) {
            char c;
            if (n2 == this.buffer.length) {
                char[] cArray = new char[this.buffer.length * 2];
                System.arraycopy(this.buffer, 0, cArray, 0, this.buffer.length);
                this.buffer = cArray;
                int n3 = 0;
                try {
                    n3 = this.in.read(this.buffer, this.end, this.buffer.length - this.end);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (n3 < 0) break;
                this.end += n3;
            }
            if (((c = this.buffer[n2]) & 0xDFD0) == 0 && LineBuffer.eolChar(c)) break;
            ++n2;
        }
        stringBuffer.append(this.buffer, this.offset, n2 - this.offset);
        return stringBuffer.toString();
    }

    int getOffset() {
        if (this.lineStart >= this.offset) {
            return this.offset + (this.otherEnd - this.otherStart);
        }
        return this.offset - this.lineStart;
    }

    void startString() {
        char c;
        if (this.offset == 0) {
            this.stringSoFar = new StringBuffer();
            this.stringStart = -1;
            c = this.otherBuffer[this.otherEnd - 1];
            this.stringSoFar.append(c);
        } else {
            this.stringSoFar = null;
            this.stringStart = this.offset - 1;
            c = this.buffer[this.stringStart];
        }
        this.hadCFSinceStringStart = c >= '\u0080' && LineBuffer.formatChar(c);
    }

    String getString() {
        if (this.stringStart < 0 && this.stringSoFar == null) {
            Context.codeBug();
        }
        int n = this.offset > 0 && this.buffer[this.offset] == '\n' && this.buffer[this.offset - 1] == '\r' ? 1 : 0;
        String string = this.stringStart >= 0 ? new String(this.buffer, this.stringStart, this.offset - this.stringStart - n) : this.stringSoFar.append(this.buffer, 0, this.offset - n).toString();
        this.stringStart = -1;
        this.stringSoFar = null;
        if (this.hadCFSinceStringStart) {
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer = null;
            int n2 = 0;
            while (n2 < cArray.length) {
                if (LineBuffer.formatChar(cArray[n2])) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                        stringBuffer.append(cArray, 0, n2);
                    }
                } else if (stringBuffer != null) {
                    stringBuffer.append(cArray[n2]);
                }
                ++n2;
            }
            if (stringBuffer != null) {
                string = stringBuffer.toString();
            }
        }
        return string;
    }

    private boolean fill() throws IOException {
        int n;
        if (this.end != this.offset) {
            Context.codeBug();
        }
        int n2 = n = this.offset > 0 && this.lastWasCR ? 1 : 0;
        if (this.stringStart != -1) {
            this.stringSoFar = new StringBuffer();
            this.stringSoFar.append(this.buffer, this.stringStart, this.end - this.stringStart - n);
            this.stringStart = -1;
        } else if (this.stringSoFar != null) {
            this.stringSoFar.append(this.buffer, 0, this.end - n);
        }
        char[] cArray = this.buffer;
        this.buffer = this.otherBuffer;
        this.otherBuffer = cArray;
        if (this.buffer == null) {
            this.buffer = new char[256];
        }
        this.otherStart = this.lineStart;
        this.otherEnd = this.end;
        this.lineStart = this.otherBuffer == null ? 0 : this.buffer.length + 1;
        this.prevStart = this.lineStart;
        this.offset = 0;
        this.end = this.in.read(this.buffer, 0, this.buffer.length);
        if (this.end < 0) {
            this.end = 0;
            this.hitEOF = true;
            return false;
        }
        if (this.lastWasCR) {
            if (this.buffer[0] == '\n') {
                ++this.offset;
                if (this.end == 1) {
                    return this.fill();
                }
            }
            this.lineStart = this.offset;
            this.lastWasCR = false;
        }
        return true;
    }

    int getLineno() {
        return this.lineno;
    }

    boolean eof() {
        return this.hitEOF;
    }

    private static boolean formatChar(int n) {
        return Character.getType((char)n) == 16;
    }

    private static boolean eolChar(int n) {
        return n == 13 || n == 10 || n == 8232 || n == 8233;
    }
}

