/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.common.service.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.webswing.server.common.model.security.WebswingAction;
import org.webswing.server.common.service.security.RolePermissionResolver;
import org.webswing.toolkit.api.security.WebswingUser;

public abstract class AuthenticatedWebswingUser
implements WebswingUser,
Serializable {
    private static final long serialVersionUID = -9025181162519446299L;
    public static final String ROLE_AUTHENTICATED = "authenticated";
    private RolePermissionResolver resolver;
    private List<String> permissions;

    public AuthenticatedWebswingUser() {
        this(new WebswingAction.DefaultRolePermissionResolver());
    }

    public AuthenticatedWebswingUser(RolePermissionResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public abstract String getUserId();

    @Override
    public abstract List<String> getUserRoles();

    @Override
    public abstract Map<String, Serializable> getUserAttributes();

    public abstract Map<String, Serializable> getUserSessionAttributes();

    public abstract boolean hasRole(String var1);

    public List<String> getUserPermissions() {
        if (this.permissions == null) {
            this.permissions = this.resolvePermissions();
        }
        return this.permissions;
    }

    protected List<String> resolvePermissions() {
        ArrayList<String> permissions = new ArrayList<String>();
        for (WebswingAction action : WebswingAction.values()) {
            if (!this.isPermitted(action.name())) continue;
            permissions.add(action.name());
        }
        return permissions;
    }

    public boolean isPermitted(String permission) {
        String[] roles;
        if (this.resolver != null && (roles = this.resolver.getRolesForPermission(permission)) != null) {
            for (String role : roles) {
                if (!ROLE_AUTHENTICATED.equals(role) && !this.hasRole(role)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getUserId();
    }
}

