/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.common.service.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.webswing.server.common.service.security.AuthenticatedWebswingUser;
import org.webswing.toolkit.api.security.WebswingUser;

public final class AbstractWebswingUser
implements WebswingUser {
    private String userId;
    private List<String> roles;
    private List<String> permissions;
    private Map<String, Serializable> userAttributes;
    private boolean securityContextPerTab;

    public AbstractWebswingUser() {
    }

    public AbstractWebswingUser(AuthenticatedWebswingUser user, boolean securityContextPerTab) {
        this.userId = user.getUserId();
        this.roles = new ArrayList<String>(user.getUserRoles());
        this.permissions = new ArrayList<String>(user.getUserPermissions());
        this.userAttributes = new HashMap<String, Serializable>(user.getUserSessionAttributes());
        this.securityContextPerTab = securityContextPerTab;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public List<String> getUserRoles() {
        return this.roles;
    }

    public void setUserRoles(List<String> roles) {
        this.roles = roles;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public boolean isPermitted(String permission) {
        return this.permissions != null && this.permissions.contains(permission);
    }

    public boolean hasRole(String role) {
        return this.roles != null && this.roles.contains(role);
    }

    @Override
    public Map<String, Serializable> getUserAttributes() {
        return this.userAttributes;
    }

    public void setUserAttributes(Map<String, Serializable> userAttributes) {
        this.userAttributes = userAttributes;
    }

    public boolean isSecurityContextPerTab() {
        return this.securityContextPerTab;
    }

    public void setSecurityContextPerTab(boolean securityContextPerTab) {
        this.securityContextPerTab = securityContextPerTab;
    }

    public String toString() {
        return this.userId;
    }
}

