/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import org.apache.pdfbox.debugger.PDFDebugger;
import org.apache.pdfbox.tools.Decrypt;
import org.apache.pdfbox.tools.Encrypt;
import org.apache.pdfbox.tools.ExtractImages;
import org.apache.pdfbox.tools.ExtractText;
import org.apache.pdfbox.tools.OverlayPDF;
import org.apache.pdfbox.tools.PDFMerger;
import org.apache.pdfbox.tools.PDFSplit;
import org.apache.pdfbox.tools.PDFToImage;
import org.apache.pdfbox.tools.PrintPDF;
import org.apache.pdfbox.tools.TextToPDF;
import org.apache.pdfbox.tools.Version;
import org.apache.pdfbox.tools.WriteDecodedDoc;

public final class PDFBox {
    private PDFBox() {
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("apple.awt.UIElement", "true");
        if (args.length > 0) {
            String command = args[0];
            String[] arguments = new String[args.length - 1];
            System.arraycopy(args, 1, arguments, 0, arguments.length);
            boolean exitAfterCallingMain = true;
            if (command.equals("Decrypt")) {
                Decrypt.main(arguments);
            } else if (command.equals("Encrypt")) {
                Encrypt.main(arguments);
            } else if (command.equals("ExtractText")) {
                ExtractText.main(arguments);
            } else if (command.equals("ExtractImages")) {
                ExtractImages.main(arguments);
            } else if (command.equals("OverlayPDF")) {
                OverlayPDF.main(arguments);
            } else if (command.equals("PrintPDF")) {
                PrintPDF.main(arguments);
            } else if (command.equals("PDFDebugger") || command.equals("PDFReader")) {
                PDFDebugger.main(arguments);
                exitAfterCallingMain = false;
            } else if (command.equals("PDFMerger")) {
                PDFMerger.main(arguments);
            } else if (command.equals("PDFSplit")) {
                PDFSplit.main(arguments);
            } else if (command.equals("PDFToImage")) {
                PDFToImage.main(arguments);
            } else if (command.equals("TextToPDF")) {
                TextToPDF.main(arguments);
            } else if (command.equals("WriteDecodedDoc")) {
                WriteDecodedDoc.main(arguments);
            } else {
                PDFBox.showMessageAndExit();
            }
            if (exitAfterCallingMain) {
                System.exit(0);
            }
        } else {
            PDFBox.showMessageAndExit();
        }
    }

    private static void showMessageAndExit() {
        String message = "PDFBox version: \"" + Version.getVersion() + "\"\nUsage: java -jar pdfbox-app-x.y.z.jar <command> <args..>\n\nPossible commands are:\n  ConvertColorspace\n  Decrypt\n  Encrypt\n  ExtractText\n  ExtractImages\n  OverlayPDF\n  PrintPDF\n  PDFDebugger\n  PDFMerger\n  PDFReader\n  PDFSplit\n  PDFToImage\n  TextToPDF\n  WriteDecodedDoc";
        System.err.println(message);
        System.exit(1);
    }
}

