/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import jdbm.recman.BlockIo;
import jdbm.recman.TransactionManager;

public final class RecordFile {
    final TransactionManager txnMgr;
    private final LinkedList free = new LinkedList();
    private final HashMap inUse = new HashMap();
    private final HashMap dirty = new HashMap();
    private final HashMap inTxn = new HashMap();
    private boolean transactionsDisabled = false;
    public static final int BLOCK_SIZE = 8192;
    static final String extension = ".jdb";
    static final byte[] cleanData = new byte[8192];
    private RandomAccessFile file;
    private final String fileName;
    private boolean isReadOnly;

    RecordFile(String string) throws IOException {
        this.fileName = string;
        this.isReadOnly = false;
        try {
            this.file = new RandomAccessFile(string + extension, "rw");
        }
        catch (IOException iOException) {
            this.isReadOnly = true;
            this.file = new RandomAccessFile(string + extension, "r");
        }
        this.txnMgr = new TransactionManager(this);
    }

    String getFileName() {
        return this.fileName;
    }

    boolean isReadOnly() {
        return this.isReadOnly;
    }

    void disableTransactions() {
        this.transactionsDisabled = true;
    }

    BlockIo get(long l) throws IOException {
        Long l2 = new Long(l);
        BlockIo blockIo = (BlockIo)this.inTxn.get(l2);
        if (blockIo != null) {
            this.inTxn.remove(l2);
            this.inUse.put(l2, blockIo);
            return blockIo;
        }
        blockIo = (BlockIo)this.dirty.get(l2);
        if (blockIo != null) {
            this.dirty.remove(l2);
            this.inUse.put(l2, blockIo);
            return blockIo;
        }
        Iterator iterator = this.free.iterator();
        while (iterator.hasNext()) {
            BlockIo blockIo2 = (BlockIo)iterator.next();
            if (blockIo2.getBlockId() != l) continue;
            blockIo = blockIo2;
            iterator.remove();
            this.inUse.put(l2, blockIo);
            return blockIo;
        }
        if (this.inUse.get(l2) != null) {
            throw new Error("double get for block " + l);
        }
        blockIo = this.getNewNode(l);
        long l3 = l * 8192L;
        if (this.file.length() > 0L && l3 <= this.file.length()) {
            RecordFile.read(this.file, l3, blockIo.getData(), 8192);
        } else {
            System.arraycopy(cleanData, 0, blockIo.getData(), 0, 8192);
        }
        this.inUse.put(l2, blockIo);
        blockIo.setClean();
        return blockIo;
    }

    void release(long l, boolean bl) throws IOException {
        BlockIo blockIo = (BlockIo)this.inUse.get(new Long(l));
        if (blockIo == null) {
            throw new IOException("bad blockid " + l + " on release");
        }
        if (!blockIo.isDirty() && bl) {
            blockIo.setDirty();
        }
        this.release(blockIo);
    }

    void release(BlockIo blockIo) {
        Long l = new Long(blockIo.getBlockId());
        this.inUse.remove(l);
        if (blockIo.isDirty()) {
            this.dirty.put(l, blockIo);
        } else if (!this.transactionsDisabled && blockIo.isInTransaction()) {
            this.inTxn.put(l, blockIo);
        } else {
            this.free.add(blockIo);
        }
    }

    void discard(BlockIo blockIo) {
        Long l = new Long(blockIo.getBlockId());
        this.inUse.remove(l);
    }

    void commit() throws IOException {
        if (!this.inUse.isEmpty() && this.inUse.size() > 1) {
            this.showList(this.inUse.values().iterator());
            throw new Error("in use list not empty at commit time (" + this.inUse.size() + ")");
        }
        if (this.dirty.size() == 0) {
            return;
        }
        if (!this.transactionsDisabled) {
            this.txnMgr.start();
        }
        Iterator iterator = this.dirty.values().iterator();
        while (iterator.hasNext()) {
            BlockIo blockIo = (BlockIo)iterator.next();
            iterator.remove();
            if (this.transactionsDisabled) {
                long l = blockIo.getBlockId() * 8192L;
                this.file.seek(l);
                this.file.write(blockIo.getData());
                blockIo.setClean();
                this.free.add(blockIo);
                continue;
            }
            this.txnMgr.add(blockIo);
            this.inTxn.put(new Long(blockIo.getBlockId()), blockIo);
        }
        if (!this.transactionsDisabled) {
            this.txnMgr.commit();
        }
    }

    void rollback() throws IOException {
        if (!this.inUse.isEmpty()) {
            this.showList(this.inUse.values().iterator());
            throw new Error("in use list not empty at rollback time (" + this.inUse.size() + ")");
        }
        this.dirty.clear();
        this.txnMgr.synchronizeLogFromDisk();
        if (!this.inTxn.isEmpty()) {
            this.showList(this.inTxn.values().iterator());
            throw new Error("in txn list not empty at rollback time (" + this.inTxn.size() + ")");
        }
    }

    void close() throws IOException {
        if (!this.dirty.isEmpty()) {
            this.commit();
        }
        this.txnMgr.shutdown();
        if (!this.inTxn.isEmpty()) {
            this.showList(this.inTxn.values().iterator());
            throw new Error("In transaction not empty");
        }
        if (!this.dirty.isEmpty()) {
            System.out.println("ERROR: dirty blocks at close time");
            this.showList(this.dirty.values().iterator());
            throw new Error("Dirty blocks at close time");
        }
        if (!this.inUse.isEmpty()) {
            System.out.println("ERROR: inUse blocks at close time");
            this.showList(this.inUse.values().iterator());
            throw new Error("inUse blocks at close time");
        }
        this.file.close();
        this.file = null;
    }

    void forceClose() throws IOException {
        this.txnMgr.forceClose();
        this.file.close();
    }

    private void showList(Iterator iterator) {
        int n = 0;
        while (iterator.hasNext()) {
            System.out.println("elem " + n + ": " + iterator.next());
            ++n;
        }
    }

    private BlockIo getNewNode(long l) throws IOException {
        BlockIo blockIo = null;
        if (!this.free.isEmpty()) {
            blockIo = (BlockIo)this.free.removeFirst();
        }
        if (blockIo == null) {
            blockIo = new BlockIo(0L, new byte[8192]);
        }
        blockIo.setBlockId(l);
        blockIo.setView(null);
        return blockIo;
    }

    void synch(BlockIo blockIo) throws IOException {
        byte[] byArray = blockIo.getData();
        if (byArray != null) {
            long l = blockIo.getBlockId() * 8192L;
            this.file.seek(l);
            this.file.write(byArray);
        }
    }

    void releaseFromTransaction(BlockIo blockIo, boolean bl) throws IOException {
        Long l = new Long(blockIo.getBlockId());
        if (this.inTxn.remove(l) != null && bl) {
            this.free.add(blockIo);
        }
    }

    void sync() throws IOException {
        this.file.getFD().sync();
    }

    private static void read(RandomAccessFile randomAccessFile, long l, byte[] byArray, int n) throws IOException {
        randomAccessFile.seek(l);
        int n2 = n;
        int n3 = 0;
        while (n2 > 0) {
            int n4 = randomAccessFile.read(byArray, n3, n2);
            if (n4 == -1) {
                System.arraycopy(cleanData, 0, byArray, n3, n2);
                break;
            }
            n2 -= n4;
            n3 += n4;
        }
    }
}

