/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import jdbm.recman.BlockIo;
import jdbm.recman.BlockView;
import jdbm.recman.FreePhysicalRowId;
import jdbm.recman.PageHeader;

final class FreePhysicalRowIdPage
extends PageHeader {
    private static final short O_COUNT = 18;
    static final short O_FREE = 20;
    static final short ELEMS_PER_PAGE = 583;
    FreePhysicalRowId[] slots = new FreePhysicalRowId[583];

    FreePhysicalRowIdPage(BlockIo blockIo) {
        super(blockIo);
    }

    static FreePhysicalRowIdPage getFreePhysicalRowIdPageView(BlockIo blockIo) {
        BlockView blockView = blockIo.getView();
        if (blockView != null && blockView instanceof FreePhysicalRowIdPage) {
            return (FreePhysicalRowIdPage)blockView;
        }
        return new FreePhysicalRowIdPage(blockIo);
    }

    short getCount() {
        return this.block.readShort(18);
    }

    private void setCount(short s) {
        this.block.writeShort(18, s);
    }

    void free(int n) {
        this.get(n).setSize(0);
        this.setCount((short)(this.getCount() - 1));
    }

    FreePhysicalRowId alloc(int n) {
        this.setCount((short)(this.getCount() + 1));
        return this.get(n);
    }

    boolean isAllocated(int n) {
        return this.get(n).getSize() != 0;
    }

    boolean isFree(int n) {
        return !this.isAllocated(n);
    }

    FreePhysicalRowId get(int n) {
        if (this.slots[n] == null) {
            this.slots[n] = new FreePhysicalRowId(this.block, this.slotToOffset(n));
        }
        return this.slots[n];
    }

    short slotToOffset(int n) {
        return (short)(20 + n * 14);
    }

    int getFirstFree() {
        for (int i = 0; i < 583; ++i) {
            if (!this.isFree(i)) continue;
            return i;
        }
        return -1;
    }

    int getFirstLargerThan(int n) {
        for (int i = 0; i < 583; ++i) {
            if (!this.isAllocated(i) || this.get(i).getSize() < n) continue;
            return i;
        }
        return -1;
    }
}

