/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import jdbm.helper.CacheEvictionException;
import jdbm.helper.CachePolicy;
import jdbm.helper.CachePolicyListener;
import jdbm.helper.MRU;

public class SoftCache
implements CachePolicy {
    private static final int INITIAL_CAPACITY = 128;
    private static final float DEFAULT_LOAD_FACTOR = 1.5f;
    private final ReferenceQueue _clearQueue = new ReferenceQueue();
    private final CachePolicy _internal;
    private final Map _cacheMap;

    public SoftCache() {
        this(new MRU(128));
    }

    public SoftCache(CachePolicy cachePolicy) throws NullPointerException {
        this(1.5f, cachePolicy);
    }

    public SoftCache(float f, CachePolicy cachePolicy) throws IllegalArgumentException, NullPointerException {
        if (cachePolicy == null) {
            throw new NullPointerException("Internal cache cannot be null.");
        }
        this._internal = cachePolicy;
        this._cacheMap = new HashMap(128, f);
    }

    public void put(Object object, Object object2) throws CacheEvictionException {
        if (object == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        if (object2 == null) {
            throw new IllegalArgumentException("value cannot be null.");
        }
        this._internal.put(object, object2);
        this.removeClearedEntries();
        this._cacheMap.put(object, new Entry(object, object2, this._clearQueue));
    }

    public Object get(Object object) {
        Object object2 = this._internal.get(object);
        if (object2 != null) {
            return object2;
        }
        this.removeClearedEntries();
        Entry entry = (Entry)this._cacheMap.get(object);
        if (entry == null) {
            return null;
        }
        object2 = entry.getValue();
        if (object2 == null) {
            return null;
        }
        try {
            this._internal.put(object, object2);
        }
        catch (CacheEvictionException cacheEvictionException) {
            this._cacheMap.remove(object);
            return null;
        }
        return object2;
    }

    public void remove(Object object) {
        this._cacheMap.remove(object);
        this._internal.remove(object);
    }

    public void removeAll() {
        this._cacheMap.clear();
        this._internal.removeAll();
    }

    public Enumeration elements() {
        return this._internal.elements();
    }

    public void addListener(CachePolicyListener cachePolicyListener) throws IllegalArgumentException {
        this._internal.addListener(cachePolicyListener);
    }

    public void removeListener(CachePolicyListener cachePolicyListener) {
        this._internal.removeListener(cachePolicyListener);
    }

    private final void removeClearedEntries() {
        Reference reference = this._clearQueue.poll();
        while (reference != null) {
            Object object = ((Entry)reference).getKey();
            this._cacheMap.remove(object);
            reference = this._clearQueue.poll();
        }
    }

    private static class Entry
    extends SoftReference {
        private final Object _key;

        public Entry(Object object, Object object2, ReferenceQueue referenceQueue) {
            super(object2, referenceQueue);
            this._key = object;
        }

        final Object getKey() {
            return this._key;
        }

        final Object getValue() {
            return this.get();
        }
    }
}

