/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;
import jdbm.helper.Serialization;
import jdbm.helper.WrappedRuntimeException;

public final class ObjectBAComparator
implements Comparator,
Serializable {
    static final long serialVersionUID = 1L;
    private Comparator _comparator;

    public ObjectBAComparator(Comparator comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException("Argument 'comparator' is null");
        }
        this._comparator = comparator;
    }

    public int compare(Object object, Object object2) {
        if (object == null) {
            throw new IllegalArgumentException("Argument 'obj1' is null");
        }
        if (object2 == null) {
            throw new IllegalArgumentException("Argument 'obj2' is null");
        }
        try {
            object = Serialization.deserialize((byte[])object);
            object2 = Serialization.deserialize((byte[])object2);
            return this._comparator.compare(object, object2);
        }
        catch (IOException iOException) {
            throw new WrappedRuntimeException(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WrappedRuntimeException(classNotFoundException);
        }
    }

    public static int compareByteArray(byte[] byArray, byte[] byArray2) {
        int n = Math.min(byArray.length, byArray2.length);
        for (int i = 0; i < n; ++i) {
            if (byArray[i] >= 0) {
                if (byArray2[i] >= 0) {
                    if (byArray[i] < byArray2[i]) {
                        return -1;
                    }
                    if (byArray[i] <= byArray2[i]) continue;
                    return 1;
                }
                return -1;
            }
            if (byArray2[i] >= 0) {
                return 1;
            }
            if (byArray[i] < byArray2[i]) {
                return -1;
            }
            if (byArray[i] <= byArray2[i]) continue;
            return 1;
        }
        if (byArray.length == byArray2.length) {
            return 0;
        }
        if (byArray.length < byArray2.length) {
            return -1;
        }
        return 1;
    }
}

