<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:java="http://xml.apache.org/xslt/java"
	xmlns:util="xalan://org.greenstone.gsdl3.util.XSLTUtil"
	xmlns:gslib="http://www.greenstone.org/skinning"
	xmlns:gsf="http://www.greenstone.org/greenstone3/schema/ConfigFormat" 
	extension-element-prefixes="java util"
	exclude-result-prefixes="java util">

	<!-- use the 'main' layout -->
	<xsl:include href="layouts/main.xsl"/>

	<!-- set page title -->
	<xsl:template name="pageTitle"><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'favourites.title')"/></xsl:template>

	<!-- set page breadcrumbs -->
	<xsl:template name="breadcrumbs"><gslib:siteLink/><gslib:rightArrow/> <gslib:groupLinks/><gslib:collectionNameLinked/><gslib:rightArrow/></xsl:template>

	<!-- the page content -->
	<xsl:template match="/page">
          <!-- these two variables defined here, then used by javascript-->
          <gsf:variable name="selected_favourite_icon_url"><gsf:interfaceText name="favourite_star_selected_image"/></gsf:variable>
          <gsf:variable name="unselected_favourite_icon_url"><gsf:interfaceText name="favourite_star_image"/></gsf:variable>
	  <!-- make the language fragments accessible from javascript -->
	  <gslib:langfrag name="favourites"/>
	  <xsl:variable name="clusterName"><xsl:value-of select="/page/pageRequest/paramList/param[@name='c']/@value"/></xsl:variable>
	  <script type="text/javascript" src="interfaces/{$interface_name}/js/favouritebasket/favouritecheckout.js"><xsl:text> </xsl:text></script>
	  <xsl:call-template name="customJavascript"/>
	  <xsl:call-template name="customCSS"/>
	  <script type="text/javascript">
	    <xsl:text disable-output-escaping="yes">
	      docList.length=0;
	      docPlainList.length=0;
	    </xsl:text>
	    <xsl:for-each select="/page/pageResponse/favouriteList/documentNode">
	      <xsl:variable name="doc_id" select="concat(@collection, ':', @nodeID)"/>
	      <xsl:variable name="plain"><xsl:apply-templates select="." mode="plain-text" /></xsl:variable>
	      
	      <xsl:text disable-output-escaping="yes">docList.push("</xsl:text><xsl:value-of select="$doc_id"/><xsl:text disable-output-escaping="yes">");</xsl:text>
	      <xsl:text disable-output-escaping="yes">docPlainList.push("</xsl:text><xsl:value-of select="$plain"/><xsl:text disable-output-escaping="yes">");</xsl:text>
	    </xsl:for-each>
		</script>

		<div id="favouritesContent">
		  <xsl:choose>
		    <xsl:when test="/page/pageResponse/favouriteList/documentNode">
		      <div>
			<ul id="favouriteDocsList" style="list-style: none;">
			  
			  <xsl:for-each select="/page/pageResponse/favouriteList/documentNode">
			    <li><img src="{$selected_favourite_icon_url}" title="delete favourite" height="20" width="20" onClick="deleteFavouriteFromCheckout(this)" id="{@collection}:{@nodeID}"/>
			    <xsl:apply-templates select="."/>
			    </li>
                          </xsl:for-each>
			</ul>
		      </div>
		      
		      </xsl:when>
		    <xsl:otherwise>
		      <gsf:interfaceText name="favourites.empty_basket"/>
		    </xsl:otherwise>
		  </xsl:choose>
		</div>
		<xsl:variable name="delalltext"><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'favourites.delete_all')"/></xsl:variable>
                <div id="shareanddelbuttons">
		  <xsl:variable name="email-link">
		    <xsl:choose>
		      <xsl:when test="/page/pageResponse/format/gsf:option[@name='serverEmail']/@value = 'true'">showAndHideEmailForm()</xsl:when>
		      <xsl:otherwise>mailTo()</xsl:otherwise>
		    </xsl:choose>
		  </xsl:variable>
                  <span id="sendemailbutton" class="ui-button ui-widget ui-state-default ui-corner-all" onclick="{$email-link}"><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'favourites.email')"/></span>

                  <span id="favdeleteallbutton" class="ui-button ui-widget ui-state-default ui-corner-all" onclick="deleteAll()"><xsl:value-of select="$delalltext"/>
		  </span>
                  <span id="copybutton" class="ui-button ui-widget ui-state-default ui-corner-all" onclick="copyToClip()"><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'favourites.clipboard')"/></span>
                </div>
                <div id="delHelp"> 
                  <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'favourites.delete_help', $delalltext)"/>
		</div>

		<xsl:variable name="default-favourites"><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'favourites.default_subject')"/>
		</xsl:variable>
                <div id="emailForm" style="display:none;">
                  <table class="mailtable">
                    <tr><td class="mailitem"><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'favourites.to')"/></td><td><input id="address" class="mailinput" type="email" required="true"/></td></tr>
                    <tr><td class="mailitem"><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'favourites.cc')"/></td><td><input id="cc" class="mailinput" type="text"/></td></tr>
                    <tr><td class="mailitem"><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'favourites.bcc')"/></td><td><input id="bcc" class="mailinput" type="text"/></td></tr>
                    <tr><td class="mailitem"><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'favourites.subject')"/></td><td><input id="subject" class="mailinput" type="text" value="{$default-favourites}"/></td></tr>
                  </table>
                  <textarea id="pretextarea" >
                  <gsf:space/> <!-- to prevent collapse when empty -->
                  </textarea>
		  <xsl:variable name="send-text"><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'favourites.send')"/></xsl:variable>
                  <input id="sendmail" class="sendbutton" type="button" value="{$send-text}" onClick="sendMail();"/>
                </div>

	</xsl:template>

	<!-- this template for displaying the favourites list 
        this will only be used if there ends up being no corresponding templates in siteConfig and collections. -->
	<xsl:template match="documentNode">
          <xsl:call-template name="displayFavourite"/>
        </xsl:template>
        
        <xsl:template name="displayFavourite">
          <gsf:if-metadata-exists><gsf:metadata name="srclinkFile"/><gsf:if><a><xsl:attribute name='href'><xsl:value-of select="$base-href"/><xsl:value-of select="$library_name"/>/collection/<xsl:value-of select='@collection'/>/document/<xsl:value-of select='@nodeID'/>/assoc/<gsf:metadata name="root_assocfilepath"/>/<gsf:metadata name="srclinkFile"/></xsl:attribute><gsf:choose-metadata><gsf:metadata name="thumbicon"/><gsf:metadata name="srcicon"/></gsf:choose-metadata></a></gsf:if></gsf:if-metadata-exists>
	  <xsl:text> </xsl:text><a><xsl:attribute name='href'><xsl:value-of select="$base-href"/><xsl:value-of select="$library_name"/>/collection/<xsl:value-of select='@collection'/>/document/<xsl:value-of select='@nodeID'/><xsl:if test="$opt-doc-link-args">?<xsl:value-of select="$opt-doc-link-args"/></xsl:if></xsl:attribute><xsl:call-template name='choose-title'/></a> (<a href='{$library_name}/collection/{@collection}/page/about'><xsl:value-of select="@collection"/> </a>)
	</xsl:template>
	
	<!-- this template for displaying the favourites list in plain text for email and copy buffer
        this will only be used if there ends up being no corresponding templates in siteConfig and collections. -->
	<xsl:template match="documentNode" mode="plain-text">
          <xsl:call-template name="displayPlainText"/>
        </xsl:template>

        <xsl:template name="displayPlainText">
          <xsl:call-template name='choose-title'/><xsl:text> (</xsl:text><xsl:value-of select="@collection"/><xsl:text>)</xsl:text>
	  <gsf:if-metadata-exists><gsf:metadata name="srclinkFile"/><gsf:if>
	  <xsl:text>\n\t</xsl:text>https://<xsl:value-of select="$base-href"/><xsl:value-of select="$library_name"/>/collection/<xsl:value-of select='@collection'/>/document/<xsl:value-of select='@nodeID'/>/assoc/<gsf:metadata name="srclinkFile"/></gsf:if></gsf:if-metadata-exists>
	  <xsl:text>\n\t</xsl:text>https:<xsl:value-of select="$base-href"/><xsl:value-of select="$library_name"/>/collection/<xsl:value-of select='@collection'/>/document/<xsl:value-of select='@nodeID'/><xsl:if test="$opt-doc-link-args">?<xsl:value-of select="$opt-doc-link-args"/></xsl:if>
	</xsl:template>

        
	<xsl:template name="customJavascript">
	</xsl:template>

	<xsl:template name="customCSS">
	</xsl:template>

</xsl:stylesheet>  

