var mapEnabled = false; // variable to detect when map-scripts have been included into document_scripts.js and classifier_scripts.js,
						// in which case this variable will be defined.
						// It will be furthermore be set to true iff we have gps map data that the map can display, false if map-scripts imported but no map data.

//var newLat, newLng = 0;
var _docList = {};
_docList.ids = [];

_docList.getDocByIndex = function(index)
{
	return _docList[_docList.ids[index]];
};

var _nearbyDocListByProximity = [];

var _map;
var _intervalHandle;
var _baseURL = document.URL.substring(0, document.URL.indexOf("?") + 1);
var _retrievedClassifiers = [];
var _preventLoopingSingleMarker = false;
var _searchRunning = false;
var _nearbyDocsByDistance = [];
var _scrollThroughDefault = true; // TODO: default is true

var LOW_OPACITY = 0.1; // make surrounding docs' opacity 10%
var _DEBUGGING_ = false;

function initializeMapScripts() 
{	
	//console.log("@@@@ initializeMapScripts()");

	var jsonNodeDiv = $("#jsonNodes");
	if(jsonNodeDiv.length)
	{
		//console.log("@@@ JSON node div html: " + jsonNodeDiv.html());
		var jsonNodes = eval(jsonNodeDiv.html());
		
		renderMap();
		if(jsonNodes && jsonNodes.length > 0)
		{
			mapEnabled = true;
			showMap("initializeMapScripts");
			
			var resultsArea = $('#resultsArea');
			if (resultsArea.length > 0){
				resultsArea.css('min-height','500px');
			}
			for(var i = 0; i < jsonNodes.length; i++)
			{
				_docList[jsonNodes[i].nodeID] = jsonNodes[i];
				_docList.ids.push(jsonNodes[i].nodeID);
				var options = {
					"mainDoc": true
				};
				//console.log("#### " + jsonNodes[i].nodeID + " is a main doc: ");
				//console.log(jsonNodes[i]);
				createOverlayItems(jsonNodes[i], options);
			}
			
			updateMap();
		}
		else
		{
			//hiding the map
			mapEnabled = false;
			hideMap("initializeMapScripts");			
			//return;
		}
	}	
	_docList.loopIndex = 0;
	
	if(_docList.ids.length > 1)
	{
		var startStopCheckbox = $("<input>", {"type": "checkbox", "checked": _scrollThroughDefault, "id": "scrollCheckbox"});
		startStopCheckbox.on("click", function()
		{
			// http://stackoverflow.com/questions/901712/how-to-check-if-a-checkbox-is-checked-in-jquery
			// http://stackoverflow.com/questions/5270689/attrchecked-checked-does-not-work
		
			if($('#scrollCheckbox').is(':checked')) // OR: if(document.getElementById('scrollCheckbox').checked)
			{			
				if(_intervalHandle == null)
				{
					_intervalHandle = setInterval(loopThroughMarkers, 2000);
				}
			}
			else
			{
				clearInterval(_intervalHandle);
				_intervalHandle = null;
			}
		});
		
		var label = $("<span>Scroll through places</span>");
		var container = $("<div>", {"class": "ui-widget-header ui-corner-all", "style": "clear:right; float:right; padding:0px 5px 3px 0px;"});
		container.append(startStopCheckbox);
		container.append(label);

		$(container).insertAfter("#map_canvas");

	    if (_scrollThroughDefault) {
		_intervalHandle = setInterval(loopThroughMarkers, 2000);
	    }
		
	}
}

function renderMap()
{
	//console.log("@@@@in map-scripts::renderMap()");	
	var myOptions = 
	    {
		zoom: 2,
		center: new google.maps.LatLng(0, 0),
		mapTypeId: google.maps.MapTypeId.HYBRID
	};
	var $map_canvas = $("#map_canvas");
	
	if ($map_canvas.length > 0) {
		//console.log("docList is " + _docList.toString());
		_map = new google.maps.Map($map_canvas[0], myOptions);
		//console.log("@@@ created Google _map");
		
		google.maps.event.addListener(_map, 'bounds_changed', performProximitySearch);
	}
}

function performProximitySearch()
{
    //console.log("@@@@ skipping proximity search for now");
    //return;
    
	_gsDebug("*** START OF performProximitySearch()");
	

	if(typeof mapEnabled === 'undefined') return;
	if(!mapEnabled){ return; }
	
	_gsDebug("*** Got past mapEnabled test");
	
	
	for(var i = 0 ; i < _nearbyDocListByProximity.length; i++) {
		removeMarkersFromMap(_nearbyDocListByProximity[i]);
	}
	_nearbyDocListByProximity = [];
	
	
	_debugPrintBounds(_map.getBounds(), "@@@ performProximitySearch():");	
	
	
	if(_searchRunning)
	{
		_gsInfo("*** performProximitySearch(): already running search => not initiating an additional search");
		return;
	}
	
	_searchRunning = true;
	
	var bounds = _map.getBounds();
	
	var neLat = bounds.getNorthEast().lat();
	var neLng = bounds.getNorthEast().lng();
	var swLat = bounds.getSouthWest().lat();
	var swLng = bounds.getSouthWest().lng();
	
	var latDistance = neLat - swLat;
	var lngDistance = neLng - swLng;
	
	_gsDebug("****************START*****************");
	_gsDebug("latDistance = " + latDistance);
	_gsDebug("lngDistance = " + lngDistance);
	
	//Check which increment to use for latitude (i.e. 0.001, 0.01, 0.1 or 1 degree increments)
	var latDelta;
	var latPrecision;
	for(var i = 3; i >= 0; i--)
	{
		latDelta = (1 / Math.pow(10, i));
		if((latDistance / latDelta) <= 5 || latDelta == 1)
		{
			latPrecision = i;
			break;
		}
	}
	
	//Check which increment to use for longitude (i.e. 0.001, 0.01, 0.1 or 1 degree increments)
	var lngDelta;
	var lngPrecision;
	for(var i = 3; i >= 0; i--)
	{
		lngDelta = (1 / Math.pow(10, i));
		// Want the grid superimposed on the map to be 5 or fewer steps,
		// where delta is the grid size to make it so
		// and precision is the number of decimal places.
		if((lngDistance / lngDelta) <= 5 || lngDelta == 1)
		{
			lngPrecision = i;
			break;
		}
	}	
	
    if(latDelta == 0.1){latDelta = 1; latPrecision = 0; }
    if(lngDelta == 0.1){lngDelta = 1; lngPrecision = 0; }
	
	
	
	_gsDebug("Proximity search: lat precision BEFORE = " + latPrecision);
	_gsDebug("Proximity search: lng precision BEFORE = " + lngPrecision);
	
	// Want consistent precision for both lat and lng.
	// So we choose the most conservative (whichever is more zoomed out) for both
	if(latPrecision < lngPrecision) {
		lngPrecision = latPrecision;
	} else if (lngPrecision < latPrecision) {
		latPrecision = lngPrecision;
	}
	
	_gsDebug("Proximity search: lat precision AFTER = " + latPrecision);
	_gsDebug("Proximity search: lng precision AFTER = " + lngPrecision);
	_gsDebug("Proximity search with: latDelta = " + latDelta);
	_gsDebug("Proximity search with: lngDelta = " + lngDelta);
	
	var query = "";
	var iMax = Math.floor(latDistance / latDelta) + 1;
	var jMax = Math.floor(lngDistance / lngDelta) + 1;
	
	_gsDebug("Proximity search with: iMax = " + iMax);
	_gsDebug("Proximity search with: jMax = " + jMax);
	
	_gsDebug("****************END*****************");
	
	for(var i = 0; i <= iMax; i++) //for(var i = 0; i <= Math.floor(latDistance / latDelta) + 1; i++)
	{
		for(var j = 0; j <= jMax; j++) //for(var j = 0; j <= Math.floor(lngDistance / lngDelta) + 1; j++)
		{
			//Some necessary variables
			var newLat = neLat - (latDelta * i);
			var newLatString = "" + newLat;
			var newLatTrunc;
			if(newLat < 0){newLatTrunc = Math.ceil(newLat);}
			else{newLatTrunc = Math.floor(newLat);}
			
			var newLng = neLng - (lngDelta * j);
			var newLngString = "" + newLng;
			var newLngTrunc;
			if(newLng < 0){newLngTrunc = Math.ceil(newLng);}
			else{newLngTrunc = Math.floor(newLng);}

			//Construct query
			query += "(";
			query += "CS:\"" + coordToAbsDirected(newLatTrunc, "lat");
			
			if(latDelta != 1)
			{ 
				query += newLatString.substring(newLatString.indexOf(".") + 1, newLatString.indexOf(".") + latPrecision + 1);
			}
			query += " ";			
			query += coordToAbsDirected(newLngTrunc, "lng");
			if(lngDelta != 1)
			{ 
				query += newLngString.substring(newLngString.indexOf(".") + 1, newLngString.indexOf(".") + lngPrecision + 1);
			}
			query += "\"";			
			query += ")";

			if(i != iMax || j != jMax){ query += " OR "; } //if(i != (Math.floor(latDistance / latDelta) + 1) || j != (Math.floor(lngDistance / lngDelta) + 1)){ query += " OR "; }
		}
	}
	
	// This works, why not from the double loop above?
	//query = "(CS:\"" + coordToAbsDirected(newLatTrunc, "lat") + " " + coordToAbsDirected(newLngTrunc, "lng") + "\")";	
	//alert("@@@@in map-scripts::performProximitySearch() - query: " + query);
	
	//var url = gs.xsltParams.library_name + "?a=q&s=RawQuery&rt=rd&c=" + gs.cgiParams.c + "&s1.rawquery=" + query + "&excerptid=jsonNodes";
	var url = gs.xsltParams.library_name;
	var data = "a=q&s=RawQuery&rt=rd&c=" + gs.cgiParams.c + "&s1.rawquery=" + query + "&excerptid=jsonNodes";
	_gsDebug("*** performProximitySearch(): rawQuery query data = " + query);
	
	$.ajax({type:"POST", url:url, data:data})
	.done(function(responseText)
	{
		//console.log("*** responseText (first 250) = " + responseText.substring(0,256));
		
		if(responseText.search("id=\"jsonNodes") != -1)
		{
			var startIndex = responseText.indexOf(">");
			var endIndex = responseText.indexOf("</");

			//console.log("@@@@ performSearch, got response: " + responseText);

			var jsonNodes = eval(responseText.substring(startIndex+1, endIndex));
			_gsDebug("@@@@ performProximitySearch - Number of matches returned from ajax rawQuery search = " + jsonNodes.length);
			if(jsonNodes && jsonNodes.length > 0)
			{
				for(var i = 0; i < jsonNodes.length; i++)
				{
					var doc = jsonNodes[i];
					
					var found = false;
					for(var j = 0; j < _docList.ids.length; j++) {
						if(doc.nodeID == _docList.ids[j]) {
							found = true;
							_gsDebug("performProximitySearch(): Found nearby ID " + doc.nodeID + " was already drawn:", jsonNodes[i]);
							break;
						}
					}
					
					if(!found)
					{
						_nearbyDocListByProximity.push(doc);
						createOverlayItems(doc, {"mainDoc": false});					
					}
					
				}
			}
		}
		else
		{
			console.log("map-scripts::performProximitySearch(): No JSON information received");
		}
		
		_searchRunning = false;
	}).fail(function(responseText, textStatus, errorThrown) // fail() has replaced error(), http://api.jquery.com/jquery.ajax/
		{
			console.log("In map-scripts.performProximitySearch(): Got an error in ajax call");
			_searchRunning = false;
	});
}

function coordToAbsDirected(coord, type)
{
	var value = "" + coord;
	if(coord < 0)
	{
		value = value.substring(1);
		if(type == "lat")
		{
			value += "S";	
		}
		else
		{
			value += "W";
		}
	}
	else
	{
		if(type == "lat")
		{
			value += "N";	
		}
		else
		{
			value += "E";
		}
	}
	
	return value;
}

function facetedMapSearch(facet_request_url) {
    // ask for just the jsonNodes
    facet_request_url += "excerptid=jsonNodes";
    
    $.ajax(facet_request_url).done(function(responseText) {
	var doc;
	var nodeID;
	
	//console.log("Sent off facetedMapSearch request to " + facet_request_url +  ", got response: ");
	//console.log(responseText);

	if(responseText.search("id=\"jsonNodes") != -1) {
	    var startIndex = responseText.indexOf(">");
	    var endIndex = responseText.indexOf("</");
	    var jsonNodes = eval(responseText.substring(startIndex+1, endIndex));
	    //console.log(jsonNodes);	
	    
	    if(jsonNodes && jsonNodes.length > 0) {
		//console.log("Faceted search got some nodes. Removing all markers first...");

		
		mapEnabled = true;
		showMap("initializeMapScripts");

		// Remove all the markers/shapes from map
		// and empty _docList.ids and the _docList of items
		for(var j = 0; j < _docList.ids.length; j++) {
		    nodeID = _docList.ids[j]; 
		    doc = _docList.getDocByIndex(j);
		    removeMarkersFromMap(doc);
		    delete _docList[nodeID];
		}
		_docList.ids = [];

		// repopulate _docList and _docList.ids and plot on map
		for(var i = 0; i < jsonNodes.length; i++)
		{
		    _docList[jsonNodes[i].nodeID] = jsonNodes[i];
		    _docList.ids.push(jsonNodes[i].nodeID);
		    var options = {
			"mainDoc": true
		    };
		    createOverlayItems(jsonNodes[i], options);
		}

		// redo map bounds, which will also performProximitySearch
		updateMap();
	    }
	    else
	    {
		//hiding the map
		mapEnabled = false;
		hideMap("initializeMapScripts");		
	    }
	}	
	_docList.loopIndex = 0;
	
    });
    
}


function toggleMapSection(options)
{
	var sectionID = options["nodeID"];
	
	var titleClassifierEl = document.getElementById("title"+sectionID);
	var jsonNodesStr = titleClassifierEl.getAttribute("data-gps-map-json");
	//alert("@@@@ got jsonNodesStr |" + jsonNodesStr + "|");
	var jsonNodes = JSON.parse(jsonNodesStr);
	
	if(options["expand"]){
		_gsDebug("expanding classifier - sectionID: " + sectionID);		
		
		if(jsonNodes && jsonNodes.length > 0)
		{
			for(var i = 0; i < jsonNodes.length; i++)
			{
				var doc = jsonNodes[i];
				if(_docList[doc.nodeID]) continue; // already in list, don't add again
				
				_docList[doc.nodeID] = doc;
				_docList.ids.push(doc.nodeID);
	
				var options = {
					"mainDoc": true // TODO: should this be true or false???
				};
				createOverlayItems(doc, options);
			}				
		}
		
	} else { // closing the bookshelf
		_gsDebug("closing classifier - sectionID: " + sectionID);
		if(jsonNodes && jsonNodes.length > 0)
		{
			for(var i = 0; i < jsonNodes.length; i++)
			{
				// remove the doc from _docList and its id from _docList.ids
				// and remove its markers/shapes from the map
				var nodeID = jsonNodes[i].nodeID;
				var doc = _docList[nodeID];
				if(doc) {
					removeMarkersFromMap(doc);
					
					delete _docList[nodeID];	
					
					var filtered_ids_to_keep = [];
					for(var j = 0; j < _docList.ids.length; j++) {
						if(_docList.ids[j] !== nodeID) {
							filtered_ids_to_keep.push(_docList.ids[j]);
						}
					}
					
					_docList.ids = filtered_ids_to_keep;
					
				} else {
					console.log("**** In toggleMapSection: shouldn't happen - failed to find doc on closing node: " + nodeID);
				}
			}		
			
		}
	}
	
	_debugPrintDocList();
	
	mapEnabled = (_docList.ids.length > 0);	
	
	if(mapEnabled) {
		showMap("toggleMapSection");
	} else {
		hideMap("toggleMapSection");
	}
	
	
}

/* Given a doc, removes all its shapes doc.shapes from the map _map */
function removeMarkersFromMap(doc) {
    if (doc.shapes) {
	for(var i = 0; i < doc.shapes.length; i++) {
		var shape = doc.shapes[i];
		shape.setMap(null);
	}
    }
}

// Refer to https://developers.google.com/maps/documentation/javascript/reference/map#Map.fitBounds
// In order for fitBounds() to work out a non-zero bounds, have to use visibility, not display when hiding/showing the map.
// AND should not set height to 0px when using visibility hidden. But not setting height to 0 means an invisible map takes up space.
// In order for the resulting invisible map, that still takes up space, to not break the flow of the visible items
// on the page, need to swap map between position relative when map visible versus position absolute when the map is hidden.
function showMap(callingFunction) {
	
	//$("#map_canvas").css({display:"block"});
	//$("#map_canvas").css({visibility:"visible", height:"100%"}); // not working in conjunction with hidden 0px
	//$("#map_canvas").css({visibility:"visible", height: "400px"}); // but this works in conjunction with hidden 0px
	$("#map_canvas").css({visibility:"visible", position: "relative"});
	
	if(!_DEBUGGING_) return;
	
	//var message = "map_canvas display BLOCK";
	var message = "map_canvas visibility VISIBLE, position relative";
	if(typeof callingFunction !== 'undefined') {
		message = "showMap() called from" + callingFunction + ":" + message;
	}
	console.log("### " + message);
}

function hideMap(callingFunction) {
	//$("#map_canvas").css({display:"none"});
	//$("#map_canvas").css({visibility:"hidden", height:"0px"});
	$("#map_canvas").css({visibility:"hidden", position:"absolute"});
	
	if(!_DEBUGGING_) return;
	
	//var message = "map_canvas display NONE";
	var message = "map_canvas visibility HIDDEN, position absolute";
	if(typeof callingFunction !== 'undefined') {
		message = "hideMap() called from" + callingFunction + ":" + message;
	}
	console.log("### " + message);	
}

function updateMap()
{
	//console.log("@@@ updateMap()");
    var markersOnMap = 0;
    var bounds =  new google.maps.LatLngBounds();
	
	for(var i = 0; i < _docList.ids.length; i++)
	{
		var doc = _docList.getDocByIndex(i);
		if(doc.parentCL && doc.parentCL.style.display == "none")
		{
			if(doc.shapes) {
				for(var x = 0; x < doc.shapes.length; x++) {
					doc.shapes[x].setVisible(false);
				}
			} else {
				doc.marker.setVisible(false);
			}
			continue;
		}
		else
		{
			if(doc.shapes) {
				for(var x = 0; x < doc.shapes.length; x++) {					
					doc.shapes[x].setVisible(true);
					markersOnMap += ShapesUtil.numberOfCoordinatesInBounds(doc.shapes[x]);
				}				
			} else {
				doc.marker.setVisible(true);
				markersOnMap++;
			}
			
		}
		
		if(doc.shapes) {			
			var docSection_overlay_bounds = ShapesUtil.overlayBounds(doc.shapes);
			// We now have the current document or document subsection's bounds.
			// Use this to extend the overall bounds (the cumulative bounds for all nearby documents,
			// or at least the cumulative bounds for this document with all its subsections).
			bounds.extend(docSection_overlay_bounds.getNorthEast());
			bounds.extend(docSection_overlay_bounds.getSouthWest()); 
		}
		else {
			var doc_latlng = new google.maps.LatLng(doc.lat, doc.lng);
 	        bounds.extend(doc_latlng);
		}
	}
	
	_debugPrintBounds(bounds, "@@@ UpdateMap():");
	
	
	if(markersOnMap > 1)
    {
		_debugPrintBounds(_map.getBounds(), "@@@ UpdateMap() : BEFORE fitbounds, map");	
		
		_map.fitBounds(bounds);		
		
		_debugPrintBounds(_map.getBounds(), "@@@ UpdateMap() : AFTER fitbounds, map");
    } else if (markersOnMap == 1) {
		//console.log("@@@ updating bounds with " + markersOnMap + " markers on the map");
		//console.log(bounds);
		
		// sometimes a single point bounds are too small for the map to display, so use center and zoom instead of fitbounds.
		_map.setCenter(bounds.getCenter());
		_map.setZoom(18); // arbitrary value that looked nice for my example
    }
}


// TODO: FUNCTION DUPLICATED IN panoramaViewer.js
function getLatLngForCoord(coord) {
	
	// https://stackoverflow.com/questions/2559318/how-to-check-for-an-undefined-or-null-variable-in-javascript
	if(!coord) {
		 // some_variable is either null, undefined, 0, NaN, false, or an empty string
		console.log("@@@@ In map-scripts::getLatLngForCoord(): no or invalid coord info");
		return null;
	}
	
	// coord is of the form: "37S77 157E53"
	// lat will be 37S77, lng 157E53.
	var indexOfSpace = coord.indexOf(" ");
	if(indexOfSpace === -1) {
		console.log("@@@@ In map-scripts::getLatLngForCoord(): bad format for coord  " + coord);
		return null;
	}
	var latitude = coord.substring(0, indexOfSpace);
	var longitude = coord.substring(indexOfSpace+1);
	return {lat: latitude, lng: longitude}; // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Working_with_Objects
}

function loopThroughMarkers()
{
	if(_docList.ids.length == 0)
	{
		return;
	}

	var doc;
	var visibleMarkers = new Array();
	for(var i = 0; i < _docList.ids.length; i++)
	{
		//var doc = _docList.getDocByIndex(i);
	                 // NOTE: in JavaScript, "local" vars have function scope, not mere block level scope. Wherever declared inside a function, they get hoisted to function top.
	                 // See https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/var
	                 // But this feature is confusing, so have now declared var doc nearer to function top, at function level so outside current local block, and am assigning here:
		doc = _docList.getDocByIndex(i);
		if(typeof doc.shapes !== 'undefined') {
			for(var x = 0; x < doc.shapes.length; x++) {
				var shape = doc.shapes[x];
				if(shape.type === google.maps.drawing.OverlayType.MARKER && shape.getVisible())
				{
					visibleMarkers.push(doc);
				}				
			}
		}
		if(doc.marker && doc.marker.getVisible())
		{
			visibleMarkers.push(doc);		
		}		
	}
	
	if(visibleMarkers.length < 2)
	{
		clearAllInfoBoxes();
		return;
	}

	clearAllInfoBoxes();
	
	var elem = null;
	while(!elem) // TODO: why redefine elem? Why does this work, and only this, but not while(true) or while(doc.marker) or while(!AnythingFalse)???
				// Some clever behaviour here, but no documentation on the cleverness. Hard to understand
	{
		if(_docList.loopIndex >= visibleMarkers.length)
		{
			_docList.loopIndex = 0;
		}

		//var doc = visibleMarkers[_docList.loopIndex]; // See NOTE above.
		doc = visibleMarkers[_docList.loopIndex];
		elem = gs.jqGet("div" + doc.nodeID); // This used to redefine elem by doing var elem = <....>
		// This worked because "If you re-declare a JavaScript variable, it will not lose its value." See https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/var
		if(elem.length)
		{
			elem.css("background", "#BBFFBB");
			setTimeout(function(){elem.css("background", "");}, 2000);
		}
		_docList.loopIndex ++;		
	}	

	_gsDebug("@@@ loopThroughmarkers() - DOC:", doc);
    
	if(doc.marker) {
		doc.marker.markerInfo.open(_map, doc.marker); // TODO: how does doc have a value here? Where is the value set at this block level?
	}
	
	if(doc.shapes) {			
		for(var x = 0; x < doc.shapes.length; x++) {
			var shape = doc.shapes[i];
			if(typeof shape === 'undefined') { // happens just after map page has loaded when scrolling through markers. Why does this happen
				console.log("shape at " + x + " not defined");
				continue;
			}
			if(shape.type === google.maps.drawing.OverlayType.MARKER) {
				shape.markerInfo.open(_map, shape);
			} else {
				shape.markerInfo.open(_map);
			}
		}
	}	
}


function focusDocument(id)
{	
	var doc = _docList[id];
	if(doc)
	{
		clearInterval(_intervalHandle);
		_intervalHandle = null;
		 
		if(doc.shapes) {			
			var docShapesBounds = ShapesUtil.overlayBounds(doc.shapes);
			_map.panToBounds(docShapesBounds); // https://developers.google.com/maps/documentation/javascript/reference/map#Map.panToBounds
		} else {
			_map.panTo(new google.maps.LatLng(doc.lat, doc.lng));
		}
		
		clearAllInfoBoxes();
		if(doc.shapes) { // TODO		
			//console.log("Opening infowindow for doc " + doc.nodeID);
			for(var x = 0; x < doc.shapes.length; x++) {
				if(doc.shapes[x].markerInfo) {					
					doc.shapes[x].markerInfo.open(_map); // label
				}
				else {
					console.log("No infowindow for doc " + doc.nodeID + "'s shape " + doc.shapes[x].type);
				}
			}
			//openInfoBoxes(doc);
		} else { // only Lat and Lng meta, so we have just one marker per doc, which will have the doc title not label
			doc.marker.markerInfo.open(_map, doc.marker); // doc title
		}
		var scrollCheckbox = $("#scrollCheckbox");
		if(scrollCheckbox.checked)
		{
			scrollCheckbox.checked = false;
		}
	}
}

function clearAllInfoBoxes()
{
	for(var i = 0; i < _docList.ids.length; i++)
	{
		var doc = _docList.getDocByIndex(i);
		
		if(doc.shapes) {
			for(var x = 0; x < doc.shapes.length; x++) {
				if(doc.shapes[x].markerInfo) {
					//console.log("Closing infowindow for doc " + _docList.ids[i]);
					doc.shapes[x].markerInfo.close();					
				}
			}
		}
		else { // only Lat and Lng meta, so we have just one marker per doc
			doc.marker.markerInfo.close();
		}
	}
}

function createOverlayItems(doc, options) {
	var loopCounter = 0;
	if(doc.mapoverlay || doc.descendantsMapoverlays) {
		if(doc.mapoverlay) {
			// append any descendant section's mapoverlays onto doc.mapoverlay
			if(doc.descendantsMapoverlays) {
				for(loopCounter = 0; loopCounter < doc.descendantsMapoverlays.length; loopCounter++) {
					//console.log("Pushing next descendant mapoverlay onto doc.mapoverlay: ", doc.descendantsMapoverlays[loopCounter]);
					Array.prototype.push.apply(doc.mapoverlay, doc.descendantsMapoverlays[loopCounter]);					
				}
				delete doc.descendantsMapoverlays; // served its purpose
			}
		} else if (doc.descendantsMapoverlays) { // no doc.mapoverlay
			// construct doc.mapoverlay to contain each descendant section's mapoverlay
			doc.mapoverlay = [];
			for(loopCounter = 0; loopCounter < doc.descendantsMapoverlays.length; loopCounter++) {
				//console.log("Pushing next descendant mapoverlay onto originally empty doc.mapoverlay: ", doc.descendantsMapoverlays[loopCounter]);
				Array.prototype.push.apply(doc.mapoverlay, doc.descendantsMapoverlays[loopCounter]);
			}			
			delete doc.descendantsMapoverlays;  // no more use for this
		}
		//console.log("@@@@ Have shapes: ", doc.mapoverlay);		
		createShapes(doc, options);
	} else { // backwards compatible to deal with Lat and Lng meta stored for doc
		pos = new google.maps.LatLng(doc.lat,doc.lng);
		createMarker(doc, pos, options);
	}
}

function addInfoMarker(doc, shape) {
	
	if(!shape.description) {
		_gsInfo("#### " + shape.type.toString() + " had no description/label");
		return;
	}
	
	// else add an InfoWindow for this shape using the label (shape.description)
	
	// https://developers.google.com/maps/documentation/javascript/infowindows
	// An InfoWindow's "position contains the LatLng at which this info window is anchored.
	// Note: An InfoWindow may be attached either to a Marker object (in which case its position is based on the marker's location)
	// or on the map itself at a specified LatLng. Opening an info window on a marker will automatically update the position."
	var infoWindow = new google.maps.InfoWindow({content:shape.description}); // NOTE: if not setting content or position properties
			// inside this constructor, need to call setContent/setPosition to set them
	
	if(shape.type === google.maps.drawing.OverlayType.MARKER) {
		var marker = shape;
		_gsDebug("Coord for marker is " + marker.getPosition().toString());
		
		marker.addListener('mouseover', function() {
          infoWindow.open(_map, marker);
		});
		marker.addListener('mouseout', function() {
			infoWindow.close();
		});
		attachClickHandler(marker, doc.nodeID); // do what the original code used to do here
	}
	else {
		var coord = ShapesUtil.getLabelCoordinate(shape);
		_gsDebug("Coord for " + shape.type.toString() + " is " + coord.toString());
		infoWindow.setPosition(coord);
		shape.addListener('mouseover', function() {
			infoWindow.open(_map);
		});
		shape.addListener('mouseout', function() {
			infoWindow.close();
		});
		attachClickHandler(shape, doc.nodeID); // as above		
	}
	shape.markerInfo = infoWindow;
	//console.log("######## Added markerInfo object to shape");	
}

// This function will create Google Shapes/Overlays and markers out of a given doc JSONNode's doc.mapOverlay
// (doc.mapOverlay shapes are stored as an array of JSON) and store the shapes/overlays in the doc.shapes array.
function createShapes(doc, options)
{	
	var isMainDoc = options["mainDoc"];

	// for doc.shapes: don't store JSON anymore, convert them to google Shapes overlays and store them instead
	doc.shapes = [];
	
	for (var i=0; i<doc.mapoverlay.length; i++) {
		//console.log("in: mapoverlay["+i+"] =" + JSON.stringify(doc.mapoverlay[i]));
		var shape = ShapesUtil.JSONToShape(doc.mapoverlay[i]);	
		//console.log("out: shape = " + JSON.stringify(shape));
		
		doc.shapes[i] = shape;		
		shape.setMap(_map);
		//shape["title"] = doc.title;  // TODO: Think on it some more.
		
		// Unset editable and draggable properties of shape
		// And for markers, which are initialised to clickable besides, undo the clickability
		// and set them 
		if(shape.type === google.maps.drawing.OverlayType.MARKER) {
			var marker = shape;
			// markers of the main document should be red, else they'll be blue
			if(!isMainDoc) {
				marker["icon"] = "interfaces/" + gs.xsltParams.interface_name + "/images/bluemarker.png";
			}
			marker.clickable = false; // only markers
			/*
			console.log("@@@ map-scripts::addInfoMarker - marker.position");
			console.log("Lat is " + typeof(marker.position.lat()));
			console.log(marker.position.lat());
			console.log("Long is " + typeof(marker.position.lng()));
			console.log(marker.position.lng());	
			*/
		} else {			
			//console.log("Creating non-marker shape.");
			
			if(!isMainDoc) {
				ShapesUtil.setOpacity(shape, LOW_OPACITY);
			} // else the shape will be drawn at its configured opacity
		}
		
		shape.editable = false;
		shape.draggable = false;
		
		
		// doc[i]'s label = doc.shapes[i].description
		addInfoMarker(doc, shape);
	}
	
	var docElement = gs.jqGet("div" + doc.nodeID);
	var parent;
	if(docElement)
	{
		parent = docElement.parentNode;
	}

	while(parent && parent.nodeName != "BODY")
	{
		if($(parent).attr("id") && $(parent).attr("id").search("divCL") != -1)
		{
			doc.parentCL = parent;
			break;
		}
		
		parent = parent.parentNode;
	}
}

// This method is only for backwards compatibility: for those collections with docs that only have Lat and Lng meta
// and no GPS.mapOverlay (and hence Coordinate) meta.
function createMarker(doc, pos, options)
{	
	var isMainMarker = options["mainDoc"];
	
	var marker;
	if(isMainMarker)
	{
		marker = new google.maps.Marker
		({
			position: pos,
			title:doc.title,
			map:_map
		});
	}
	else
	{
		marker = new google.maps.Marker
		({
			position: pos,
			title:doc.title,
			map:_map,
			icon:"interfaces/" + gs.xsltParams.interface_name + "/images/bluemarker.png"
		});
	}

	var docElement = gs.jqGet("div" + doc.nodeID);
	var parent;
	if(docElement)
	{
		parent = docElement.parentNode;
	}

	while(parent && parent.nodeName != "BODY")
	{
		if($(parent).attr("id") && $(parent).attr("id").search("divCL") != -1)
		{
			doc.parentCL = parent;
			break;
		}
		
		parent = parent.parentNode;
	}

	var info = new google.maps.InfoWindow({content:doc.title});
	marker.markerInfo = info;
	doc.marker = marker;
	attachClickHandler(marker, doc.nodeID);
}

// TODO: with the following, it seems that clicking on shape expands the entire document
// Should it be that clicking on a shape should expand the doc section that contains that shape meta?
function attachClickHandler(shapeOrMarker, nodeID)
{
	google.maps.event.addListener(shapeOrMarker, 'click', function()
	{
		document.location.href = gs.xsltParams.library_name + "?a=d&ed=1&c=" + gs.cgiParams.c + "&d=" + nodeID + "&dt=hierarchy&p.a=b&p.sa=&p.s=ClassifierBrowse";
	});
}

function NewLatLng(lat, lng)
{
	console.log("Latitude " + lat);
	console.log("Longitude " + lng);
}

function httpMapBrowseRequest(sectionID)
{
	// Make ajax call to retrieve jsonNodes for section ID, and draw shapes on the map.
	var url = gs.xsltParams.library_name + "?a=b&rt=s&s=ClassifierBrowse&c=" + gs.cgiParams.c + "&cl=" + sectionID + "&excerptid=jsonNodes";
	$.ajax(url)
	.done(function(responseText)
	{
		var startIndex = responseText.indexOf(">");
		var endIndex = responseText.indexOf("</");
		
		var jsonNodesStr = responseText.substring(startIndex+1, endIndex);
		var jsonNodes = eval(jsonNodesStr); //responseText.substring(startIndex+1, endIndex));
		if(jsonNodes && jsonNodes.length > 0)
		{
			
			mapEnabled = true;
			showMap("httpMapBrowseRequest");
			
			for(var i = 0; i < jsonNodes.length; i++)
			{
				var doc = jsonNodes[i];
				_docList[doc.nodeID] = doc;
				_docList.ids.push(doc.nodeID);
	
				var options = {
					"mainDoc": true // TODO: should this be true or false???
				};
				createOverlayItems(doc, options);
			}
			
			///var tmp = $("#title"+sectionID);			
			///console.log(tmp);		// WRONG
			///var tmp2 = document.getElementById("title"+sectionID);
			///console.log(tmp2);		// RIGHT, WHY?
			
			// create data-* attribute to store this sectionID's JSON on the section's div			
			//$("#title"+sectionID).attr("data-gps-map-json", "hello world"); // TODO: Doesn't work. Why?
			var titleClassifierEl = document.getElementById("title"+sectionID);
			titleClassifierEl.setAttribute("data-gps-map-json", jsonNodesStr);
		}
		
		updateMap();
		//console.log("getSub Classifier -> updateMap()");
	})
	.fail(function()
	{
		//console.log("Error getting subclassifiers");
		return;
	});	
}

function performDistanceSearchWithCoordinates(id, coord, degrees)
{
	var coordInfo = getLatLngForCoord(coord);
	if(!coordInfo) {
		console.log("@@@ ERROR in map-scripts::performDistanceSearchWithCoordinates: coordInfo is null");		
	}
	performDistanceSearch(id, coordInfo.lat, coordInfo.lng, degrees);
}

function performDistanceSearch(id, lat, lng, degrees)
{
	if(parseFloat(lat) > 180 || parseFloat(lat) < -180 || parseFloat(lng) > 180 || parseFloat(lat) < -180)
	{
		console.log("Latitude or longitude incorrectly formatted");
		return;
	}

	if(lat.indexOf(".") == -1 || lng.indexOf(".") == -1 || (lat.indexOf(".") + 3) >= lat.length || (lng.indexOf(".") + 3) >= lng.length)
	{
		console.log("Latitude or longitude does not have the required precision for a distance search");
		return;
	}
	
	var query = "";
	for(var i = 0; i < degrees * 2; i++)
	{
		for (var j = 0; j < degrees * 2; j++)
		{
			var latDelta = (i - degrees) * 0.01;
			var lngDelta = (j - degrees) * 0.01;
			
			//query += "(" + getDistanceQueryStringOldApproach(lat, latDelta, 2, "LA", ["N","S"]);
			//query += "+AND+";
			//query += getDistanceQueryStringOldApproach(lng, lngDelta, 2, "LN", ["E","W"]) + ")";
			
			query += "(" + getDistanceQueryStringTerm(lat, lng, latDelta, lngDelta, 2, "CS") + ")";
			
			if(i != ((degrees * 2) - 1) || j != ((degrees * 2) - 1)){ query += " OR "; }
		}
	}

	var inlineTemplate = '\
	<xsl:template match="/" priority="5">\
		<table id="nearbyDocs">\
			<tr>\
				<th><a href="javascript:sortByDistance();">Distance</a></th><th><a href="javascript:sortAlphabetically();">Document</a></th>\
			</tr>\
			<xsl:apply-templates select="//documentNode"/>\
		</table>\
	</xsl:template>\
	\
	<xsl:template match="documentNode" priority="5">\
             <xsl:if test="@nodeID !=\''+id+'\'">\
		<tr>\
			<td>___<gsf:metadata name="Latitude"/>______<gsf:metadata name="Longitude"/>___</td>\
			<td><gsf:link title="'+gs.text.doc.nearby_doc_tooltip+'" type="document"><gsf:metadata name="Title"/></gsf:link></td>\
		</tr>\
             </xsl:if>\
	</xsl:template>';

        var url = gs.xsltParams.library_name + "?a=q&s=RawQuery&rt=rd&c=" + gs.cgiParams.c + "&s1.rawquery=" + query + "&excerptid=nearbyDocs&ilt=" + inlineTemplate.replace(/ /, "%20");
	$.ajax(url)
	.done(function(response)
	{
		response = response.replace(/<img src="[^"]*map_marker.png"[^>]*>/g, "");

		var nearbyDocsArray = new Array();

		var lats = new Array();
		var lngs = new Array();
		var matches = response.match(/___(-?[0-9\.]*)___/g);
		for(var i = 0; i < matches.length; i += 2)
		{
			var matchLatFloat = parseFloat(matches[i].replace("___", ""));
			var matchLngFloat = parseFloat(matches[i+1].replace("___", ""));

			lats.push(matchLatFloat);
			lngs.push(matchLngFloat);
			var distance = Math.sqrt(Math.pow(matchLatFloat - parseFloat(lat), 2) + Math.pow(matchLngFloat - parseFloat(lng), 2)) * (40000.0/360.0);
  		        var distanceString = "" + distance;
		        distanceString = distanceString.substring(0, 6);
			response = response.replace(matches[i] + matches[i+1], distanceString);
		}
		
		var index = 0;
		var i = 0;
		while(true)
		{
			var distanceStart = response.indexOf("<td>", index);
			if(distanceStart == -1)
			{
				break;
			}
			var distanceEnd = response.indexOf("</td>", distanceStart);
			
			var docLinkStart = response.indexOf("<td>", distanceEnd);
			var docLinkEnd = response.indexOf("</td>", docLinkStart);
			
		        var dist = response.substring(distanceStart + 4, distanceEnd);
			var docLink = response.substring(docLinkStart + 4, docLinkEnd);

			_nearbyDocsByDistance.push({title:docLink, distance:dist, lat:lats[i], lng:lngs[i++]}); 
			
			index = docLinkEnd;
		}
		
	    sortByDistance(lat,lng);
		
		var toggle = $("#nearbyDocumentsToggle");
		toggle.attr("src", gs.imageURLs.collapse);
		gs.functions.makeToggle(toggle, $("#nearbyDocuments"));
	});
}

var map_centering_timeout = null;
function recenterMapF(lat, lng)
{
    return function() {
	_map.setCenter(new google.maps.LatLng(lat, lng));
    }
}
function recenterMap(lat, lng)
{

	_map.setCenter(new google.maps.LatLng(lat, lng));

}
function sortByDistance(base_lat,base_lng)
{
	var sortedTable = '<table id="nearbyDocs" onmouseleave="clearTimeout(map_centering_timeout); recenterMap('+base_lat+','+base_lng+');"><tr><th><a href="javascript:;">Distance</a></th><th><a href="javascript:sortAlphabetically('+base_lat+', '+base_lng+');">Document</a></th></tr>';
	_nearbyDocsByDistance.sort(function(a, b){return (a.distance - b.distance);});
	for(var i = 0; i < _nearbyDocsByDistance.length; i++)
    {
	
	    sortedTable += "<tr><td>" + prettifyDistance(_nearbyDocsByDistance[i].distance) + '</td><td onmouseover="clearTimeout(map_centering_timeout); map_centering_timeout = setTimeout(recenterMapF(' + _nearbyDocsByDistance[i].lat + ',' + _nearbyDocsByDistance[i].lng + '), 900)" >' + _nearbyDocsByDistance[i].title + "</td></tr>";
	}
	sortedTable += "</table>";
	
	$("#nearbyDocuments").html(sortedTable);
}
function prettifyDistance(distance) {

    var new_distance;
    if (distance < 1) {
	new_distance = (distance * 1000);
	// Round to nearest whole number - don't need to show points of metres..
	new_distance = Math.round(new_distance);
	new_distance += " m";
    }
    else {
	new_distance = distance +" km";
	
    }
    return new_distance;
}

    

function sortAlphabetically(base_lat, base_lng)
{
	var sortedTable = '<table id="nearbyDocs" onmouseleave="clearTimeout(map_centering_timeout); recenterMap('+base_lat+','+base_lng+');"><tr><th><a href="javascript:sortByDistance('+base_lat+', '+base_lng+');">Distance</a></th><th><a href="javascript:;">Document</a></th></tr>';
	_nearbyDocsByDistance.sort(function(a, b)
	{
		var firstTitleStartIndex = a.title.indexOf(">");
		var firstTitleEndIndex = a.title.indexOf("<", firstTitleStartIndex);
		var firstTitle = a.title.substring(firstTitleStartIndex + 1, firstTitleEndIndex);
		var secondTitleStartIndex = b.title.indexOf(">");
		var secondTitleEndIndex = b.title.indexOf("<", secondTitleStartIndex);
		var secondTitle = b.title.substring(secondTitleStartIndex + 1, secondTitleEndIndex);
		return ((firstTitle.toLowerCase() == secondTitle.toLowerCase()) ? 0 : ((firstTitle.toLowerCase() > secondTitle.toLowerCase()) ? 1 : -1));
	});
	for(var i = 0; i < _nearbyDocsByDistance.length; i++)
	{
		sortedTable += "<tr><td>" + _nearbyDocsByDistance[i].distance + '</td><td onmouseover="clearTimeout(map_centering_timeout); map_centering_timeout = setTimeout(recenterMapF(' + _nearbyDocsByDistance[i].lat + ',' + _nearbyDocsByDistance[i].lng + '), 900)">' + _nearbyDocsByDistance[i].title + "</td></tr>";
	}
	sortedTable += "</table>";
	
	$("#nearbyDocuments").html(sortedTable);
}

function getDistanceQueryStringOldApproach(currentCoord, delta, precision, indexName, directions)
{
	console.error("**** Old Approach called!!!");
	
	var query = "";
	var coordFloat = parseFloat(currentCoord);

	var newCoord = "" + (coordFloat + delta);
	var beforeDec = newCoord.substring(0, newCoord.indexOf("."));

	var direction = directions[0];
	if(coordFloat < 0)
	{
		// negative value
		direction = directions[1];
		beforeDec = beforeDec.substring(1); // skip over '-' at front
	}
	beforeDec += direction;

	var afterDec = newCoord.substring(newCoord.indexOf(".") + 1, newCoord.indexOf(".") + (precision) + 1);

	return indexName + ":" + beforeDec + "+AND+" + indexName + ":" + afterDec;
}

function coordValToIndexToken(coordValStr, delta, precision, directions)
{
	var coordValFloat = parseFloat(coordValStr);

	var deltaCoordValStr = "" + (coordValFloat + delta);
	var beforeDec = deltaCoordValStr.substring(0, deltaCoordValStr.indexOf("."));

	var direction = directions[0];
	if(coordValFloat < 0)
	{
		// negative value
		direction = directions[1];
		beforeDec = beforeDec.substring(1); // skip over '-' at front
	}
	
	var beforeDecWithDirection = beforeDec + direction;
	
	var afterDecPrecision = deltaCoordValStr.substring(deltaCoordValStr.indexOf(".") + 1, deltaCoordValStr.indexOf(".") + (precision) + 1);

    var indexToken = beforeDecWithDirection + afterDecPrecision;	

	return indexToken;
}

function getDistanceQueryStringTerm(currentLat,currentLng, deltaLat, deltaLng, precision, indexName)
{
	var latToken = coordValToIndexToken(currentLat,deltaLat,precision,["N","S"]);
	var lngToken = coordValToIndexToken(currentLng,deltaLng,precision,["E","W"]);
	
	var queryStringTerm = indexName + ":\"" + latToken + " " + lngToken + "\"";
	
	return queryStringTerm;
}

function _gsInfo(message, optObject) {
	console.log(message);
	if(typeof optObject !== 'undefined') {
		console.log(optObject);
	}
}

function _gsDebug(message, optObject) {
	if(_DEBUGGING_) {
		_gsInfo(message, optObject);
	}
}


function _debugPrintDocList() {	
	if(!_DEBUGGING_) return;
	
	console.log("@@@@ printing docList:");
	for(var i = 0; i < _docList.ids.length; i++)
	{	
		var doc = _docList.getDocByIndex(i);
		console.log("     At index = " + i + " ids[i]: " + _docList.ids[i]);
		console.log("     At index = " + i + " ids[i]: " + _docList.ids[i] + ", doc: " + doc.nodeID);
	}
}

function _debugPrintBounds(bounds, message) {
	if(!_DEBUGGING_) return;
	if(typeof bounds === 'undefined') {
		console.log("Bounds undefined");
		return;
	}
	var ne = bounds.getNorthEast();
    var sw = bounds.getSouthWest();				  
	console.log(message + " bounds: ne = " + ne + ", sw = " + sw);
}
