#########
#
# To customise the sort order for a particular collection, you can put a modified version of this file into your collection's perllib folder.
# NOTE: Any letter not found in this list will be ignored when sorting.
# This is a two level specification. Characters in each line will sort together until a tie-break is needed, in which can the ordering within the line will be used.
# For example,
# Aardvark, ant, Ant, Apple, apricot
#
#########
package sorttools;

use charnames ':full';
# This is the default ordering for List classifier's structured_grouped_sort option.
# A flat list of these characters is used for List classifier's structured_sort option.

our $structured_grouped_order = [
[" "], #we want the space to factor in the sort
["0"],
["1"],
["2"],
["3"],
["4"],
["5"],
["6"],
["7"],
["8"],
["9"],
["a","A","\N{LATIN SMALL LETTER A WITH GRAVE}","\N{LATIN CAPITAL LETTER A WITH GRAVE}","\N{LATIN SMALL LETTER A WITH ACUTE}","\N{LATIN CAPITAL LETTER A WITH ACUTE}","\N{LATIN SMALL LETTER A WITH CIRCUMFLEX}","\N{LATIN CAPITAL LETTER A WITH CIRCUMFLEX}","\N{LATIN SMALL LETTER A WITH TILDE}","\N{LATIN CAPITAL LETTER A WITH TILDE}","\N{LATIN SMALL LETTER A WITH DIAERESIS}","\N{LATIN CAPITAL LETTER A WITH DIAERESIS}","\N{LATIN SMALL LETTER A WITH RING ABOVE}","\N{LATIN CAPITAL LETTER A WITH RING ABOVE}","\N{LATIN SMALL LETTER A WITH MACRON}","\N{LATIN CAPITAL LETTER A WITH MACRON}","\N{LATIN SMALL LETTER AE}","\N{LATIN CAPITAL LETTER AE}"], 
["b","B"],
["c","C","\N{LATIN SMALL LETTER C WITH CEDILLA}","\N{LATIN CAPITAL LETTER C WITH CEDILLA}"],
["d","D","\N{LATIN SMALL LETTER ETH}","\N{LATIN CAPITAL LETTER ETH}"],
["e","E","\N{LATIN SMALL LETTER E WITH GRAVE}","\N{LATIN CAPITAL LETTER E WITH GRAVE}","\N{LATIN SMALL LETTER E WITH ACUTE}","\N{LATIN CAPITAL LETTER E WITH ACUTE}","\N{LATIN SMALL LETTER E WITH CIRCUMFLEX}","\N{LATIN CAPITAL LETTER E WITH CIRCUMFLEX}","\N{LATIN SMALL LETTER E WITH DIAERESIS}","\N{LATIN CAPITAL LETTER E WITH DIAERESIS}","\N{LATIN SMALL LETTER E WITH MACRON}","\N{LATIN CAPITAL LETTER E WITH MACRON}"],
["f","F"],
["g","G"],
["h","H"],
["i","I","\N{LATIN SMALL LETTER I WITH GRAVE}","\N{LATIN CAPITAL LETTER I WITH GRAVE}","\N{LATIN SMALL LETTER I WITH ACUTE}","\N{LATIN CAPITAL LETTER I WITH ACUTE}","\N{LATIN SMALL LETTER I WITH CIRCUMFLEX}","\N{LATIN CAPITAL LETTER I WITH CIRCUMFLEX}","\N{LATIN SMALL LETTER I WITH DIAERESIS}","\N{LATIN CAPITAL LETTER I WITH DIAERESIS}","\N{LATIN SMALL LETTER I WITH MACRON}","\N{LATIN CAPITAL LETTER I WITH MACRON}"],
["j","J"],
["k","K"],
["l","L"],
["m","M"],
["n","N","\N{LATIN SMALL LETTER N WITH TILDE}","\N{LATIN CAPITAL LETTER N WITH TILDE}"],
["o","O","\N{LATIN SMALL LETTER O WITH GRAVE}","\N{LATIN CAPITAL LETTER O WITH GRAVE}","\N{LATIN SMALL LETTER O WITH ACUTE}","\N{LATIN CAPITAL LETTER O WITH ACUTE}","\N{LATIN SMALL LETTER O WITH CIRCUMFLEX}","\N{LATIN CAPITAL LETTER O WITH CIRCUMFLEX}","\N{LATIN SMALL LETTER O WITH TILDE}","\N{LATIN CAPITAL LETTER O WITH TILDE}","\N{LATIN SMALL LETTER O WITH DIAERESIS}","\N{LATIN CAPITAL LETTER O WITH DIAERESIS}","\N{LATIN SMALL LETTER O WITH STROKE}","\N{LATIN CAPITAL LETTER O WITH STROKE}","\N{LATIN SMALL LETTER O WITH MACRON}","\N{LATIN CAPITAL LETTER O WITH MACRON}"],
["p","P"],
["q","Q"],
["r","R"],
["s","S","\N{LATIN SMALL LETTER SHARP S}"],
["t","T","\N{LATIN SMALL LETTER THORN}","\N{LATIN CAPITAL LETTER THORN}"],
["u","U","\N{LATIN SMALL LETTER U WITH GRAVE}","\N{LATIN CAPITAL LETTER U WITH GRAVE}","\N{LATIN SMALL LETTER U WITH ACUTE}","\N{LATIN CAPITAL LETTER U WITH ACUTE}","\N{LATIN SMALL LETTER U WITH CIRCUMFLEX}","\N{LATIN CAPITAL LETTER U WITH CIRCUMFLEX}","\N{LATIN SMALL LETTER U WITH DIAERESIS}","\N{LATIN CAPITAL LETTER U WITH DIAERESIS}","\N{LATIN SMALL LETTER U WITH MACRON}","\N{LATIN CAPITAL LETTER U WITH MACRON}"],
["v","V"],
["w","W"],
["x","X"],
["y","Y","\N{LATIN SMALL LETTER Y WITH ACUTE}","\N{LATIN CAPITAL LETTER Y WITH ACUTE}","\N{LATIN SMALL LETTER Y WITH DIAERESIS}"],
["z","Z"]
];

