###################################################
# A basic cascade-make to install the DBD::mysql v 4.033 perl package to work with the GreenstoneSQLPlugin/Plugout
#
# Requires an internet connection to download required packages etc
#
# No dependencies
#
#
# Compiling AND INSTALLING of all packages takes place in the temporary cpan/tmp folder. A select subset of the compiled/installed
# products are then copied into their final destinations: lib/../<pkg> is copied into cpan, and lib/../auto/<pkg> is copied into cpan/auto
#
#
###################################################

if [ "x$1" = "x--help" ] || [ "x$1" = "x-h" ]; then
    echo "Usage: $0 [--clean|--keep|--help|-h]"
    echo "  Run without flags to compile and remove unnecessary stuff at the end."
    echo "  Run with --keep to retain the cpan/tmp subdir at compilation's end." 
    echo "  Run with --clean to remove all traces of compilation completely so you can recompile from scratch"
    echo "  Run with --help/-h to see this Usage statement again"
    exit 0
fi

if [ "x$GSDL3SRCHOME" = "x" ] ; then
    echo "** GSDL3SRCHOME not set, sourcing gs3-setup.sh"
    echo ""
    cd ../../..
    source ./gs3-setup.sh
    cd $GSDLHOME/perllib/cpan
fi

echo ""
echo "**************************"

########################## VARIABLES ######################

# Expected defaults:
# - This script was originally created for Mac High Sierra where the DBI perl package was installed #   but the DBD perl package is missing (which needs to be compiled against MySQL 5.7.23 that we
#   will download and adjust for the purpose)
# - The DBI perl package tends to be installed on Mac and Linux Ubuntu. If not, set NEED_PERL_DBI
#   to true to compile it up against the MySQL that this script will download.
# - Regardless of whether you have a MySQL installed, this script needs to download MySQL v 5.7.23
#   in specific to compile (DBI and) DBD against it.
#   MySQL tends to be installed on Linux. If the version installed is 5.7.23, you may not want to
#   keep the MySQL that this script downloads. In that case set KEEP_MYSQL_DOWNLOAD to false.
# - The Ubunutu 16.04 assigned to me had both DBI and DBD installed so I didn't need to run this
#   script at all.

NEED_PERL_DBI=false # set to true if your machine doesn't have DBI
KEEP_MYSQL_DOWNLOAD=true # needed for compiling DBD (and DBI). Set to false if custom MySQL to be removed after compiling
NEED_PERL_DBD=true # only set to false, if you want this script to ONLY get and extract MySQL for you

# Need mysql 5.7.23 to compile DBD (and DBI) against. Regardless of whether user wants to use this mysql,
# we need to download, unpack and adjust it for compiling up DBD (and optionally DBI).
# The version of mysql we want is 5.7.23, we get the MacOS 10.13 (High Sierra) binary
# and extract it into GSDLHOME as mysql-5.7.23
MYSQL_BIN=mysql-5.7.23
MYSQL_MIRROR=http://mysql.inspire.net.nz/Downloads/MySQL-5.7

# $GSDLOS can be "darwin" on Mac, else "linux".
# Alternatively, can test `uname`: echoed value can be "Darwin" (on Mac) or "Linux"
if [ "x$GSDLOS" = "xdarwin" ] ; then
	MYSQL_TARBALL="${MYSQL_BIN}-macos10.13-x86_64"	
else
	MYSQL_TARBALL="${MYSQL_BIN}-linux-glibc2.12-x86_64"
fi

# We want DBD::mysql version 4.033
# This package is necessary on Mac High Sierra (v10.13)
# Assigned Ubuntu had DBD (and DBI) but VM testing Ubuntu had neither
DBD_MYSQL=DBD-mysql-4.033
DBD_MYSQL_DOWNLOAD=https://cpan.metacpan.org/authors/id/C/CA/CAPTTOFU/$DBD_MYSQL.tar.gz

# We may need DBI::DBD version 1.634, if DBI not installed (on machines with no DBD and DBI)
# see http://wiki.greenstone.org/doku.php?id=en:user_advanced:greenstonesqlplugs
# and https://metacpan.org/pod/release/TIMB/DBI-1.634/lib/DBI/DBD.pm
DBI_DBD=DBI-1.634
DBI_DBD_DOWNLOAD=https://cpan.metacpan.org/authors/id/T/TI/TIMB/$DBI_DBD.tar.gz


########################## DON'T CHANGE ####################
CPAN_DIR=$GSDLHOME/perllib/cpan

# PERL_FOLDER is something like "perl-5.18" (even if the full version number is 5.18.2)
PERL_VERSION=`perl -e 'print "5.".substr($],3,2);'`
# full perl version number like 5.18.2 or 5.22.1 (actually "5 version 22 subversion 1)
PERL_FULL_VERSION=`perl -e 'print "5.".substr($],3,2).".".substr($],7,1);'`
PERL_FOLDER="perl-${PERL_VERSION}" #`perl -e 'print "perl-5.".substr($],3,2);'`

# make the dirs cpan/$PERL_FOLDER and its subdir auto if they don't already exist
mkdir -p $CPAN_DIR/$PERL_FOLDER/auto

WGET_FLAGS=--no-check-certificate
# folder where we'll put the downloaded files, the compile products and the temporary install products
# after everything is installed there, we copy just the relevant installed files to their final locations
# then the tmp file gets deleted
TEMP_DBI_DBD_DIR=$CPAN_DIR/tmp-mysql
TEMP_STATIC_LIBS_DIR=$GSDLHOME/$MYSQL_BIN/mysql-static
MYSQL_DIR=$GSDLHOME/$MYSQL_BIN


##########################

# if --clean was passed in
if [ "x$1" = "x--clean" ] ; then
    pushd $CPAN_DIR
    if [ -d "$PERL_FOLDER/DBD" ]; then
	rm -rf $PERL_FOLDER/DBD
    fi
    if [ -d "$PERL_FOLDER/auto/DBD" ]; then
	rm -rf $PERL_FOLDER/auto/DBD
    fi
    echo "** Done cleaning DBD::mysql related packages"

    if [ -e "$PERL_FOLDER/DBI.pm" ]; then
	rm -f $PERL_FOLDER/DBI.pm
    fi
    if [ -d "$PERL_FOLDER/DBI" ]; then
	rm -rf $PERL_FOLDER/DBI
    fi
    if [ -d "$PERL_FOLDER/auto/DBI" ]; then
	rm -rf $PERL_FOLDER/auto/DBI
    fi
    echo "** Done cleaning DBI::DBD related packages"
    popd
    exit 0
fi

# Go into $GSDLHOME
pushd $GSDLHOME

# download and untar mysql into $GSDLHOME
if [ ! -d $GSDLHOME/$MYSQL_BIN ]; then
    if [ ! -e $GSDLHOME/$MYSQL_TARBALL.tar.gz ]; then
	echo "** Getting the mysql tarball"
	wget $WGET_FLAGS $MYSQL_MIRROR/$MYSQL_TARBALL.tar.gz
    fi
    echo "** Extracting the mysql tarball into $GSDLHOME and renaming to $MYSQLBIN"
    tar -xvzf $MYSQL_TARBALL.tar.gz
    # there's 2 tarballs inside, untar the one with identical name to outer
    # and rename to $GSDLHOME/mysql-5.7.23
#    cd $MYSQL_TARBALL
#    tar -xvzf $MYSQL_TARBALL.tar.gz
#    cd $GSDLHOME
#    mv $MYSQL_TARBALL/$MYSQL_TARBALL $GSDLHOME/$MYSQL_BIN
    mv $MYSQL_TARBALL $GSDLHOME/$MYSQL_BIN
fi

# copy just the static .a libraries into their own folder
if [ ! -d $TEMP_STATIC_LIBS_DIR ]; then
    echo "** Creating $TEMP_STATIC_LIBS_DIR and copying $MYSQL_BIN/lib/*.a into it"
    mkdir -p $TEMP_STATIC_LIBS_DIR
    cp $GSDLHOME/$MYSQL_BIN/lib/*.a $TEMP_STATIC_LIBS_DIR/.
fi

# Ensure a clean new temp folder to compile (DBI and) DBD into
echo "** Creating $TEMP_DBI_DBD_DIR (anew)"
if [ -d $TEMP_DBI_DBD_DIR ]; then
    rm -rf $TEMP_DBI_DBD_DIR
fi
mkdir $TEMP_DBI_DBD_DIR


if [ "x$NEED_PERL_DBI" = "xtrue" ] ; then
	# download and untar DBI::DBD v 1.634
	if [ ! -d $GSDLHOME/$DBI_DBD ]; then
	    cd $GSDLHOME
	    if [ ! -e $GSDLHOME/$DBI_DBD.tar.gz ]; then
		echo "** Getting the DBI::DBD tarball"
		wget $WGET_FLAGS $DBI_DBD_DOWNLOAD
	    fi
	    echo "** Extracting the DBI::DBD tarball into $GSDLHOME"
	    tar -xvzf $DBI_DBD.tar.gz
	fi
	# start compiling DBI::DBD into $TEMP_DBI_DBD_DIR
	echo "** Compiling the DBI perl package"

	cd $GSDLHOME/$DBI_DBD
	perl Makefile.PL \
	    PREFIX=$TEMP_DBI_DBD_DIR
	    --cflags=-I$GSDLHOME/$MYSQL_BIN/include \
	    --libs="-L$TEMP_STATIC_LIBS_DIR -lmysqlclient"
	make
	make install

	# move built DBI::DBD products into correct CPAN location
	echo "** Moving relevant DBI::DBD products into $CPAN_DIR/$PERL_FOLDER"
	cd $CPAN_DIR
	if [ "x$GSDLOS" = "xdarwin" ] ; then
	    mv $TEMP_DBI_DBD_DIR/lib/perl5/site_perl/$PERL_FULL_VERSION/darwin-thread-multi-2level/DBI.pm $PERL_FOLDER/.
	    mv $TEMP_DBI_DBD_DIR/lib/perl5/site_perl/$PERL_FULL_VERSION/darwin-thread-multi-2level/DBI $PERL_FOLDER/.
	    mv $TEMP_DBI_DBD_DIR/lib/perl5/site_perl/$PERL_FULL_VERSION/darwin-thread-multi-2level/auto/DBI $PERL_FOLDER/auto/.
	else
	    mv $TEMP_DBI_DBD_DIR/lib/x86_64-linux-gnu/perl/$PERL_FULL_VERSION/DBI.pm $PERL_FOLDER/.
	    mv $TEMP_DBI_DBD_DIR/lib/x86_64-linux-gnu/perl/$PERL_FULL_VERSION/DBI $PERL_FOLDER/.
	    mv $TEMP_DBI_DBD_DIR/lib/x86_64-linux-gnu/perl/$PERL_FULL_VERSION/auto/DBI $PERL_FOLDER/auto/.
	fi
fi
#echo "EXITING"
#exit

if [ "x$NEED_PERL_DBD" = "xtrue" ] ; then
	# download and untar DBD::mysql v 4.033
	if [ ! -d $GSDLHOME/$DBD_MYSQL ]; then
	    cd $GSDLHOME
	    if [ ! -e $GSDLHOME/$DBD_MYSQL.tar.gz ]; then
		echo "** Getting the DBD::mysql tarball"
		wget $WGET_FLAGS $DBD_MYSQL_DOWNLOAD
	    fi
	    echo "** Extracting the DBD mysql tarball into $GSDLHOME"
	    tar -xvzf $DBD_MYSQL.tar.gz
	fi
	# start compiling DBD::mysql into $TEMP_DBI_DBD_DIR
	echo "** Compiling this perl package"

	cd $GSDLHOME/$DBD_MYSQL
	perl Makefile.PL \
	    PREFIX=$TEMP_DBI_DBD_DIR \
	    --cflags=-I$GSDLHOME/$MYSQL_BIN/include \
	    --libs="-L$TEMP_STATIC_LIBS_DIR -lmysqlclient"
	make
	make install

	# move built DBD::mysql products into correct CPAN location
	echo "** Moving relevant DBD::mysql products into $CPAN_DIR/$PERL_FOLDER"
	cd $CPAN_DIR
	if [ "x$GSDLOS" = "xdarwin" ] ; then
	    mv $TEMP_DBI_DBD_DIR/lib/perl5/site_perl/$PERL_FULL_VERSION/darwin-thread-multi-2level/DBD $PERL_FOLDER/.
	    mv $TEMP_DBI_DBD_DIR/lib/perl5/site_perl/$PERL_FULL_VERSION/darwin-thread-multi-2level/auto/DBD $PERL_FOLDER/auto/.
	else    
	    mv $TEMP_DBI_DBD_DIR/lib/x86_64-linux-gnu/perl/$PERL_FULL_VERSION/DBD $PERL_FOLDER/.
	    mv $TEMP_DBI_DBD_DIR/lib/x86_64-linux-gnu/perl/$PERL_FULL_VERSION/auto/DBD $PERL_FOLDER/auto/.
	fi
fi

# clean up
echo "*****************************"
echo "*** Done compiling DBD::mysql."
if [ "x$1" != "x--keep" ] ; then
    echo "** Will now delete temporary DBD::mysql products, and the untarred DBD::mysql"
    rm -rf $TEMP_DBI_DBD_DIR
    if [ -d "$GSDLHOME/$DBI_DBD" ]; then
	rm -rf $GSDLHOME/$DBI_DBD
    fi
    if [ -d "$GSDLHOME/$DBD_MYSQL" ]; then
	rm -rf $GSDLHOME/$DBD_MYSQL
    fi
else
    echo "**   Not deleting the $TEMP_DBI_DBD_DIR"
fi
# The static libs folder added to the downloaded MySQL installation was only necessary for compiling.
# It can be removed now, since MySQL usage doesn't require it.
rm -rf $TEMP_STATIC_LIBS_DIR


if [ "x$KEEP_MYSQL_DOWNLOAD" = "xfalse" ] ; then
    if [ -d $GSDLHOME/$MYSQL_BIN ]; then
	echo "**** KEEP_MYSQL_DOWNLOAD set to false, so removing $GSDLHOME/$MYSQL_BIN folder"
	echo "     now that compilation is done"
        rm -rf $GSDLHOME/$MYSQL_BIN
    fi
fi

# go back to where we started
popd

echo "*****************************"
echo ""
if [ "x$KEEP_MYSQL_DOWNLOAD" = "xfalse" ] ; then
    echo "** KEEP_MYSQL_DOWNLOAD was set to false,"
    echo "   so it's assumed you have your own MySQL 5.7.23 installation"
    echo "   You now need to initialise your MySQL installation."
else
    echo "** You now need to initialise the MySQL installation at $GSDLHOME/$MYSQL_BIN"
fi
echo "** Follow the instructions from STEP 2 ONWARDS at at http://wiki.greenstone.org/doku.php?id=en:user_advanced:greenstonesqlplugs#installing_one_time_setup"
echo "** Once that's done, the same page has information on how to use the GreenstoneSQLPlugs in a collection"
echo ""
echo "*****************************"

