#!/bin/bash

package=bzip2
version=-1.0.6

progname=$0

source ../cascade-make/lib/cascade-lib.bash GEXTGNOME ../.. $*

prefix=$GEXTGNOME_INSTALLED

if [ "x$CROSSCONFIGURE_ARGS" != "x" ] ; then
  export CPP="$crossHost-cpp"
  export CC="$crossHost-gcc"
  export CXX="$crossHost-g++"
  export LD="$crossHost-ld"
  export AR="$crossHost-ar"
  export RANLIB="$crossHost-ranlib"
fi


fixmake=0

if [ "x$CROSSCONFIGURE_ARGS" != "x" ] ; then

  if [ $force_untar = "1" ] ; then
    fixmake=1
  elif [ $auto_config = "1" ] && [ ! -d $package$version ] ; then
    fixmake=1
  fi
fi


opt_run_untar $force_untar $auto_untar $package $version

if [ $fixmake = "1" ] ; then

  cat $package$version/Makefile \
   | sed "s/^CC=gcc/CC=$crossHost-gcc/" \
   | sed "s/^AR=ar/AR=$crossHost-ar/" \
   | sed "s/^RANLIB=ranlib/RANLIB=$crossHost-ranlib/" \
   > $package$version/Makefile.cross
  /bin/mv $package$version/Makefile.cross $package$version/Makefile
fi


#custom opt_run_make 'compile'
if [ $compile = 1 ] ; then
    (cd $package$version ; make CFLAGS="$CFLAGS -fPIC")
fi

#custom opt_run_make 'install'
if [ $install = 1 ] ; then
    (cd $package$version ; make install PREFIX=$prefix) 
fi

opt_run_make $clean $package $version "clean"
opt_run_make $distclean $package $version "distclean"

opt_run_tarclean $tarclean $package $version