/**************************************************************************
 *
 * bitio_m_mem.h -- Macros for bitio to memory
 * Copyright (C) 1994  Neil Sharman
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************
 *
 *  This file contains macros for doing bitwise input and output on an array 
 *  of chars. These routines are faster than the ones in "mems" files. But 
 *  with these routines you cannot mix reads and writes on the array of chars,
 *  or multiple write, at the same time and guarantee them to work, also you 
 *  cannot seek to a point and do a write. The decode routine can detect when
 *  you run off the end of the array and will produce an approate error 
 *  message, and the encode routine will stop when it gets to the end of the 
 *  character array. 
 *
 **************************************************************************/

#ifndef H_BITIO_M_MEM
#define H_BITIO_M_MEM

#include "bitio_m_abstract.h"
#include "mglong.h"


class mem_bitio_buffer : public bitio_buffer {
protected:
  unsigned char *pos;
  unsigned char *base;
  int            remaining;
  unsigned char  buffer;
  unsigned char  btg;
  
public:
  mem_bitio_buffer ();
  mem_bitio_buffer (unsigned char *buffer, int size);
  void seek (mg_u_long topos);
  void error ();
  mg_s_long add00 (mg_s_long b);
  mg_s_long addff (mg_s_long b);
  int  bit ();
  void done ();

  void encodeStart ();
  void encodeBit (int bit);
  void encodeDone () { flush(); }
  int  encodeVerify ();
  int  encodeLength ();
  void flush ();
};


/*
#define ENCODE_START(p,r)						\
  {									\
    mem_bitio_buffer buffer(p, r);                                     \
    buffer.encodeStart();

#define ENCODE_CONTINUE(b)						\
  {									\
    mem_bitio_buffer buffer;                                           \
    buffer.unpause(b);

#define ENCODE_PAUSE(b)	buffer.pause(&b);}

#define ENCODE_FLUSH buffer.flush()

#define ENCODE_DONE buffer.flush();}


#define DECODE_START(p,r)						\
  {	                                                                \
    mem_bitio_buffer buffer(p,r);

#define DECODE_CONTINUE(b)						\
  {	                                                                \
    mem_bitio_buffer buffer;                                           \
    buffer.unpause(b);

#define DECODE_ADD_FF(b) b = buffer.addff(b)

#define DECODE_ADD_00(b) b = buffer.add00(b)

#define DECODE_BIT buffer.bit()

#define DECODE_DONE buffer.done();}

#define DECODE_PAUSE(b) buffer.pause(&b);}
*/

#endif
