/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * <BR><BR>
 *
 * Author: Shaoqun Wu, Greenstone Digital Library, University of Waikato
 *
 * <BR><BR>
 *
 * Copyright (C) 2006 New Zealand Digital Library Project
 *
 * <BR><BR>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * <BR><BR>
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * <BR><BR>
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.gems;

import org.greenstone.gatherer.Dictionary;

public class GEMSConstants
{
    
    static String NAMESPACE_ATTRIBUTE = "namespace";
    static String NAME_ATTRIBUTE = "name";
    static String DESCRIPTION_ATTRIBUTE = "description";
    static String CODE_ATTRIBUTE = "code";
    static String LANGUAGE_ATTRIBUTE = "language";
    static String SET_LANGUAGE_ELEMENT = "SetLanguage";
    static String LANGUAGE_ELEMENT = "Language";
    static String NAME_ELEMENT = "Name";
    static String DESCRIPTION_ELEMENT = "Description";
    static String DEFAULT_LANGUAGE ="en";
    static String ATTRIBUTE_ELEMENT="Attribute";
    static String ELEMENT_ELEMENT="Element";  
    static String METADATASET_ELEMENT="MetadataSet"; 
    static String ADD_ATTRIBUTE = "addAttribute";
    static String DELETE_ATTRIBUTE = "deleteAttribute";
    static String ADD_ELEMENT = "addElement";
    static String ADD_SUBELEMENT = "addSubElement";
    static String DELETE_ELEMENT = "deleteElement";
    static int METADATA_INFO = 0;
    static int METADATA_ELEMENT = 0;
    static String NEW_ELEMENT = "ELEMENT";
    static String MOVE_UP = "moveUp";
    static String MOVE_DOWN = "moveDown"; 
    static String EXTRACTED_METADATA_NAMESPACE = "ex";

    static String[] SET_REQUIRED_ATTRIBUTES = new String[]{"contact","creator","family","lastchanged","namespace"};
    static String[] SET_LANG_DEPEND_ATTR_NAMES = new String[]{"name","description"};

    static String UNKNOWN_NAME="unknown";  

    static String MATADATASET_NAME="MetadataSet";
    
    static String SYSTEM_ID = "http://www.greenstone.org/dtd/MetadataSet/1.0/MetadataSet.dtd";

    static String[] DIALOG_OPTIONS = new String[]{Dictionary.get("General.OK"),Dictionary.get("General.Cancel")};

    static String LABEL_ATTRIBUTE = "label";
    static String DEFINITION_ATTRIBUTE = "definition";
    static String COMMENT_ATTRIBUTE = "comment";

    static String [] ELEMENT_REQUIRED_ATTRIBUTES = new String[] {"name"};
    
    static String [] ELEMENT_LANG_DEPEND_ATTR_NAMES = new String[] {LABEL_ATTRIBUTE, DEFINITION_ATTRIBUTE, COMMENT_ATTRIBUTE};

    static String [] ATTRIBUTES_COLUMN_NAMES = new String [] {
	Dictionary.get("GEMS.AttributeTable.Name"), Dictionary.get("GEMS.AttributeTable.Value")};
    static String [] LANG_DEPENDENT_ATTRIBUTES_COLUMN_NAMES = new String [] {
	Dictionary.get("GEMS.AttributeTable.Name"), Dictionary.get("GEMS.AttributeTable.Language"), Dictionary.get("GEMS.AttributeTable.Value")};

    static String METADATA_SET_FILE_EXTENSION = ".mds";
}
