package org.greenstone.gatherer.feedback;

import java.awt.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.table.*;
import javax.swing.text.*;
import java.awt.image.*;
import javax.imageio.ImageIO;
import javax.swing.plaf.*;
import javax.swing.plaf.basic.*;
import javax.swing.colorchooser.*;
import java.awt.event.*;
import javax.swing.event.*;
import java.util.Locale;
import java.util.ResourceBundle;
import java.text.MessageFormat;
import javax.swing.plaf.metal.MetalIconFactory.*;
import javax.swing.plaf.metal.MetalIconFactory;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.metal.MetalInternalFrameTitlePane;

/**
 *  In general, this class will get all information and add special listener 
 *  to a Container and of all the components inside it.
 *  <p>This class will get the information about the Container and all the components inside it.
 *  The information we get is like whether or not the component is visible and the contents of it.
 *  This class will also add special listener to the Container and each of the components inside 
 *  the Container. So, it will allows special listener  to record and listen each of the actions 
 *  the user do to the Container or any of the components inside it. The special listener
 *  is an instance of ActionRecorderDialog.</p>
 *  <p>This class will only recognized all the components that is belongs to the javax.swing package
 *  which are all the implementing classes of RootPaneContainer interface and all the direct known
 *  subclasses of JComponent. All the other components will be stated simply as Container 
 *  and user cannot really get much information out of it.</p>
 *  <p>The added special listener to this component is as what its allowed in API, if the component
 *  have some modified listener added to it then that action will not be known and recorded by
 *  the special listener.</p>
 *  
 *  @author Veronica Liesaputra
 */
public class ComponentInformation
{
    /**
     *  This variable will hold the special listener that will listen and record any of the 
     *  actions user do to the Container and any of the components inside it.
     */
    private ActionRecorderDialog m;
    
    /**
     *  This variable will hold the resource of the words that is stored in Messages.properties file. 
     *  The calling using messages.getString(someString) will caused someString to be translated
     *  into some other string that is hold in that file.usually it will caused it to be translated
     *  to the language that the user use or choose to have as stated in Locale.
     */
    private static ResourceBundle messages;

    /**
     *  This variable will hold the pair of the component and the model of the component.
     *  With this variable allows ActionRecorderDialog listener to know which component the model that fires an action
     *  belongs to. In this HashMap the model is the key and the component where the model belongs to is
     *  the value. 
     */
    private HashMap hash;
    
    /**
     *  This constructor will set the special listener, the locale and the hashmap to be used in
     *  this Container.
     *  (Precondition: dialog != null)
     *  @param dialog  its the special listener that will listen and record all the action
     *                 user do to any of the component inside the Container.
     *  @param currentLocale its the locale that the user choose all the information to be displayed as.
     *  @param h       its the HashMap that will hold the pair of model with the component it belongs.
     */
    public ComponentInformation 
	(ActionRecorderDialog dialog,Locale currentLocale,HashMap h)
    {
	m = dialog;
	hash = h;
	messages = ResourceBundle.getBundle("feedback", currentLocale);
    }
	
    /**
     *  This method will get all information about the JTextComponent.
     *  If the JTextComponent is a JTextField then it will add the special action listener to it.
     *  (Precondition: txt != null)
     *  @param txt its the JTextComponent we want to get all the information from.
     *  @return    a UserComponent that hold the information about this
     *             JTextComponent.
     */
    public  UserComponent getTextAreaInfo(JTextComponent txt)
    {
	UserComponent file;
	file = new UserComponent(); 
	String text;
	text = txt.getText();

	file.startContent(1);
	if (txt instanceof JTextArea)
	    file.saveContent("JTextArea");
	else if (txt instanceof JTextPane)
	    file.saveContent("JTextPane");
	else if (txt instanceof JEditorPane)
	    file.saveContent("JEditorPane");
	else if (txt instanceof JTextField)
	    {
		((JTextField)txt).removeActionListener(m);
		((JTextField)txt).addActionListener(m);
		
		if (txt instanceof JFormattedTextField)
		    {
			file.saveContent("JFormattedTextField");
		    }
		else if (txt instanceof JPasswordField)
		    {
			file.saveContent("JPasswordField");
		    }
		else
		    {
			file.saveContent("JTextField");
		    }
	    }

	file.startContent(2);
	file.saveContent(messages.getString("TextComponent"));
	
	file.startContent(3);
	if (text != null)
	    file.saveContent(text);
	else
	    file.saveContent(" ");
	
	file.startContent(4);
	file.saveContent(txt.getSelectedText());

	file.startContent(5);
	file.saveContent(messages.getString("" + txt.isVisible()));

	file.startContent(7);
	file.saveContent(txt.getToolTipText());
	
	return file;
    }

    /**
     *  This method will get all the information and add the special action listener to the JButton.
     *  (Precondition: button != null)
     *  @param button its the JButton we want to get the information from.
     *  @return       a UserComponent that will hold the information about this JButton.
     */
    public UserComponent getButtonInfo (JButton button)
    {
	UserComponent file;
	file = new UserComponent();
	String text;
	text = button.getText();

	button.removeActionListener(m);
	button.addActionListener(m);

	file.startContent(1);
	file.saveContent("JButton");

	file.startContent(2);
	file.saveContent(messages.getString("Button"));
	
	file.startContent(3);
	if (text != null)
	    file.saveContent(text);
	else
	    file.saveContent(" ");

	file.startContent(4);
	file.saveContent(messages.getString("" + button.isSelected()));

	file.startContent(5);
	file.saveContent(messages.getString("" + button.isVisible()));
	
	file.startContent(6);
	Icon img = button.getIcon();
	if (img != null)
	    {
		file.saveImage(img,messages.getString("icon")+img.hashCode()+".jpg");
	    }
	else
	    {
		file.saveContent(messages.getString("NoImage"));
	    }

	file.startContent(7);
	file.saveContent(button.getToolTipText());

	return file;
    }

     /**
     *  This method will get all the information and add the special change listener to the JProgressBar.
     *  (Precondition: bar != null)
     *  @param  bar   its the JProgressBar we want to get information from.
     *  @return       a UserComponent that will hold the information about this JProgressBar.
     */
    public UserComponent getProgressBarInfo (JProgressBar bar)
    {
	UserComponent file;
	file = new UserComponent();
	String text;
	text = bar.getString();

	bar.removeChangeListener(m);
	bar.addChangeListener(m);
	
	file.startContent(1);
	file.saveContent("JProgressBar");

	file.startContent(2);
	file.saveContent(messages.getString("ProgressBar"));
	
	file.startContent(3);
	if (text != null)
	    file.saveContent(text);
	else
	    file.saveContent(" ");

	file.startContent(5);
	file.saveContent(messages.getString("" + bar.isVisible()));
	
	file.startContent(7);
	file.saveContent(bar.getToolTipText());

	return file;
    }
    
    /**
     *  This method will get all the information and add the special change listener to the JSlider.
     *  (Precondition: slider != null)
     *  @param  slider its the JSlider we want to get information from.
     *  @return        a UserComponent that will hold the information about this JSlider.
     */
    public UserComponent getSliderInfo (JSlider slider)
    {
	UserComponent file;
	file = new UserComponent();
	String text;
	text = "" + slider.getValue();
	
	slider.removeChangeListener(m);
	slider.addChangeListener(m);

	file.startContent(1);
	file.saveContent("JSlider");
	
	file.startContent(2);
	file.saveContent(messages.getString("Slider"));
	
	file.startContent(3);
	if (text != null)
	    file.saveContent(text);
	else
	    file.saveContent(" ");

	file.startContent(5);
	file.saveContent(messages.getString("" + slider.isVisible()));
	
	file.startContent(7);
	file.saveContent(slider.getToolTipText());

	return file;
    }

    /**
     *  This method will get all the information and add the special change listener to the JSpinner.
     *  (Precondition: spinner != null)
     *  @param spinner its the JSpinner we want to the information from.
     *  @return        a UserComponent that will hold the information about this JSpinner.
     */
    public UserComponent getSpinnerInfo (JSpinner spinner)
    {
	UserComponent file;
	file = new UserComponent();
	String text;
	text = "" + spinner.getValue();
	
	spinner.removeChangeListener(m);
	spinner.addChangeListener(m);

	file.startContent(1);
	file.saveContent("JSpinner");
	
	file.startContent(2);
	file.saveContent(messages.getString("Spinner"));
	
	file.startContent(3);
	if (text != null)
	    file.saveContent(text);
	else
	    file.saveContent(" ");

	file.startContent(5);
	file.saveContent(messages.getString("" + spinner.isVisible()));
	
	file.startContent(7);
	file.saveContent(spinner.getToolTipText());

	return file;
    }
    
    /**
     *  This method will get all the information of  the JLabel.
     *  (Precondition: lbl != null)
     *  @param lbl    its the JLabel we want to get information from.
     *  @return       a UserComponent that will hold the information about this JLabel.
     */
    public UserComponent getLabelInfo(JLabel lbl)
    {
	UserComponent file;
	file = new UserComponent();
	String text;
	text = lbl.getText();

	file.startContent(1);
	file.saveContent("JLabel");
	
	file.startContent(2);
	file.saveContent(messages.getString("Label"));
	
	file.startContent(3);
	if (text != null)
	    file.saveContent(text);
	else
	    file.saveContent(" ");
	
	file.startContent(5);
	file.saveContent(messages.getString("" + lbl.isVisible()));

	file.startContent(6);
	Icon img = lbl.getIcon();
	if (img != null)
	    {
		file.saveImage(img,messages.getString("icon")+img.hashCode()+".jpg");
	    }
	else
	    {
		file.saveContent(messages.getString("NoImage"));
	    }
	
	file.startContent(7);
	file.saveContent(lbl.getToolTipText());

	return file;
    }
    
    /**
     *  This method will get all the information and add the special action listener to the JComboBox.
     *  (Precondition: box != null)
     *  @param box    its the JComboBox we want to get information from.
     *  @return       a UserComponent that will hold the information about this JComboBox.
     */
    public  UserComponent getComboBoxInfo(JComboBox box)
    {
	UserComponent file;
	file = new UserComponent();
	ComboBoxModel cm;
	cm = box.getModel();

	box.removeActionListener(m);
	box.addActionListener(m);
	
	file.startContent(1);
	file.saveContent("JComboBox");
	
	file.startContent(2);
	file.saveContent(messages.getString("ComboBox"));
	
	file.startContent(3);
	int i;
	for (i = 0; i < box.getItemCount() ; i++)
	    {
		UserComponent file2;
		file2 = new UserComponent();
		//Assuming that they don't put any picture or images
		String text;
		Object objmsg;

		objmsg = box.getItemAt(i);

		if (objmsg instanceof String)
		    text = (String) objmsg + "\n";
		else
		    text = objmsg.toString() + "\n" ;
		
		file2.startContent(3);
		if (text != null)
		    file2.saveContent(text);
		else
		    file2.saveContent(" ");
		
		file2.startContent(4);
		if (i == box.getSelectedIndex())
		    file2.saveContent(messages.getString("Selected"));
		else
		    file2.saveContent(messages.getString("NotSelected"));
		
		file.saveContent(file2);
	    }

	file.startContent(5);
	file.saveContent(messages.getString("" + box.isVisible()));

	file.startContent(7);
	file.saveContent(box.getToolTipText());

	return file;
    }

    /**
     *  This method will get all the information and add the special action listener to the JToggleButton.
     *  (Precondition: button != null)
     *  @param button its a JToggleButton inside the window
     *  @return       a UserComponent that will hold the information about this JToggleButton.
     */
    public UserComponent getToggleButtonInfo (JToggleButton button)
    {
	UserComponent file;
	file = new UserComponent();

	button.removeActionListener(m);
	button.addActionListener(m);

	file.startContent(1);
	if (button instanceof JCheckBox)
	    file.saveContent("JCheckBox");
	else
	    file.saveContent("JRadioButton");
	
	file.startContent(2);
	file.saveContent(messages.getString("ToggleButton"));
	
	file.startContent(3);
	String text;
	text = button.getText();
	if (text != null)
	    file.saveContent(text);
	else
	    file.saveContent(" ");
	
	file.startContent(4);
	if (button.isSelected() == true)
	    {
		file.saveContent(messages.getString("Selected"));
	    }
	else
	    file.saveContent(messages.getString("NotSelected"));
	
	file.startContent(5);
	file.saveContent(messages.getString("" + button.isVisible()));
	
	file.startContent(6);
	Icon img = button.getIcon();
	if (img != null)
	    {
		file.saveImage(img,messages.getString("icon")+img.hashCode()+".jpg");
	    }
	else
	    {
		file.saveContent(messages.getString("NoImage"));
	    }
	
	file.startContent(7);
	file.saveContent(button.getToolTipText());

	return file;
    }

    /**
     *  This method will get all the information and add the special action listener to the JMenuItem.
     *  (Precondition: menuitem != null)
     *  @param menuitem its the JMenuItem we want to get the information from.
     *  @return         a UserComponent that will hold the information about this JMenuItem.
     */
    public UserComponent getMenuItemInfo (JMenuItem menuitem)
    {
	UserComponent file;
	file = new UserComponent();

	menuitem.removeActionListener(m);
	menuitem.addActionListener(m);
	
	file.startContent(1);
	file.saveContent("JMenuItem");
	
	file.startContent(2);
	file.saveContent(messages.getString("MenuItem"));
	
	file.startContent(3);
	String text;
	text = menuitem.getText();
	if (text != null)
	    file.saveContent(text);
	else
	    file.saveContent(" ");
	
	file.startContent(4);
	if (menuitem.isSelected() == true)
	    {
		file.saveContent(messages.getString("Selected"));
	    }
	else
	    file.saveContent(messages.getString("NotSelected"));
	
	file.startContent(5);
	file.saveContent(messages.getString("" +  menuitem.isVisible()));
	
	file.startContent(6);
	Icon img = menuitem.getIcon();
	if (img  != null)
	    {
		file.saveImage(img,messages.getString("icon")+img.hashCode()+".jpg");
	    }
	else
	    {
		file.saveContent(messages.getString("NoImage"));
	    }
	
	file.startContent(7);
	file.saveContent(menuitem.getToolTipText());

	return file;
    }

    /**
     *  This method will get all the information of the JMenuBar.
     *  (Precondition: menubar != null)
     *  @param menubar its the JMenuBar we want to get the information from.
     *  @return        a UserComponent that will hold the information about this JMenuBar.
     */
    public  UserComponent getMenuBarInfo (JMenuBar menubar)
    {
	UserComponent file;
	file = new UserComponent();

	file.startContent(1);
	file.saveContent("JMenuBar");
	
	file.startContent(2);
	file.saveContent(messages.getString("MenuBar"));
	
	file.startContent(3);
	int i;
	for (i= 0 ; i < menubar.getMenuCount() ; i++)
	    {
		file.saveContent(getInside(menubar.getMenu(i)));
	    }
	
	file.startContent(4);
	if (menubar.isSelected() == true)
	    {
		file.saveContent(messages.getString("Selected"));
	    }
	else
	    file.saveContent(messages.getString("NotSelected"));
	
	file.startContent(5);
	file.saveContent(messages.getString("" +  menubar.isVisible()));
	
	file.startContent(7);
	file.saveContent(menubar.getToolTipText());

	return file;
    }

    /**
     *  This method will get all the information and add the special action and menu listener to the JMenu.
     *  (Precondition: menu != null)
     *  @param menu   its the JMenu we want to the the information from.
     *  @return       a UserComponent that will hold the information about this JMenu.
     */
    public  UserComponent getMenuInfo (JMenu menu)
    {
	UserComponent file;
	file = new UserComponent();

	menu.removeActionListener(m);
	menu.removeMenuListener(m);
	menu.addActionListener(m);
	menu.addMenuListener(m);

	file.startContent(1);
	file.saveContent("JMenu");
	
	file.startContent(2);
	String text;
	text = menu.getText();
	if (text != null)
	    file.saveContent(text);
	else
	    file.saveContent(" ");
	
	file.startContent(3);
	int i;
	for (i= 0 ; i < menu.getMenuComponentCount() ; i++)
	    {
		file.saveContent(getInside((Container)menu.getMenuComponent(i)));
	    }
	
	file.startContent(4);
	if (menu.isSelected() == true)
	    {
		file.saveContent(messages.getString("Selected"));
	    }
	else
	    file.saveContent(messages.getString("NotSelected"));
	
	file.startContent(5);
	file.saveContent(messages.getString("" +  menu.isVisible()));
	
	file.startContent(6);
	Icon img = menu.getIcon();
	if (img  != null)
	    {
		file.saveImage(img,messages.getString("icon")+img.hashCode()+".jpg");
	    }
	else
	    {
		file.saveContent(messages.getString("NoImage"));
	    }
	
	file.startContent(7);
	file.saveContent(menu.getToolTipText());

	return file;
    }
    
    /**
     *  This method will get all the information of the JApplet.
     *  (Precondition: applet != null)
     *  @param applet its the JApplet we want to get the information from.
     *  @return       a UserComponent that will hold the information about this JApplet.
     */
    public  UserComponent getAppletInfo (JApplet applet)
    {
	UserComponent file;
	file = new UserComponent();
	Component[] group;
	group = applet.getComponents();
	int i;

	file.startContent(1);
	file.saveContent("JApplet");
	
	file.startContent(2);
	String text;
	text = applet.getAppletInfo();
	if (text != null)
	    file.saveContent(text);
	else
	    file.saveContent(" ");
	
	if (group != null)
	    {
		file.startContent(3);
		for (i = 0; i < group.length ; i++)
		    {
			file.saveContent(getInside((Container)applet.getComponent(i)));
		    }
	    }
	
	file.startContent(4);
	file.saveContent(messages.getString("" + applet.isActive()));
	
	file.startContent(5);
	file.saveContent(messages.getString("" + applet.isVisible()));
	
	return file;
    }

    /**
     *  This method will get all the information of the JWindow.
     *  (Precondition: window != null)
     *  @param window its the JWindow we want to get the information from.
     *  @return       a UserComponent that will hold the information about this JWindow.
     */
    public  UserComponent getWindowInfo (JWindow window)
    {
	UserComponent file;
	file = new UserComponent();
	Component[] group;
	group = window.getComponents();
	int i;

	file.startContent(1);
	file.saveContent("JWindow");
	
	file.startContent(2);
	file.saveContent(messages.getString("Window"));
	
	if (group != null)
	    {
		file.startContent(3);
		for (i = 0; i < group.length ; i++)
		    {
			file.saveContent(getInside((Container)window.getComponent(i)));
		    }
	    }
	
	file.startContent(4);
	file.saveContent(messages.getString("" + window.isActive()));
	
	file.startContent(5);
	file.saveContent(messages.getString("" + window.isVisible()));

	return file;
    }

    /**
     *  This method will get all the information of the JDialog.
     *  (Precondition: dialog != null)
     *  @param dialog its the JDialog we want to get the information from.
     *  @return       a UserComponent that will hold the information about this JDialog.
     */
    public UserComponent getDialogInfo (JDialog dialog)
    {
	UserComponent file;
	file = new UserComponent();
	Component[] group;
	group = dialog.getComponents();
	int i;

	file.startContent(1);
	file.saveContent("JDialog");
	
	file.startContent(2);
	String text = dialog.getTitle();
	if (text != null)
	    file.saveContent(text);
	else
	    file.saveContent(" ");
	
	if (group != null)
	    {
		file.startContent(3);
		for (i = 0; i < group.length ; i++)
		    {
			file.saveContent(getInside((Container)dialog.getComponent(i)));
		    }
	    }
	
	file.startContent(4);
	file.saveContent(messages.getString("" + dialog.isActive()));

	file.startContent(5);
	file.saveContent(messages.getString("" + dialog.isVisible()));
	
	return file;
    }

    /**
     *  This method will get all the information of the JInternalFrame.
     *  (Precondition: frame != null)
     *  @param frame  its the JInternalFrame we want to get the information from.
     *  @return       a UserComponent that will hold the information about this JInternalFrame.
     */
    public UserComponent getInternalFrameInfo (JInternalFrame frame)
    {
	UserComponent file;
	file = new UserComponent();
	Component[] group;
	group = frame.getComponents();
	int i;

	file.startContent(1);
	file.saveContent("JInternalFrame");
	
	file.startContent(2);
	String text;
	text = frame.getTitle();
	if (text != null)
	    file.saveContent(text);
	else
	    file.saveContent(" ");
	
	if (group != null)
	    {
		file.startContent(3);
		for (i = 0; i < group.length ; i++)
		    {
			file.saveContent(getInside((Container)frame.getComponent(i)));
		    }
	    }
	
	file.startContent(4);
	file.saveContent(messages.getString("" + frame.isSelected()));

	file.startContent(5);
	file.saveContent(messages.getString("" + frame.isVisible()));
	
	file.startContent(6);
	Icon img = frame.getFrameIcon();
	if (img != null)
	    {
		file.saveImage(img,messages.getString("icon")+img.hashCode()+".jpg");
	    }
	else
	    {
		file.saveContent(messages.getString("NoImage"));
	    }
	
	file.startContent(7);
	file.saveContent(frame.getToolTipText());

	return file;
    }

    /**
     *  This method will get all the information of the JFrame.
     *  (Precondition: frame != null)
     *  @param frame  its the JFrame we want to get the information from.
     *  @return       a UserComponent that will hold the information about this JFrame.
     */
    public UserComponent getFrameInfo (JFrame frame)
    {
	UserComponent file;
	file = new UserComponent();
	Component[] group;
	group = frame.getComponents();
	int i;
	
	file.startContent(1);
	file.saveContent("JFrame");
	
	file.startContent(2);
	String text;
	text = frame.getTitle();
	if (text != null)
	    file.saveContent(text);
	else
	    file.saveContent(" ");
	
	if (group != null)
	    {
		file.startContent(3);
		for (i = 0; i < group.length ; i++)
		    {
			file.saveContent(getInside((Container)frame.getComponent(i)));
		    }
	    }
	
	file.startContent(4);
	file.saveContent(messages.getString("" + frame.isActive()));

	file.startContent(5);
	file.saveContent(messages.getString("" + frame.isVisible()));
	
	file.startContent(6);
	Image image;
	image = frame.getIconImage();
	if (image != null)
	    {
		ImageIcon img;
		img = new ImageIcon(image);
		file.saveImage(img,messages.getString("icon")+img.hashCode()+".jpg");
	    }
	else
	    {
		file.saveContent(messages.getString("NoImage"));
	    }
	
	return file;
    }

    /**
     *  This method will get all the information of the JPanel.
     *  (Precondition: pane != null)
     *  @param pane   its the JPanel we want to get the information from.
     *  @return       a UserComponent that will hold the information about this JPanel.
     */
    public UserComponent getPanelInfo (JPanel pane)
    {
	UserComponent file;
	file = new UserComponent();
	Component[] group;
	group = pane.getComponents();
	int i;

	file.startContent(1);
	file.saveContent("JPanel");
	
	file.startContent(2);
	file.saveContent(messages.getString("Panel"));

	if (group != null)
	    {
		file.startContent(3);
		for (i = 0; i < group.length ; i++)
		    {
			file.saveContent(getInside((Container)pane.getComponent(i)));
		    }
	    }

	file.startContent(5);
	file.saveContent(messages.getString("" + pane.isVisible()));
	
	file.startContent(7);
	file.saveContent(pane.getToolTipText());

	return file;
    }
    
    /**
     *  This method will get all the information of the JScrollPane.
     *  (Precondition: scroll != null)
     *  @param scroll its the JScrollPane we want to get the information from.
     *  @return       a UserComponent that will hold the information about this JScrollPane.
     */
    public UserComponent getScrollInfo (JScrollPane scroll)
    {
	UserComponent file;
	file = new UserComponent();
	Component[] group;
	group = scroll.getComponents();
	int i;
	
	file.startContent(1);
	file.saveContent("JScrollPane");
	
	file.startContent(2);
	file.saveContent(messages.getString("Scroller"));
	
	if (group != null)
	    {
		file.startContent(3);
		for (i = 0; i < group.length ; i++)
		    {
			file.saveContent(getInside((Container)group[i]));
		    }
	    }
	
	file.startContent(5);
	file.saveContent(messages.getString("" + scroll.isVisible()));
	
	file.startContent(7);
	file.saveContent(scroll.getToolTipText());

	return file;
    }

    /**
     *  This method will get all the information and add special change listener to the JTabbedPane.
     *  (Precondition: tab != null)
     *  @param tab   its the JTabbedPane we want to get the information from.
     *  @return      a UserComponent that will hold the information about this JTabbedPane.
     */
    public UserComponent getTabbedPaneInfo (JTabbedPane tab)
    {
	UserComponent file;
	file = new UserComponent();
	int j;
	
	tab.removeChangeListener(m);
	tab.addChangeListener(m);

	file.startContent(1);
	file.saveContent("JTabbedPane");
	
	file.startContent(3);
	for (j = 0 ; j < tab.getTabCount(); j++)
	    {	
		UserComponent file2;
		file2 = new UserComponent();

		file2.startContent(2);
		String title;
		title = tab.getTitleAt(j);
		if (title != null)
		    file2.saveContent(title);
		else
		    file2.saveContent(" ");
		
		file2.startContent(6);
		Icon img;
		img = tab.getIconAt(j);
		if (img != null)
		    {
			file2.saveImage(img,messages.getString("icon")+img.hashCode()+".jpg");
		    }
		else
		    {
			file2.saveContent(messages.getString("NoImage"));
		    }
		
		file2.startContent(3);
		Component group = tab.getComponentAt(j);
		file2.saveContent(getInside((Container)group));
		
		file2.startContent(4);
		if (j == tab.getSelectedIndex())
		    file2.saveContent(messages.getString("Selected"));
		else
		    file2.saveContent(messages.getString("NotSelected"));
		
		file.saveContent(file2);
	    }
	
	file.startContent(5);
	file.saveContent(messages.getString("" + tab.isVisible()));
	
	file.startContent(7);
	file.saveContent(tab.getToolTipText());

	return file;
    }
    
    /**
     *  This method will get all the information of the JOptionPane.
     *  (Precondition: op != null)
     *  @param op   its the JOptionPane we want to get the information from.
     *  @return      a UserComponent that will hold the information about this JOptionPane.
     */
    public UserComponent getOptionPaneInfo (JOptionPane op)
    {
	UserComponent file;
	file = new UserComponent();

	file.startContent(1);
	file.saveContent("JOptionPane");
	
	file.startContent(2);
	file.saveContent(messages.getString("OptionPane"));
	
	file.startContent(3);
	Object objmsg;
	objmsg = op.getMessage();

	if (objmsg != null)
	    {
		String text;
		if (objmsg instanceof String)
		    text = (String) objmsg + "\n";
		else
		    text = objmsg.toString() + "\n" ;
		file.saveContent(text);
	    }
	else
	    file.saveContent(" ");
	
	Object[] obj;
	int i;
	obj = op.getOptions();
	if (obj != null)
	    {
		for (i = 0; i < obj.length ; i++)
		    {
			if (obj[i] instanceof String)
			    file.saveContent((String) obj[i]);
			else
			    file.saveContent(obj[i].toString());
		    }
	    }

	file.startContent(5);
	file.saveContent(messages.getString("" + op.isVisible()));
	
	file.startContent(6);
	Icon img = op.getIcon();
	if (img != null)
	    {
		file.saveImage(img,messages.getString("icon")+img.hashCode()+".jpg");
	    }
	else
	    {
		file.saveContent(messages.getString("NoImage"));
	    }
	
	file.startContent(7);
	file.saveContent(op.getToolTipText());

	return file;
	
    }

    /**
     *  This method will get all the information of the JViewPort.
     *  (Precondition: vp != null)
     *  @param vp   its the JViewPort we want to get the information from.
     *  @return     a UserComponent that will hold the information about this JViewPort.
     */
    public  UserComponent getViewPortInfo (JViewport vp)
    {
	UserComponent file;
	file = new UserComponent();
	Component[] group;
	group = vp.getComponents();
	int i;

	file.startContent(1);
	file.saveContent("JViewPort");
	
	file.startContent(2);
	file.saveContent(messages.getString("ViewPort"));
	
	if (group != null)
	    {
		file.startContent(3);
		for (i = 0; i < group.length ; i++)
		    {
			file.saveContent(getInside((Container)group[i]));
		    }
	    }
	
	file.startContent(5);
	file.saveContent(messages.getString("" + vp.isVisible()));
	
	file.startContent(7);
	file.saveContent(vp.getToolTipText());

	return file;
    }

    /**
     *  This method will get all the information of the Box.
     *  (Precondition: box != null)
     *  @param box  its the Box we want to get the information from.
     *  @return     a UserComponent that will hold the information about this Box.
     */
    public UserComponent getBoxInfo (Box box)
    {
	UserComponent file;
	file = new UserComponent();
	Component[] group;
	group = box.getComponents();
	int i;

	file.startContent(1);
	file.saveContent("Box");
	
	file.startContent(2);
	file.saveContent(messages.getString("Box"));
	
	if (group != null)
	    {
		file.startContent(3);
		for (i = 0; i < group.length ; i++)
		    {
			file.saveContent(getInside((Container)group[i]));
		    }
	    }
	
	file.startContent(5);
	file.saveContent(messages.getString("" + box.isVisible()));
	
	file.startContent(7);
	file.saveContent(box.getToolTipText());

	return file;
    }

    /**
     *  This method will get all the information of the JSplitPane.
     *  (Precondition: split != null)
     *  @param split  its the JSplitPane we want to get the information from.
     *  @return       a UserComponent that will hold the information about this JSplitPane.
     */
    public  UserComponent getSplitPaneInfo (JSplitPane split)
    {
	UserComponent file;
	file = new UserComponent();
	Component[] group;
	group = split.getComponents();
	int i;

	file.startContent(1);
	file.saveContent("JSplitPane");
	
	file.startContent(2);
	file.saveContent(messages.getString("Splitters"));
	
	if (group != null)
	    {
		file.startContent(3);
		for (i = 0; i < group.length ; i++)
		    {
			file.saveContent(getInside((Container)group[i]));
		    }
	    }
	
	file.startContent(5);
	file.saveContent(messages.getString("" + split.isVisible()));
	
	file.startContent(7);
	file.saveContent(split.getToolTipText());

	return file;
    }

    /**
     *  This method will get all the information and add special list selection listener to the JList.
     *  (Precondition: list != null)
     *  @param list  its the JList we want to get the information from.
     *  @return      a UserComponent that will hold the information about this JList.
     */
    public UserComponent getListInfo (JList list)
    {
	UserComponent file;
	file = new UserComponent();
	ListModel ls;
	ls = list.getModel();
	int i;
	
	list.removeListSelectionListener(m);
	list.addListSelectionListener(m);
	
	if (ls != null)
	    {
		if (hash.containsKey(ls) == false)
		    hash.put(ls,list);
		ls.removeListDataListener(m);
		ls.addListDataListener(m);
	    }

	file.startContent(1);
	file.saveContent("JList");
	
	file.startContent(2);
	file.saveContent(messages.getString("List"));
	
	if (ls != null)
	    {
		file.startContent(3);
		for ( i = 0 ; i < ls.getSize() ; i++)
		    {
			UserComponent file2;
			file2 = new UserComponent();
			//Assume that its all a text
			file2.startContent(3);
			String text;
			Object obj;
			obj = ls.getElementAt(i);
			
			if (obj instanceof String)
			    text = (String) obj;
			else
			    text = obj.toString();
			
			if (text != null)
			    file2.saveContent(text);
			else
			    file2.saveContent(" ");
			
			file2.startContent(4);
			if ( i == list.getSelectedIndex())
			    {
				file2.saveContent(messages.getString("Selected"));
			    }
			else
			    file2.saveContent(messages.getString("NotSelected"));
			
			file.saveContent(file2);
		    }
	    }
	
	file.startContent(5);
	file.saveContent(messages.getString("" + list.isVisible()));
	
	file.startContent(7);
	file.saveContent(list.getToolTipText());

	return file;
    }

    /**
     *  This method will get all the information and add special change listener to the JColorChooser.
     *  (Precondition: color != null)
     *  @param color  its the JColorChooser we want to get the information from.
     *  @return       a UserComponent that will hold the information about this JColorChooser.
     */
    public UserComponent getColorInfo (JColorChooser color)
    {
	UserComponent file;
	file = new UserComponent();
	ColorSelectionModel cm;
	cm = color.getSelectionModel();
	int i;
	
	if (cm != null)
	    {
		if (hash.containsKey(cm) == false)
		    hash.put(cm,color);
		cm.removeChangeListener(m);
		cm.addChangeListener(m);
	    }
	
	file.startContent(1);
	file.saveContent("JColorChooser");

	file.startContent(2);
	file.saveContent(messages.getString("ColorChooser"));

	file.startContent(3);
	UserComponent file2;
	file2 = new UserComponent();
	file2.startContent(2);
	file2.saveContent(messages.getString("PreviewPanel"));

	file2.startContent(3);
	file2.saveContent(getInside((Container) color.getPreviewPanel()));
	
	file.saveContent(file2);

	file2 = new UserComponent();
	file2.startContent(2);
	file2.saveContent(messages.getString("ChooserPanels"));

	AbstractColorChooserPanel[] cp;
	cp = color.getChooserPanels();
	if ((cp != null) && (cp.length != 0))
	    {
		file2.startContent(3);
		for (i = 0 ; i < cp.length ; i++)
		    {
			UserComponent file3;
			file3 = new UserComponent();
			file3.startContent(2);
			file3.saveContent(cp[i].getDisplayName());
			
			ColorSelectionModel cpsm;
			cpsm = cp[i].getColorSelectionModel();

			if (cpsm != null)
			    {
				file3.startContent(3);
				file3.saveContent("" + 
						  cpsm.getSelectedColor());
			    }

			file3.startContent(6);
			Icon img = cp[i].getSmallDisplayIcon();
			if (img  != null)
			    {
				file3.saveImage(img,messages.getString("icon")+img.hashCode()+".jpg");
			    }
			else
			    {
				file3.saveContent(messages.getString("NoImage"));
			    }
			
			file3.startContent(6);
			img = cp[i].getLargeDisplayIcon();
			if (img  != null)
			    {
				file3.saveImage(img,messages.getString("icon")+img.hashCode()+".jpg");
			    }
			else
			    {
				file3.saveContent(messages.getString("NoImage"));
			    }
			file2.saveContent(file3);
		    }
	    }
		
	file.saveContent(file2);    
	
	file.startContent(4);
	file.saveContent("" + cm.getSelectedColor().toString());

	file.startContent(5);
	file.saveContent(messages.getString("" +  color.isVisible()));
	
	file.startContent(7);
	file.saveContent(color.getToolTipText());

	return file;
    }

    /**
     *  This method will get all the information and add special action listener to the JFileChooser.
     *  (Precondition: fc != null)
     *  @param fc  its the JFileChooser we want to get the information from.
     *  @return    a UserComponent that will hold the information about this JFileChooser.
     */
    public UserComponent getFileChooserInfo (JFileChooser fc)
    {
	UserComponent file;
	file = new UserComponent();
	int i;

	fc.removeActionListener(m);
	fc.addActionListener(m);

	file.startContent(1);
	file.saveContent("JFileChooser");
	
	file.startContent(2);
	file.saveContent(fc.getDialogTitle());

	File[] f;
	f = fc.getSelectedFiles();
	
	if (f != null)
	    {
		file.startContent(3);
		
		for ( i = 0 ; i < f.length ; i++)
		    {
			UserComponent file2;
			file2 = new UserComponent();
			file2.startContent(1);
			file2.saveContent(fc.getTypeDescription(f[i]));
			
			file2.startContent(2);
			file2.saveContent(fc.getName(f[i]));
			
			file2.startContent(6);
			Icon img = fc.getIcon(f[i]);
			if (img  != null)
			    {
				file2.saveImage(img,messages.getString("icon")+img.hashCode()+".jpg");
			    }
			else
			    {
				file2.saveContent(messages.getString("NoImage"));
			    }
			file.saveContent(file2);
		    }
	    }

	file.startContent(5);
	file.saveContent(messages.getString("" +  fc.isVisible()));
	
	file.startContent(7);
	file.saveContent(fc.getToolTipText());

	return file;
    }		

    /**
     *  This method will get all the information and add special list selection and column model listener 
     *  to the JTable.
     *  (Precondition: table != null)
     *  @param table  its the JTable we want to get the information from.
     *  @return       a UserComponent that will hold the information about this JTable.
     */
    public UserComponent getTableInfo (JTable table)
    {
	UserComponent file;
	file = new UserComponent();
	TableModel tm;
	tm = table.getModel();
	int i,j;
	String text;

	TableColumnModel tcm;
	tcm = table.getColumnModel();
	ListSelectionModel lm;
	lm = table.getSelectionModel(); 

	if (lm != null)
	    {
		if (hash.containsKey(lm) == false)
		    hash.put(lm,table);
		lm.removeListSelectionListener(m);
		lm.addListSelectionListener(m);
	    }
	
	if (tcm != null)
	    {
		if (hash.containsKey(tcm) == false)
		    hash.put(tcm,table);
		tcm.removeColumnModelListener(m);
		tcm.addColumnModelListener(m);
	    }

	file.startContent(1);
	file.saveContent("JTable");
	
	file.startContent(2);
	file.saveContent(messages.getString("Table"));
	
	if (tm != null)
	    {
		file.startContent(3);
		for ( i = 0 ; i < tm.getRowCount() ; i++)
		    {
			UserComponent file2;
			file2 = new UserComponent();
			
			file2.startContent(2);
			text = messages.getString("row") +" " + (i + 1);
			file2.saveContent(text);
			
			file2.startContent(3);
			for ( j = 0 ; j < tm.getColumnCount() ; j++)
			    {
				UserComponent file3;
				file3 = new UserComponent();
				
				file3.startContent(2);
				file3.saveContent(tm.getColumnName(j));
				
				file3.startContent(3);
				
				Object obj;
				obj = tm.getValueAt(i,j);
				
				if (obj instanceof String)
				    file3.saveContent((String)obj);
				else
				    file3.saveContent(obj.toString());
				
				file3.startContent(4);
				if (table.isCellSelected(i,j) == true)
				    {
					file3.saveContent(messages.getString("Selected"));
				    }
				else
				    file3.saveContent(messages.getString("NotSelected"));
				
				file2.saveContent(file3);
			    }
			
			file.saveContent(file2);
		    }
	    }

	file.startContent(5);
	file.saveContent(messages.getString("" +  table.isVisible()));
	
	file.startContent(7);
	file.saveContent(table.getToolTipText());

	return file;
    }

    /**
     *  This method will get all the information of the JScrollBar.
     *  (Precondition: scroll != null)
     *  @param scroll  its the JScrollBar we want to get the information from.
     *  @return         a UserComponent that will hold the information about this JScrollBar.
     */
    public  UserComponent getScrollBarInfo (JScrollBar scroll)
    {
	UserComponent file;
	file = new UserComponent();

	file.startContent(1);
	file.saveContent("JScrollBar");
	
	file.startContent(2);
	file.saveContent(messages.getString("ScrollerBar"));
	
	file.startContent(3);
	file.saveContent(""+ scroll.getOrientation()+ " :"+ scroll.getValue());
	
	file.startContent(5);
	file.saveContent(messages.getString("" + scroll.isVisible()));
	
	file.startContent(7);
	file.saveContent(scroll.getToolTipText());

	return file;
    }

    /**
     *  This method will get all the information and add special tree selection listener to the JTree.
     *  (Precondition: tree != null)
     *  @param tree  its the JTree we want to get the information from.
     *  @return      a UserComponent that will hold the information about this JTree.
     */
    public UserComponent getTreeInfo (JTree tree)
    {
	UserComponent file;
	file = new UserComponent();
	TreeModel tm;
	tm = tree.getModel();
	int i;
	
	tree.removeTreeSelectionListener(m);
	tree.addTreeSelectionListener(m);
	
	if (tm != null)
	    {
		if (hash.containsKey(tm) == false)
		    hash.put(tm,tree);
		tm.removeTreeModelListener(m);
		tm.addTreeModelListener(m);
	    }
	
	file.startContent(1);
	file.saveContent("JTree");
	
	file.startContent(2);
	file.saveContent(messages.getString("Tree"));
	
	file.startContent(3);
	Object root;
	root = tm.getRoot();
	file.saveContent(getChildInfo(tm,root,tree));
	
	file.startContent(5);
	file.saveContent(messages.getString("" +  tree.isVisible()));
	
	file.startContent(7);
	file.saveContent(tree.getToolTipText());

	return file;
    }
       
    /**
     *  This method will get all the information about the parent node and all the childs of it inside the JTree.
     *  (Precondition: (tree != null) && (tm != null) && (parent != null))
     *  @param tm      its the tree model of the JTree.
     *  @param parent  its the parent node that we want to get all the child information from.
     *  @param tree    its the JTree where the parent node belongs to.
     *  @return        a UserComponent that will hold the information about this parent node.  
     */
    private UserComponent getChildInfo (TreeModel tm,Object parent,JTree tree)
    {
	UserComponent file;
	file = new UserComponent();
	if (tm.isLeaf(parent) == false)
	    {
		file.startContent(2);
		String text;
		text = parent.toString();
		if (text != null)
		    file.saveContent(text);
		else
		    file.saveContent(" ");
		
		int j;
		for (j = 0 ; j < tm.getChildCount(parent) ; j++)
		    {
			file.startContent(3);
			Object child;
			child = tm.getChild(parent,j);
			file.saveContent(getChildInfo(tm,child,tree));
		    }
	    }
	else
	    {
		file.startContent(2);
		String text;
		text = parent.toString();
		if (text != null)
		    file.saveContent(text);
		else
		    file.saveContent(" ");
	    }
	return file;
    }

    /**
     *  This method will get all the information of a Container that is not belongs to any of the more specified
     *  method stated in this class.
     *  (Precondition: pane != null)
     *  @param pane  its the Container component we want to get the information from.
     *  @return      a UserComponent that will hold the information about this Container.
     */
    public UserComponent getCompInfo (Container pane)
    {
	UserComponent file;
	file = new UserComponent();
	Component[] group;
	group = pane.getComponents();
	int i;

	file.startContent(1);
	file.saveContent("Container");
	
	file.startContent(2);
	file.saveContent(messages.getString("Container"));
	
	if (group != null)
	    {
		file.startContent(3);
		file.saveContent(messages.getString("TitlePane"));
		file.saveContent(getInside(null));
		/*for (i = 0; i < group.length ; i++)
		    {
			file.saveContent(getInside((Container)pane.getComponent(i)));
			}*/
	    }
	
	file.startContent(5);
	file.saveContent(messages.getString("" + pane.isVisible()));
	
	return file;
    }

    /**
     *  This method will get all the information of the JPopupMenu.
     *  (Precondition: popup != null)
     *  @param popup  its the JPopUpMenu we want to get the information from.
     *  @return       a UserComponent that will hold the information about this JPopupMenu.
     */
    public UserComponent getPopUpMenuInfo (JPopupMenu popup)
    {
	UserComponent file;
	file = new UserComponent();
	Component[] group;
	group = popup.getComponents();
	SingleSelectionModel sm;
	sm = popup.getSelectionModel();
	int i;

	file.startContent(1);
	file.saveContent("JPopUpMenu");

	file.startContent(2);
	String text;
	text = popup.getLabel();
	if (text != null)
	    file.saveContent(popup.getLabel());
	else
	    file.saveContent(" ");

	if (group != null)
	    {
		file.startContent(3);
		for (i = 0; i < group.length ; i++)
		    {
			file.saveContent(getInside((Container)popup.getComponent(i)));
		    }
	    }

	if (sm != null)
	    {
		file.startContent(4);
		file.saveContent("" + sm.getSelectedIndex());
	    }

	file.startContent(5);
	file.saveContent(messages.getString("" + popup.isVisible()));
	
	file.startContent(7);
	file.saveContent(popup.getToolTipText());

	return file;
    }

    /**
     *  This method will get all the information of the JRootPane.
     *  (Precondition: pane != null)
     *  @param pane  its the JRootPane we want to get the information from.
     *  @return      a UserComponent that will hold the information about this JRootPane.
     */
    public UserComponent getRootPaneInfo (JRootPane pane)
    {
	UserComponent file;
	file = new UserComponent();
	Component[] group;
	group = pane.getComponents();
	int i;
	
	file.startContent(1);
	file.saveContent("JRootPane");
	
	file.startContent(2);
	file.saveContent(messages.getString("RootPane"));

	if (group != null)
	    {
		file.startContent(3);
		for (i = 0; i < group.length ; i++)
		    {
			
			file.saveContent(getInside((Container)pane.getComponent(i)));
		    }
	    }

	file.startContent(5);
	file.saveContent(messages.getString("" + pane.isVisible()));
	
	file.startContent(7);
	file.saveContent(pane.getToolTipText());

	return file;
    }

    /**
     *  This method will get all the information of the JLayeredPane.
     *  (Precondition: pane != null)
     *  @param pane  its the JLayeredPane we want to get the information from.
     *  @return      a UserComponent that will hold the information about this JLayeredPane.
     */
    public UserComponent getLayeredPaneInfo (JLayeredPane pane)
    {
	UserComponent file;
	file = new UserComponent();
	Component[] group;
	group = pane.getComponents();
	int i;
	
	file.startContent(1);
	file.saveContent("JLayeredPane");
	
	file.startContent(2);
	file.saveContent(messages.getString("LayeredPane"));
	
	if (group != null)
	    {
		file.startContent(3);
		for (i = 0; i < group.length ; i++)
		    {
			file.saveContent(getInside((Container)pane.getComponent(i)));
		    }
	    }

	file.startContent(5);
	file.saveContent(messages.getString("" + pane.isVisible()));
	
	file.startContent(7);
	file.saveContent(pane.getToolTipText());

	return file;
    }

    /**
     *  This method will get all the information of the BasicInternalFrameTitlePane.
     *  (Precondition: pane != null)
     *  @param pane  its the BasicInternalFrameTitlePane we want to get the information from.
     *  @return      a UserComponent that will hold the information about this BasicInternalFrameTitlePane.
     */
    public UserComponent getInternalFrameTitleInfo (BasicInternalFrameTitlePane pane)
    {
	UserComponent file;
	file = new UserComponent();
	Component[] group;
	group = pane.getComponents();
	int i;

	file.startContent(1);
	file.saveContent("BasicInternalFrameTitlePane");
	
	file.startContent(2);
	file.saveContent(messages.getString("InternalFrameTitlePane"));
	
	/*if (group != null)
	    {
		file.startContent(3);
		for (i = 0; i < group.length ; i++)
		    {
			Component c;
			c = pane.getComponent(i);
			
			else
			    file.saveContent(getInside((Container)pane.getComponent(i)));
		    }
		    }*/
	
	file.startContent(5);
	file.saveContent(messages.getString("" + pane.isVisible()));
	
	file.startContent(7);
	file.saveContent(pane.getToolTipText());

	return file;
    }

    /**
     *  This method will get all the information and add special column model and list selection
     *  listener to JTableHeader.
     *  (Precondition: header != null)
     *  @param header  its the JTableHeader we want to get the information from.
     *  @return        a UserComponent that will hold the information about this JTableHeader.
     */
    public UserComponent getTableHeaderInfo (JTableHeader header)
    {
	UserComponent file;
	file = new UserComponent();
	TableColumnModel tcm;
	tcm = header.getColumnModel();
	ListSelectionModel lm;
	lm = tcm.getSelectionModel();

	if (tcm != null)
	    {
		if (hash.containsKey(tcm) == false)
		    hash.put(tcm,header);
		tcm.removeColumnModelListener(m);
		tcm.addColumnModelListener(m);
	    }

	if (lm != null)
	    {
		if (hash.containsKey(lm) == false)
		    hash.put(lm,header);
		lm.removeListSelectionListener(m);
		lm.addListSelectionListener(m);
	    }

	file.startContent(1);
	file.saveContent("JTableHeader");
	
	file.startContent(2);
	file.saveContent(messages.getString("TableHeader"));

	if (tcm != null)
	    {
		int[] select = tcm.getSelectedColumns();

		if (select != null)
		    {
			file.startContent(3);
			for (int i = 0 ; i < select.length ; i++)
			    {
				UserComponent file2;
				file2 = new UserComponent();
				file2.startContent(4);
				file2.saveContent("" + select[i]);
				
				file.saveContent(file2);
			    }
		    }
	    }

	file.startContent(5);
	file.saveContent(messages.getString("" + header.isVisible()));
	
	file.startContent(7);
	file.saveContent(header.getToolTipText());

	return file;
    }

    /**
     *  This method will get all the information of the JToolBar.
     *  (Precondition: tool != null)
     *  @param tool  its the JToolBar we want to get the information from.
     *  @return      a UserComponent that will hold the information about this JToolBar.
     */
    public UserComponent getToolBarInfo (JToolBar tool)
    {
	UserComponent file;
	file = new UserComponent();
	Component[] group;
	group = tool.getComponents();
	int i;
	
	file.startContent(1);
	file.saveContent("JToolBar");
	
	file.startContent(2);
	file.saveContent(messages.getString("ToolBar"));
	
	if (group != null)
	    {
		file.startContent(3);
		for (i = 0; i < group.length ; i++)
		    {
			file.saveContent(getInside((Container)tool.getComponent(i)));
		    }
	    }

	file.startContent(5);
	file.saveContent(messages.getString("" + tool.isVisible()));
	
	file.startContent(7);
	file.saveContent(tool.getToolTipText());

	return file;
    }

    /**
     *  This method will get all the information of the JToolTip.
     *  (Precondition: tip != null)
     *  @param tip  its the JToolTip we want to get the information from.
     *  @return     a UserComponent that will hold the information about this JToolTip.
     */
    public UserComponent getToolTipInfo (JToolTip tip)
    {
	UserComponent file;
	file = new UserComponent();
	Component group;
	group = tip.getComponent();
	int i;
	
	file.startContent(1);
	file.saveContent("JToolTip");
	
	file.startContent(2);
	String text;
	text = tip.getTipText();
	if (text != null)
	    file.saveContent(tip.getTipText());
	else
	    file.saveContent(" ");
	
	if (group != null)
	    {
		file.startContent(3);
		file.saveContent(getInside((Container) group));
	    }
	
	file.startContent(5);
	file.saveContent(messages.getString("" + tip.isVisible()));
	
	return file;
    }

    /**
     *  This method will get all the information of the JSeparator.
     *  (Precondition: sept != null)
     *  @param sept  its the JSeparator we want to get the information from.
     *  @return      a UserComponent that will hold the information about this JSeparator.
     */
    public UserComponent getSeparatorInfo (JSeparator sept)
    {
	UserComponent file;
	file = new UserComponent();

	file.startContent(1);
	file.saveContent("JSeparator");
	
	file.startContent(2);
	file.saveContent(messages.getString("Separator"));

	file.startContent(5);
	file.saveContent(messages.getString("" + sept.isVisible()));
	
	file.startContent(7);
	file.saveContent(sept.getToolTipText());

	return file;
    }

    /**
     *  This method will get all the information of the JDesktopPane.
     *  (Precondition: pane != null)
     *  @param pane  its the JDesktopPane we want to get the information from.
     *  @return      a UserComponent that will hold the information about this JDesktopPane.
     */
    public UserComponent getDesktopPaneInfo (JDesktopPane pane)
    {
	UserComponent file;
	file = new UserComponent();
	JInternalFrame[]  group;
	group = pane.getAllFrames();

	file.startContent(1);
	file.saveContent("JDesktopPane");

	file.startContent(2);
	file.saveContent(messages.getString("DesktopPane"));

	if (group != null)
	    {
		int i;
		file.startContent(3);
		for ( i = 0 ; i < group.length ; i++ )
		    {
			file.saveContent (getInside((Container) group[i]));
		    }
	    }

	file.startContent(5);
	file.saveContent(messages.getString("" + pane.isVisible()));
	
	file.startContent(7);
	file.saveContent(pane.getToolTipText());

	return file;
    }

    /**
     *  This method will give you a UserComponent that hold the information saying
     *  the component is null (no component).
     *  @return  a UserComponent that will hold the information saying its a null component.
     */
    public UserComponent getNullInfo ()
    {
	UserComponent file;
	file = new UserComponent();

	file.startContent(1);
	file.saveContent(messages.getString("NoComponent"));

	return file;
    }

    /**
     *  This method will get all information about any kind of Container.
     *  This method is the gateway to all other methods in this class and will give you all
     *  information about the Container and whats inside it.If you dont know what the specific class
     *  of your container then you go here and it will sort which appropriate method 
     *  this container should go to in this class.
     *  @param comp its the Container we want to get the information from.
     *  @return     a UserComponent that hold the information about this Container.
     */
    public  UserComponent getInside(Container comp)
    {
	if (comp == null)
	    {
		return getNullInfo();
	    }
	else if (comp instanceof JApplet)
	    {
		return getAppletInfo ((JApplet) comp);
	    }
	else if (comp instanceof JSeparator)
	    {
		return getSeparatorInfo ((JSeparator) comp);
	    }
	else if (comp instanceof JWindow)
	    {
		return getWindowInfo((JWindow) comp);
	    }
	else if (comp instanceof JDialog)
	    {
		return getDialogInfo((JDialog) comp);
	    }
	else if (comp instanceof JComboBox)
	    {
		return getComboBoxInfo((JComboBox) comp);
	    }
	else if (comp instanceof JLabel)
	    {
		return getLabelInfo((JLabel) comp);
	    }
	else if (comp instanceof JTextComponent)
	    {
		return getTextAreaInfo((JTextComponent) comp);
	    }
	else if (comp instanceof JFrame)
	    {
		return getFrameInfo((JFrame) comp);
	    }
	else if (comp instanceof JPanel)
	    {
		return getPanelInfo((JPanel) comp);
	    }
	else if (comp instanceof JScrollPane)
	    {
		return getScrollInfo((JScrollPane) comp);
	    }
	else if (comp instanceof JScrollBar)
	    {
		return getScrollBarInfo ((JScrollBar) comp);
	    }
	else if (comp instanceof JViewport)
	    {
		return getViewPortInfo((JViewport) comp);
	    }
	else if (comp instanceof JTabbedPane)
	    {
		return getTabbedPaneInfo((JTabbedPane) comp);
	    }
	else if (comp instanceof Box)
	    {
		return getBoxInfo((Box) comp);
	    }
	else if (comp instanceof JToggleButton)
	    {
		return getToggleButtonInfo((JToggleButton) comp);
	    }
	else if (comp instanceof JSplitPane)
	    {
		return getSplitPaneInfo ((JSplitPane) comp);
	    }
	else if (comp instanceof JList)
	    {
		return getListInfo ((JList) comp);
	    }
	else if (comp instanceof JTree)
	    {
		return getTreeInfo ((JTree) comp);
	    }
	else if (comp instanceof JTable)
	    {
		return getTableInfo ((JTable) comp);
	    }
	else if (comp instanceof JSlider)
	    {
		return getSliderInfo ((JSlider) comp);
	    }
	else if (comp instanceof JSpinner)
	    {
		return getSpinnerInfo ((JSpinner) comp);
	    }
	else if (comp instanceof JProgressBar)
	    {
		return getProgressBarInfo ((JProgressBar) comp);
	    }
	else if (comp instanceof JButton)
	    {
		return getButtonInfo ((JButton) comp);
	    }
	else if (comp instanceof JMenu)
	    {
		return getMenuInfo ((JMenu) comp);
	    }
	else if (comp instanceof JMenuBar)
	    {
		return getMenuBarInfo ((JMenuBar) comp);
	    }
	else if (comp instanceof JMenuItem)
	    {
		return getMenuItemInfo ((JMenuItem) comp);
	    }
	else if (comp instanceof JOptionPane)
	    {
		return getOptionPaneInfo ((JOptionPane) comp);
	    }
	else if (comp instanceof BasicInternalFrameTitlePane)
	    {
		return getInternalFrameTitleInfo ((BasicInternalFrameTitlePane) comp);
	    }
	else if (comp instanceof JColorChooser)
	    {
		return getColorInfo ((JColorChooser) comp);
	    }
	else if (comp instanceof JFileChooser)
	    {
		return getFileChooserInfo ((JFileChooser) comp);
	    }
	else if (comp instanceof JDesktopPane)
	    {
		return getDesktopPaneInfo ((JDesktopPane) comp);
	    }
	else if (comp instanceof JInternalFrame)
	    {
		return getInternalFrameInfo ((JInternalFrame) comp);
	    }
	else if (comp instanceof JLayeredPane)
	    {
		return getLayeredPaneInfo ((JLayeredPane) comp);
	    }
	else if (comp instanceof JPopupMenu)
	    {
		return getPopUpMenuInfo ((JPopupMenu) comp);
	    }
	else if (comp instanceof JRootPane)
	    {
		return getRootPaneInfo ((JRootPane) comp);
	    }
	else if (comp instanceof JTableHeader)
	    {
		return getTableHeaderInfo ((JTableHeader) comp);
	    }
	else if (comp instanceof JToolBar)
	    {
		return getToolBarInfo ((JToolBar) comp);
	    }
	else if (comp instanceof JToolTip)
	    {
		return getToolTipInfo ((JToolTip) comp);
	    }
	else
	    {
		return getCompInfo (comp);
	    }
    }
}







