package org.greenstone.gatherer.feedback;

import java.io.*;

/**
 * The instance of this class will hold a UserComponent and the status of the UserComponent.
 * For each of the CompGroup instance will contains all the information and the status of
 * a window that is opened by the application the user used.
 * @author Veronica Liesaputra
 */
public class CompGroup implements Serializable
{
    /**
     *  This variable will hold the status of the window that is opened by the application.
     */
    private String comp_status;

    /**
     *  This variable will hold the information about the window that is opened by the
     *  application.
     */
    private UserComponent comp;

    public CompGroup ()
    {

    }
    
    /**
     *  It will make CompGroup instance that hold the information and status of the window
     *  thats is opened by the application.
     *  @param curr_comp  information about the window opened by the application.
     *  @param curr_status status of the window opened by the application.
     */
    public CompGroup (UserComponent curr_comp,String curr_status)
    {
	comp_status = curr_status;
	comp = curr_comp;
    }
    
    /**
     * This method will return the status of the window opened by the application.
     * @return the status of the window.
     */
    public String getStatus ()
    {
	return comp_status;
    }
    
    /**
     * This method will return the information about the window opened by the application.
     * @return the information about the window.
     */
    public UserComponent getComponent()
    {
	return comp;
    }
}

  
