# Exits with 1 if Perl is not on the PATH

##  ---- Check Perl exists ----
perlpath=

# Some users may set the above line manually
if [ "x$perlpath" = "x" ]; then
    if [ "x$PERLPATH" != "x" ]; then
	perlpath=$PERLPATH
    else
	# Check if a Greenstone perl-with-cpan exists at expected locations
	if [[ "x$GSDLHOME" != "x" && -d "$GSDLHOME/bin/$GSDLOS$GSDLARCH/perl/bin" ]] ; then	
	    perlpath=$GSDLHOME/bin/$GSDLOS$GSDLARCH/perl
	elif [[ "x$GSDL3SRCHOME" != "x" && -d "$GSDL3SRCHOME/ext-cli/selfcontained-perl-with-cpan/gsperl5-with-cpan-linux64" ]] ; then
	    perlpath=$GSDL3SRCHOME/ext-cli/selfcontained-perl-with-cpan/gsperl5-with-cpan-linux64
	fi
	if [ "x$perlpath" != "x" ]; then
	    # This env var now needs to be set to any perl-with-cpan
	    export GSPERL_WITH_CPAN_HOME=$perlpath
	    # actually need path to bin subfolder
	    perlpath=$perlpath/bin
	    
	    # good time to set PERLPATH env var since not already set?
	    echo "Found perl-with-cpan at standard location, setting PERLPATH"
	    PERLPATH=$perlpath
	    export PERLPATH
	    PATH=$PERLPATH:$PATH
	    export PATH	    
	else	
	    # Else check if Perl is on the search path
	    # Assume not a perl-with-cpan, so don't bother updating the path
	    perlpath=`which perl 2> /dev/null`
	fi
    fi
fi

# Check that a Perl executable has been found
echo "Perl:"
if [ ! -x "$perlpath" ] ; then
    echo
    if [ "$glilang" = "es" ]; then
    echo "La Interfaz de la $PROGNAME requiere Perl para "
    echo "poder operar, pero ste no aparece en su sistema. Por favor asegrese "
    echo "de que Perl est instalado y se encuentra en su ruta de bsqueda. A "
    echo "continuacin ejecute nuevamente este guin."
    elif [ "$glilang" = "fr" ]; then
    echo "$PROGNAME ncessite Perl pour son fonctionnement,"
    echo "mais perl n'a pas pu tre dtect dans votre systme. Veuillez vous "
    echo "assurer que perl est install et est spcifi dans votre chemin de "
    echo "recherche, puis redmarrez ce script."
    elif [ "$glilang" = "ru" ]; then
    echo " $PROGNAME  Perl,   "
    echo ",  Perl     . , ,  "
    echo "Perl       ,  "
    echo " ."
    else
    echo "The $PROGNAME requires Perl in order to operate,"
    echo "but perl could not be detected on your system. Please ensure that perl"
    echo "is installed and is on your search path, then rerun this script."
    fi
    exit 1
fi
echo $perlpath
echo
