#!/bin/bash

if [ ! -d webswing-20.2.5 ] ; then

   echo "****"
   echo "* Untarring Webswing"
   echo "****"

   tar xvzf webswing-20.2.5.tar.gz
fi
   
echo "####"
echo "# Compiling up Webswing"
echo "####"

if [ "x$JAVA_HOME" = "x" ] ; then
    echo "JAVA_HOME needs to be set to compile Webswing"
    echo "If yoour javac is not located in a JDK home area, then"
    echo "Consider using the JDK installed through:"
    echo "    <gsdl3srchome>/ext-cli/get-selfcontained-jdk.sh"
    exit 1
else
    echo "JAVA_HOME set to:"
    echo "    $JAVA_HOME"
fi

if [ ! -d /.Trash-$UID ] ; then

    echo ""
    echo "If compiling up Webswing on a disk partition different to /home/$USER area"
    echo "then the Gnome-based 'trash' command needs to have the following writable directory:"
    echo "    /.Trash-$UID"
    echo ""
    echo "Otherwise, webswing-driectdraw-javascript files with the file-permission error:"
    echo "    Error: EACCES: permission denied, mkdir '/.Trash-$UID'"
    echo ""
    echo "This can be addressed by running:"
    echo "    sudo mkdir /.Trash-\$UID && sudo chown \$USER:\$USER /.Trash-\$UID"
    echo ""

    echo "If required, press ^C to exit, and then run the above command"
    echo "Sleeping for 5 seconds ..."
    sleep 5
fi


#echo cd webswing-20.2.5 && mvn -Pbuild,release clean install
#cd webswing-20.2.5 && mvn -Pbuild,release clean install


echo cd webswing-20.2.5 && mvn -Pbuild,release install
cd webswing-20.2.5 && mvn -Pbuild,release install && cd ..

target_dir=webswing-20.2.5/webswing-server/webswing-server-war/target

if [ ! -f $target_dir/webswing-server.war ] ; then
    echo "Error: File not found:" 1>&2
    echo "    $target_dir/webswing-server" 1>&2
    echo "Unsuccessful compilation of webswing!" 1>&2
    exit 1
else
    echo "Installing webswing-server.war into ../web/"
    /bin/cp $target_dir/webswing-server.war ../web/.
fi

    
