#!/bin/bash

# This script can be run from any directory, but the script file itself
# NEEDS TO BE IN THE TOP-LEVEL GREENSTONE3 SRC HOME DIRECTORY

store_pwd="$(pwd)"
full_progdir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" > /dev/null && pwd )"
cd "$full_progdir"

if [ "x$GSDL3SRCHOME" = "x" ] ; then
    if [ -f gs3-setup.sh ] ; then
        . ./gs3-setup.sh
    fi
fi

if test "x$gsopt_noexts" != "x1" ; then

    echo ""
    echo "----"
    echo "Checking for custom ant-start extension settings (ant-start-settings.bash)"
    echo "----"

    # Check Greenstone3 extensions
    if [ -d ext  ] ; then
	for gsdl_ext in ext/* ; do
	    if [[ "$gsdl_ext" == *.inactive ]]; then
		echo "Skipping inactive extension $gsdl_ext"
		continue
	    fi
	    # Sourcing first for settings, then run ext's 'start' script if it exists
	    if [ -d $gsdl_ext ] ; then
		cd $gsdl_ext > /dev/null
		if [ -f ant-start-settings.bash ]; then 
		    . ./ant-start-settings.bash 
		fi 
		if [ -f ant-start.sh ]; then 
		    ./ant-start.sh 
		fi 
		cd ../..
	    fi
	done
    fi

    # Check Greenstone2 extensions
    if [ -d gs2build/ext  ] ; then
	for gsdl_ext in gs2build/ext/* ; do
	    if [[ "$gsdl_ext" == *.inactive ]]; then
		echo "Skipping inactive extension $gsdl_ext"
		continue
	    fi
	    # Sourcing first for settings, then run ext's 'start' script if it exists
	    if [ -d $gsdl_ext ] ; then 
		cd $gsdl_ext > /dev/null
		if [ -f ant-start-settings.bash ]; then 
		    . ./ant-start-settings.bash 
		fi 
		if [ -f ant-start.sh ]; then 
		    ./ant-start.sh 
		fi 
		cd ../../..
	    fi
	done
    fi    
fi


# If needed, add any further customized code needed here, such as
# environemnt variables


ant start

# Any customized clean up needed?


cd "$store_pwd"
