/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import jdbm.recman.BlockIo;
import jdbm.recman.BlockView;
import jdbm.recman.PageHeader;
import jdbm.recman.PhysicalRowId;

class FreeLogicalRowIdPage
extends PageHeader {
    private static final short O_COUNT = 18;
    static final short O_FREE = 20;
    static final short ELEMS_PER_PAGE = 817;
    final PhysicalRowId[] slots = new PhysicalRowId[817];

    FreeLogicalRowIdPage(BlockIo blockIo) {
        super(blockIo);
    }

    static FreeLogicalRowIdPage getFreeLogicalRowIdPageView(BlockIo blockIo) {
        BlockView blockView = blockIo.getView();
        if (blockView != null && blockView instanceof FreeLogicalRowIdPage) {
            return (FreeLogicalRowIdPage)blockView;
        }
        return new FreeLogicalRowIdPage(blockIo);
    }

    short getCount() {
        return this.block.readShort(18);
    }

    private void setCount(short s) {
        this.block.writeShort(18, s);
    }

    void free(int n) {
        this.get(n).setBlock(0L);
        this.setCount((short)(this.getCount() - 1));
    }

    PhysicalRowId alloc(int n) {
        this.setCount((short)(this.getCount() + 1));
        this.get(n).setBlock(-1L);
        return this.get(n);
    }

    boolean isAllocated(int n) {
        return this.get(n).getBlock() > 0L;
    }

    boolean isFree(int n) {
        return !this.isAllocated(n);
    }

    PhysicalRowId get(int n) {
        if (this.slots[n] == null) {
            this.slots[n] = new PhysicalRowId(this.block, this.slotToOffset(n));
        }
        return this.slots[n];
    }

    private short slotToOffset(int n) {
        return (short)(20 + n * 10);
    }

    int getFirstFree() {
        for (int i = 0; i < 817; ++i) {
            if (!this.isFree(i)) continue;
            return i;
        }
        return -1;
    }

    int getFirstAllocated() {
        for (int i = 0; i < 817; ++i) {
            if (!this.isAllocated(i)) continue;
            return i;
        }
        return -1;
    }
}

