/*
 * Decompiled with CFR 0.152.
 */
package jdbm.htree;

import java.io.IOException;
import jdbm.RecordManager;
import jdbm.helper.FastIterator;
import jdbm.htree.HashDirectory;

public class HTree {
    private HashDirectory _root;

    private HTree(HashDirectory hashDirectory) {
        this._root = hashDirectory;
    }

    public static HTree createInstance(RecordManager recordManager) throws IOException {
        HashDirectory hashDirectory = new HashDirectory(0);
        long l = recordManager.insert(hashDirectory);
        hashDirectory.setPersistenceContext(recordManager, l);
        return new HTree(hashDirectory);
    }

    public static HTree load(RecordManager recordManager, long l) throws IOException {
        HashDirectory hashDirectory = (HashDirectory)recordManager.fetch(l);
        hashDirectory.setPersistenceContext(recordManager, l);
        HTree hTree = new HTree(hashDirectory);
        return hTree;
    }

    public synchronized void put(Object object, Object object2) throws IOException {
        this._root.put(object, object2);
    }

    public synchronized Object get(Object object) throws IOException {
        return this._root.get(object);
    }

    public synchronized void remove(Object object) throws IOException {
        this._root.remove(object);
    }

    public synchronized FastIterator keys() throws IOException {
        return this._root.keys();
    }

    public synchronized FastIterator values() throws IOException {
        return this._root.values();
    }

    public long getRecid() {
        return this._root.getRecid();
    }
}

