/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.util.Collections;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSID;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentation;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class FSRevisionNode {
    public static final String HEADER_ID = "id";
    public static final String HEADER_TYPE = "type";
    public static final String HEADER_COUNT = "count";
    public static final String HEADER_PROPS = "props";
    public static final String HEADER_TEXT = "text";
    public static final String HEADER_CPATH = "cpath";
    public static final String HEADER_PRED = "pred";
    public static final String HEADER_COPYFROM = "copyfrom";
    public static final String HEADER_COPYROOT = "copyroot";
    public static final String HEADER_IS_FRESH_TXN_ROOT = "is-fresh-txn-root";
    public static final String HEADER_MERGE_INFO_COUNT = "minfo-cnt";
    public static final String HEADER_MERGE_INFO_HERE = "minfo-here";
    private FSID myId;
    private SVNNodeKind myType;
    private long myCount;
    private FSID myPredecessorId;
    private FSRepresentation myTextRepresentation;
    private FSRepresentation myPropsRepresentation;
    private String myCreatedPath;
    private long myCopyFromRevision;
    private String myCopyFromPath;
    private long myCopyRootRevision;
    private String myCopyRootPath;
    private Map myDirContents;
    private boolean myIsFreshTxnRoot;
    private FSID myFreshRootPredecessorId;
    private long myMergeInfoCount;
    private boolean myHasMergeInfo;

    public void setId(FSID revNodeID) {
        this.myId = revNodeID;
    }

    public void setType(SVNNodeKind nodeKind) {
        this.myType = nodeKind;
    }

    public void setCount(long count) {
        this.myCount = count;
    }

    public void setPredecessorId(FSID predRevNodeId) {
        this.myPredecessorId = predRevNodeId;
    }

    public void setTextRepresentation(FSRepresentation textRepr) {
        this.myTextRepresentation = textRepr;
    }

    public void setPropsRepresentation(FSRepresentation propsRepr) {
        this.myPropsRepresentation = propsRepr;
    }

    public void setCreatedPath(String cpath) {
        this.myCreatedPath = cpath;
    }

    public void setCopyFromRevision(long copyFromRev) {
        this.myCopyFromRevision = copyFromRev;
    }

    public void setCopyFromPath(String copyFromPath) {
        this.myCopyFromPath = copyFromPath;
    }

    public void setCopyRootRevision(long copyRootRev) {
        this.myCopyRootRevision = copyRootRev;
    }

    public void setCopyRootPath(String copyRootPath) {
        this.myCopyRootPath = copyRootPath;
    }

    public void setMergeInfoCount(long mergeInfoCount) {
        this.myMergeInfoCount = mergeInfoCount;
    }

    public void setHasMergeInfo(boolean hasMergeInfo) {
        this.myHasMergeInfo = hasMergeInfo;
    }

    public FSID getId() {
        return this.myId;
    }

    public SVNNodeKind getType() {
        return this.myType;
    }

    public long getCount() {
        return this.myCount;
    }

    public FSID getPredecessorId() {
        return this.myPredecessorId;
    }

    public FSRepresentation getTextRepresentation() {
        return this.myTextRepresentation;
    }

    public FSRepresentation getPropsRepresentation() {
        return this.myPropsRepresentation;
    }

    public String getCreatedPath() {
        return this.myCreatedPath;
    }

    public long getCreatedRevision() {
        if (this.myFreshRootPredecessorId != null) {
            return this.myFreshRootPredecessorId.getRevision();
        }
        return this.myId.getRevision();
    }

    public long getCopyFromRevision() {
        return this.myCopyFromRevision;
    }

    public String getCopyFromPath() {
        return this.myCopyFromPath;
    }

    public long getCopyRootRevision() {
        return this.myCopyRootRevision;
    }

    public String getCopyRootPath() {
        return this.myCopyRootPath;
    }

    public static FSRevisionNode dumpRevisionNode(FSRevisionNode revNode) {
        FSRevisionNode clone = new FSRevisionNode();
        clone.setId(revNode.getId());
        if (revNode.getPredecessorId() != null) {
            clone.setPredecessorId(revNode.getPredecessorId());
        }
        clone.setType(revNode.getType());
        clone.setCopyFromPath(revNode.getCopyFromPath());
        clone.setCopyFromRevision(revNode.getCopyFromRevision());
        clone.setCopyRootPath(revNode.getCopyRootPath());
        clone.setCopyRootRevision(revNode.getCopyRootRevision());
        clone.setCount(revNode.getCount());
        clone.setCreatedPath(revNode.getCreatedPath());
        if (revNode.getPropsRepresentation() != null) {
            clone.setPropsRepresentation(new FSRepresentation(revNode.getPropsRepresentation()));
        }
        if (revNode.getTextRepresentation() != null) {
            clone.setTextRepresentation(new FSRepresentation(revNode.getTextRepresentation()));
        }
        clone.setMergeInfoCount(revNode.getMergeInfoCount());
        clone.setHasMergeInfo(revNode.hasMergeInfo());
        return clone;
    }

    protected Map getDirContents() {
        return this.myDirContents;
    }

    public void setDirContents(Map dirContents) {
        this.myDirContents = dirContents;
    }

    public boolean hasMergeInfo() {
        return this.myHasMergeInfo;
    }

    public long getMergeInfoCount() {
        return this.myMergeInfoCount;
    }

    public boolean hasDescendantsWithMergeInfo() {
        if (this.myType != SVNNodeKind.DIR) {
            return false;
        }
        if (this.myMergeInfoCount > 1L) {
            return true;
        }
        return this.myMergeInfoCount == 1L && !this.myHasMergeInfo;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{[");
        buffer.append("ID:");
        buffer.append(this.myId);
        buffer.append("][");
        buffer.append("text representation:");
        buffer.append(this.myTextRepresentation);
        buffer.append("][");
        buffer.append("Node kind:");
        buffer.append(this.myType);
        buffer.append("]}");
        return buffer.toString();
    }

    public static FSRevisionNode fromMap(Map headers) throws SVNException {
        String copyroot;
        String cpath;
        String textRepr;
        SVNErrorMessage err;
        FSID revnodeID;
        FSRevisionNode revNode = new FSRevisionNode();
        String revNodeId = (String)headers.get(HEADER_ID);
        if (revNodeId == null) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Missing id field in node-rev");
            SVNErrorManager.error(err2, SVNLogType.FSFS);
        }
        if ((revnodeID = FSID.fromString(revNodeId)) == null) {
            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Corrupted node-id in node-rev");
            SVNErrorManager.error(err3, SVNLogType.FSFS);
        }
        revNode.setId(revnodeID);
        SVNNodeKind nodeKind = SVNNodeKind.parseKind((String)headers.get(HEADER_TYPE));
        if (nodeKind == SVNNodeKind.NONE || nodeKind == SVNNodeKind.UNKNOWN) {
            SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Missing kind field in node-rev");
            SVNErrorManager.error(err4, SVNLogType.FSFS);
        }
        revNode.setType(nodeKind);
        String countString = (String)headers.get(HEADER_COUNT);
        if (countString == null) {
            revNode.setCount(0L);
        } else {
            long cnt = -1L;
            try {
                cnt = Long.parseLong(countString);
            }
            catch (NumberFormatException nfe) {
                err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Corrupted count field in node-rev");
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            revNode.setCount(cnt);
        }
        String propsRepr = (String)headers.get(HEADER_PROPS);
        if (propsRepr != null) {
            FSRevisionNode.parseRepresentationHeader(propsRepr, revNode, revnodeID.getTxnID(), false, true);
        }
        if ((textRepr = (String)headers.get(HEADER_TEXT)) != null) {
            FSRevisionNode.parseRepresentationHeader(textRepr, revNode, revnodeID.getTxnID(), true, nodeKind == SVNNodeKind.DIR);
        }
        if ((cpath = (String)headers.get(HEADER_CPATH)) == null) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Missing cpath in node-rev");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        revNode.setCreatedPath(cpath);
        String predId = (String)headers.get(HEADER_PRED);
        if (predId != null) {
            FSID predRevNodeId = FSID.fromString(predId);
            if (predRevNodeId == null) {
                SVNErrorMessage err5 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Corrupted predecessor node-id in node-rev");
                SVNErrorManager.error(err5, SVNLogType.FSFS);
            }
            revNode.setPredecessorId(predRevNodeId);
        }
        if ((copyroot = (String)headers.get(HEADER_COPYROOT)) == null) {
            revNode.setCopyRootPath(revNode.getCreatedPath());
            revNode.setCopyRootRevision(revNode.getCreatedRevision());
        } else {
            FSRevisionNode.parseCopyRoot(copyroot, revNode);
        }
        String copyfrom = (String)headers.get(HEADER_COPYFROM);
        if (copyfrom == null) {
            revNode.setCopyFromPath(null);
            revNode.setCopyFromRevision(-1L);
        } else {
            FSRevisionNode.parseCopyFrom(copyfrom, revNode);
        }
        revNode.myIsFreshTxnRoot = headers.containsKey(HEADER_IS_FRESH_TXN_ROOT);
        String mergeInfoCountStr = (String)headers.get(HEADER_MERGE_INFO_COUNT);
        if (mergeInfoCountStr == null) {
            revNode.myMergeInfoCount = 0L;
        } else {
            try {
                revNode.myMergeInfoCount = Long.parseLong(mergeInfoCountStr);
            }
            catch (NumberFormatException e) {
                SVNErrorMessage err6 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Corrupted mergeinfo count in node-rev");
                SVNErrorManager.error(err6, e, SVNLogType.FSFS);
            }
        }
        revNode.myHasMergeInfo = headers.containsKey(HEADER_MERGE_INFO_HERE);
        return revNode;
    }

    public static void parseRepresentationHeader(String representation, FSRevisionNode revNode, String txnId, boolean isData, boolean mutableRepTuncated) throws SVNException {
        String uniquifier;
        SVNErrorMessage err;
        SVNErrorMessage err2;
        SVNErrorMessage err3;
        SVNErrorMessage err4;
        if (revNode == null) {
            return;
        }
        FSRepresentation rep = new FSRepresentation();
        int delimiterInd = representation.indexOf(32);
        String revision = null;
        revision = delimiterInd == -1 ? representation : representation.substring(0, delimiterInd);
        long rev = -1L;
        try {
            rev = Long.parseLong(revision);
        }
        catch (NumberFormatException nfe) {
            SVNErrorMessage err5 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text rep offset line in node-rev");
            SVNErrorManager.error(err5, SVNLogType.FSFS);
        }
        rep.setRevision(rev);
        if (FSRepository.isInvalidRevision(rep.getRevision())) {
            rep.setTxnId(txnId);
            if (isData) {
                revNode.setTextRepresentation(rep);
            } else {
                revNode.setPropsRepresentation(rep);
            }
            if (mutableRepTuncated) {
                return;
            }
        }
        if ((delimiterInd = (representation = representation.substring(delimiterInd + 1)).indexOf(32)) == -1) {
            SVNErrorMessage err6 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text rep offset line in node-rev");
            SVNErrorManager.error(err6, SVNLogType.FSFS);
        }
        String repOffset = representation.substring(0, delimiterInd);
        long offset = -1L;
        try {
            offset = Long.parseLong(repOffset);
            if (offset < 0L) {
                err4 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text rep offset line in node-rev");
                SVNErrorManager.error(err4, SVNLogType.FSFS);
            }
        }
        catch (NumberFormatException nfe) {
            SVNErrorMessage err7 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text rep offset line in node-rev");
            SVNErrorManager.error(err7, SVNLogType.FSFS);
        }
        rep.setItemIndex(offset);
        representation = representation.substring(delimiterInd + 1);
        delimiterInd = representation.indexOf(32);
        if (delimiterInd == -1) {
            err4 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text rep offset line in node-rev");
            SVNErrorManager.error(err4, SVNLogType.FSFS);
        }
        String repSize = representation.substring(0, delimiterInd);
        long size = -1L;
        try {
            size = Long.parseLong(repSize);
            if (size < 0L) {
                err3 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text rep offset line in node-rev");
                SVNErrorManager.error(err3, SVNLogType.FSFS);
            }
        }
        catch (NumberFormatException nfe) {
            SVNErrorMessage err8 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text rep offset line in node-rev");
            SVNErrorManager.error(err8, SVNLogType.FSFS);
        }
        rep.setSize(size);
        representation = representation.substring(delimiterInd + 1);
        delimiterInd = representation.indexOf(32);
        if (delimiterInd == -1) {
            err3 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text rep offset line in node-rev");
            SVNErrorManager.error(err3, SVNLogType.FSFS);
        }
        String repExpandedSize = representation.substring(0, delimiterInd);
        long expandedSize = -1L;
        try {
            expandedSize = Long.parseLong(repExpandedSize);
            if (expandedSize < 0L) {
                SVNErrorMessage err9 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text rep offset line in node-rev");
                SVNErrorManager.error(err9, SVNLogType.FSFS);
            }
        }
        catch (NumberFormatException nfe) {
            err2 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text rep offset line in node-rev");
            SVNErrorManager.error(err2, SVNLogType.FSFS);
        }
        rep.setExpandedSize(expandedSize);
        representation = representation.substring(delimiterInd + 1);
        delimiterInd = representation.indexOf(32);
        String hexMD5Digest = null;
        hexMD5Digest = delimiterInd == -1 ? representation : representation.substring(0, delimiterInd);
        if (hexMD5Digest.length() != 32 || SVNFileUtil.fromHexDigest(hexMD5Digest) == null) {
            err2 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text rep offset line in node-rev");
            SVNErrorManager.error(err2, SVNLogType.FSFS);
        }
        rep.setMD5HexDigest(hexMD5Digest);
        if (isData) {
            revNode.setTextRepresentation(rep);
        } else {
            revNode.setPropsRepresentation(rep);
        }
        if (delimiterInd == -1) {
            return;
        }
        representation = representation.substring(delimiterInd + 1);
        delimiterInd = representation.indexOf(32);
        String hexSHA1Digest = null;
        if (delimiterInd == -1) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text rep offset line in node-rev");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (!"-".equals(hexSHA1Digest = representation.substring(0, delimiterInd))) {
            if (hexSHA1Digest.length() != 40 || SVNFileUtil.fromHexDigest(hexSHA1Digest) == null) {
                err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text rep offset line in node-rev");
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            rep.setSHA1HexDigest(hexSHA1Digest);
        }
        if (!"-".equals(uniquifier = (delimiterInd = (representation = representation.substring(delimiterInd + 1)).indexOf(32)) != -1 ? representation.substring(0, delimiterInd) : representation)) {
            rep.setUniquifier(uniquifier);
        }
    }

    private static void parseCopyFrom(String copyfrom, FSRevisionNode revNode) throws SVNException {
        int delimiterInd;
        if (copyfrom == null || copyfrom.length() == 0) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed copyfrom line in node-rev");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if ((delimiterInd = copyfrom.indexOf(32)) == -1) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed copyfrom line in node-rev");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        String copyfromRev = copyfrom.substring(0, delimiterInd);
        String copyfromPath = copyfrom.substring(delimiterInd + 1);
        long rev = -1L;
        try {
            rev = Long.parseLong(copyfromRev);
        }
        catch (NumberFormatException nfe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed copyfrom line in node-rev");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        revNode.setCopyFromRevision(rev);
        revNode.setCopyFromPath(copyfromPath);
    }

    private static void parseCopyRoot(String copyroot, FSRevisionNode revNode) throws SVNException {
        int delimiterInd;
        if (copyroot == null || copyroot.length() == 0) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed copyroot line in node-rev");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if ((delimiterInd = copyroot.indexOf(32)) == -1) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed copyroot line in node-rev");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        String copyrootRev = copyroot.substring(0, delimiterInd);
        String copyrootPath = copyroot.substring(delimiterInd + 1);
        long rev = -1L;
        try {
            rev = Long.parseLong(copyrootRev);
        }
        catch (NumberFormatException nfe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed copyroot line in node-rev");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        revNode.setCopyRootRevision(rev);
        revNode.setCopyRootPath(copyrootPath);
    }

    public FSRevisionNode getChildDirNode(String childName, FSFS fsfsOwner) throws SVNException {
        Map entries;
        FSEntry entry;
        if (!SVNPathUtil.isSinglePathComponent(childName)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_SINGLE_PATH_COMPONENT, "Attempted to open node with an illegal name ''{0}''", (Object)childName);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        FSEntry fSEntry = entry = (entries = this.getDirEntries(fsfsOwner)) != null ? (FSEntry)entries.get(childName) : null;
        if (entry == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Attempted to open non-existent child node ''{0}''", (Object)childName);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        return fsfsOwner.getRevisionNode(entry.getId());
    }

    public Map getDirEntries(FSFS fsfsOwner) throws SVNException {
        Map dirContents;
        if (this.getType() != SVNNodeKind.DIR) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_DIRECTORY, "Can't get entries of non-directory");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if ((dirContents = this.getDirContents()) == null) {
            dirContents = fsfsOwner.getDirContents(this);
            this.setDirContents(dirContents);
        }
        return Collections.unmodifiableMap(dirContents);
    }

    public SVNProperties getProperties(FSFS fsfsOwner) throws SVNException {
        return fsfsOwner.getProperties(this);
    }

    public FSRepresentation chooseDeltaBase(FSFS fsfsOwner) throws SVNException {
        if (this.getCount() == 0L) {
            return null;
        }
        long count = this.getCount();
        count &= count - 1L;
        FSRevisionNode baseNode = this;
        while (count++ < this.getCount()) {
            baseNode = fsfsOwner.getRevisionNode(baseNode.getPredecessorId());
        }
        return baseNode.getTextRepresentation();
    }

    public String getFileMD5Checksum() throws SVNException {
        if (this.getType() != SVNNodeKind.FILE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FILE, "Attempted to get checksum of a *non*-file node");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        return this.getTextRepresentation() != null ? this.getTextRepresentation().getMD5HexDigest() : "";
    }

    public String getFileSHA1Checksum() throws SVNException {
        if (this.getType() != SVNNodeKind.FILE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FILE, "Attempted to get checksum of a *non*-file node");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        return this.getTextRepresentation() != null ? this.getTextRepresentation().getSHA1HexDigest() : "";
    }

    public long getFileLength() throws SVNException {
        if (this.getType() != SVNNodeKind.FILE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FILE, "Attempted to get length of a *non*-file node");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        return this.getTextRepresentation() != null ? this.getTextRepresentation().getExpandedSize() : 0L;
    }

    public void setIsFreshTxnRoot(boolean isFreshTxnRoot) {
        this.myIsFreshTxnRoot = isFreshTxnRoot;
    }

    public boolean isFreshTxnRoot() {
        return this.myIsFreshTxnRoot;
    }

    public void setFreshRootPredecessorId(FSID freshRootPredecessorId) {
        this.myFreshRootPredecessorId = freshRootPredecessorId;
    }
}

