/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.derby.client.am.ConversionException;

public class DateTime {
    private static final int dateRepresentationLength = 10;
    private static final int timeRepresentationLength = 8;
    private static final int timestampRepresentationLength = 26;

    private DateTime() {
    }

    public static final Date dateBytesToDate(byte[] byArray, int n, Date date, String string) throws UnsupportedEncodingException {
        String string2 = new String(byArray, n, 10, string);
        if (string2.charAt(4) != '-') {
            throw new IllegalArgumentException("Unsupported date format!");
        }
        int n2 = 0;
        int n3 = 5;
        int n4 = 8;
        int n5 = 48;
        int n6 = 1000 * (string2.charAt(n2) - n5) + 100 * (string2.charAt(n2 + 1) - n5) + 10 * (string2.charAt(n2 + 2) - n5) + (string2.charAt(n2 + 3) - n5) - 1900;
        int n7 = 10 * (string2.charAt(n3) - n5) + (string2.charAt(n3 + 1) - n5) - 1;
        int n8 = 10 * (string2.charAt(n4) - n5) + (string2.charAt(n4 + 1) - n5);
        if (date == null) {
            return new Date(n6, n7, n8);
        }
        date.setYear(n6);
        date.setMonth(n7);
        date.setDate(n8);
        return date;
    }

    public static final Time timeBytesToTime(byte[] byArray, int n, Time time, String string) throws UnsupportedEncodingException {
        String string2 = new String(byArray, n, 8, string);
        int n2 = 48;
        int n3 = 10 * (string2.charAt(0) - n2) + (string2.charAt(1) - n2);
        int n4 = 10 * (string2.charAt(3) - n2) + (string2.charAt(4) - n2);
        int n5 = 10 * (string2.charAt(6) - n2) + (string2.charAt(7) - n2);
        if (time == null) {
            return new Time(n3, n4, n5);
        }
        time.setHours(n3);
        time.setMinutes(n4);
        time.setSeconds(n5);
        return time;
    }

    public static final Timestamp timestampBytesToTimestamp(byte[] byArray, int n, Timestamp timestamp, String string) throws UnsupportedEncodingException {
        String string2 = new String(byArray, n, 26, string);
        int n2 = 48;
        int n3 = 1000 * (string2.charAt(0) - n2) + 100 * (string2.charAt(1) - n2) + 10 * (string2.charAt(2) - n2) + (string2.charAt(3) - n2) - 1900;
        int n4 = 10 * (string2.charAt(5) - n2) + (string2.charAt(6) - n2) - 1;
        int n5 = 10 * (string2.charAt(8) - n2) + (string2.charAt(9) - n2);
        int n6 = 10 * (string2.charAt(11) - n2) + (string2.charAt(12) - n2);
        int n7 = 10 * (string2.charAt(14) - n2) + (string2.charAt(15) - n2);
        int n8 = 10 * (string2.charAt(17) - n2) + (string2.charAt(18) - n2);
        int n9 = 100000 * (string2.charAt(20) - n2) + 10000 * (string2.charAt(21) - n2) + 1000 * (string2.charAt(22) - n2) + 100 * (string2.charAt(23) - n2) + 10 * (string2.charAt(24) - n2) + (string2.charAt(25) - n2);
        if (timestamp == null) {
            return new Timestamp(n3, n4, n5, n6, n7, n8, n9 * 1000);
        }
        timestamp.setYear(n3);
        timestamp.setMonth(n4);
        timestamp.setDate(n5);
        timestamp.setHours(n6);
        timestamp.setMinutes(n7);
        timestamp.setSeconds(n8);
        timestamp.setNanos(n9 * 1000);
        return timestamp;
    }

    public static final int dateToDateBytes(byte[] byArray, int n, Date date) throws ConversionException, UnsupportedEncodingException {
        int n2 = date.getYear() + 1900;
        if (n2 > 9999) {
            throw new ConversionException("Year exceeds the maximum \"9999\".");
        }
        int n3 = date.getMonth() + 1;
        int n4 = date.getDate();
        char[] cArray = new char[10];
        int n5 = 48;
        cArray[0] = (char)(n2 / 1000 + n5);
        cArray[1] = (char)(n2 % 1000 / 100 + n5);
        cArray[2] = (char)(n2 % 100 / 10 + n5);
        cArray[3] = (char)(n2 % 10 + n5);
        cArray[4] = 45;
        cArray[5] = (char)(n3 / 10 + n5);
        cArray[6] = (char)(n3 % 10 + n5);
        cArray[7] = 45;
        cArray[8] = (char)(n4 / 10 + n5);
        cArray[9] = (char)(n4 % 10 + n5);
        byte[] byArray2 = new String(cArray).getBytes("UTF8");
        System.arraycopy(byArray2, 0, byArray, n, 10);
        return 10;
    }

    public static final int timeToTimeBytes(byte[] byArray, int n, Time time) throws UnsupportedEncodingException {
        int n2 = time.getHours();
        int n3 = time.getMinutes();
        int n4 = time.getSeconds();
        char[] cArray = new char[8];
        int n5 = 48;
        cArray[0] = (char)(n2 / 10 + n5);
        cArray[1] = (char)(n2 % 10 + n5);
        cArray[2] = 58;
        cArray[3] = (char)(n3 / 10 + n5);
        cArray[4] = (char)(n3 % 10 + n5);
        cArray[5] = 58;
        cArray[6] = (char)(n4 / 10 + n5);
        cArray[7] = (char)(n4 % 10 + n5);
        byte[] byArray2 = new String(cArray).getBytes("UTF8");
        System.arraycopy(byArray2, 0, byArray, n, 8);
        return 8;
    }

    public static final int timestampToTimestampBytes(byte[] byArray, int n, Timestamp timestamp) throws ConversionException, UnsupportedEncodingException {
        int n2 = timestamp.getYear() + 1900;
        if (n2 > 9999) {
            throw new ConversionException("Year exceeds the maximum \"9999\".");
        }
        int n3 = timestamp.getMonth() + 1;
        int n4 = timestamp.getDate();
        int n5 = timestamp.getHours();
        int n6 = timestamp.getMinutes();
        int n7 = timestamp.getSeconds();
        int n8 = timestamp.getNanos() / 1000;
        char[] cArray = new char[26];
        int n9 = 48;
        cArray[0] = (char)(n2 / 1000 + n9);
        cArray[1] = (char)(n2 % 1000 / 100 + n9);
        cArray[2] = (char)(n2 % 100 / 10 + n9);
        cArray[3] = (char)(n2 % 10 + n9);
        cArray[4] = 45;
        cArray[5] = (char)(n3 / 10 + n9);
        cArray[6] = (char)(n3 % 10 + n9);
        cArray[7] = 45;
        cArray[8] = (char)(n4 / 10 + n9);
        cArray[9] = (char)(n4 % 10 + n9);
        cArray[10] = 45;
        cArray[11] = (char)(n5 / 10 + n9);
        cArray[12] = (char)(n5 % 10 + n9);
        cArray[13] = 46;
        cArray[14] = (char)(n6 / 10 + n9);
        cArray[15] = (char)(n6 % 10 + n9);
        cArray[16] = 46;
        cArray[17] = (char)(n7 / 10 + n9);
        cArray[18] = (char)(n7 % 10 + n9);
        cArray[19] = 46;
        cArray[20] = (char)(n8 / 100000 + n9);
        cArray[21] = (char)(n8 % 100000 / 10000 + n9);
        cArray[22] = (char)(n8 % 10000 / 1000 + n9);
        cArray[23] = (char)(n8 % 1000 / 100 + n9);
        cArray[24] = (char)(n8 % 100 / 10 + n9);
        cArray[25] = (char)(n8 % 10 + n9);
        byte[] byArray2 = new String(cArray).getBytes("UTF8");
        System.arraycopy(byArray2, 0, byArray, n, 26);
        return 26;
    }

    public static final Timestamp dateBytesToTimestamp(byte[] byArray, int n, Timestamp timestamp, String string) throws UnsupportedEncodingException {
        String string2 = new String(byArray, n, 10, string);
        int n2 = 0;
        int n3 = 5;
        int n4 = 8;
        int n5 = 48;
        int n6 = 1000 * (string2.charAt(n2) - n5) + 100 * (string2.charAt(n2 + 1) - n5) + 10 * (string2.charAt(n2 + 2) - n5) + (string2.charAt(n2 + 3) - n5) - 1900;
        int n7 = 10 * (string2.charAt(n3) - n5) + (string2.charAt(n3 + 1) - n5) - 1;
        int n8 = 10 * (string2.charAt(n4) - n5) + (string2.charAt(n4 + 1) - n5);
        if (timestamp == null) {
            return new Timestamp(n6, n7, n8, 0, 0, 0, 0);
        }
        timestamp.setYear(n6);
        timestamp.setMonth(n7);
        timestamp.setDate(n8);
        timestamp.setHours(0);
        timestamp.setMinutes(0);
        timestamp.setSeconds(0);
        timestamp.setNanos(0);
        return timestamp;
    }

    public static final Timestamp timeBytesToTimestamp(byte[] byArray, int n, Timestamp timestamp, String string) throws UnsupportedEncodingException {
        String string2 = new String(byArray, n, 8, string);
        int n2 = 48;
        int n3 = 10 * (string2.charAt(0) - n2) + (string2.charAt(1) - n2);
        int n4 = 10 * (string2.charAt(3) - n2) + (string2.charAt(4) - n2);
        int n5 = 10 * (string2.charAt(6) - n2) + (string2.charAt(7) - n2);
        if (timestamp == null) {
            return new Timestamp(0, 0, 1, n3, n4, n5, 0);
        }
        timestamp.setYear(0);
        timestamp.setMonth(0);
        timestamp.setDate(1);
        timestamp.setHours(n3);
        timestamp.setMinutes(n4);
        timestamp.setSeconds(n5);
        timestamp.setNanos(0);
        return timestamp;
    }

    public static final Date timestampBytesToDate(byte[] byArray, int n, Date date, String string) throws UnsupportedEncodingException {
        String string2 = new String(byArray, n, 26, string);
        int n2 = 48;
        int n3 = 1000 * (string2.charAt(0) - n2) + 100 * (string2.charAt(1) - n2) + 10 * (string2.charAt(2) - n2) + (string2.charAt(3) - n2) - 1900;
        int n4 = 10 * (string2.charAt(5) - n2) + (string2.charAt(6) - n2) - 1;
        int n5 = 10 * (string2.charAt(8) - n2) + (string2.charAt(9) - n2);
        if (date == null) {
            return new Date(n3, n4, n5);
        }
        date.setYear(n3);
        date.setMonth(n4);
        date.setDate(n5);
        return date;
    }

    public static final Time timestampBytesToTime(byte[] byArray, int n, Time time, String string) throws UnsupportedEncodingException {
        String string2 = new String(byArray, n, 26, string);
        int n2 = 48;
        int n3 = 10 * (string2.charAt(11) - n2) + (string2.charAt(12) - n2);
        int n4 = 10 * (string2.charAt(14) - n2) + (string2.charAt(15) - n2);
        int n5 = 10 * (string2.charAt(17) - n2) + (string2.charAt(18) - n2);
        if (time == null) {
            return new Time(n3, n4, n5);
        }
        time.setYear(n3);
        time.setMonth(n4);
        time.setDate(n5);
        return time;
    }

    public static final int timestampToDateBytes(byte[] byArray, int n, Timestamp timestamp) throws ConversionException, UnsupportedEncodingException {
        int n2 = timestamp.getYear() + 1900;
        if (n2 > 9999) {
            throw new ConversionException("Year exceeds the maximum \"9999\".");
        }
        int n3 = timestamp.getMonth() + 1;
        int n4 = timestamp.getDate();
        char[] cArray = new char[10];
        int n5 = 48;
        cArray[0] = (char)(n2 / 1000 + n5);
        cArray[1] = (char)(n2 % 1000 / 100 + n5);
        cArray[2] = (char)(n2 % 100 / 10 + n5);
        cArray[3] = (char)(n2 % 10 + n5);
        cArray[4] = 45;
        cArray[5] = (char)(n3 / 10 + n5);
        cArray[6] = (char)(n3 % 10 + n5);
        cArray[7] = 45;
        cArray[8] = (char)(n4 / 10 + n5);
        cArray[9] = (char)(n4 % 10 + n5);
        byte[] byArray2 = new String(cArray).getBytes("UTF8");
        System.arraycopy(byArray2, 0, byArray, n, 10);
        return 10;
    }

    public static final int timestampToTimeBytes(byte[] byArray, int n, Timestamp timestamp) throws UnsupportedEncodingException {
        int n2 = timestamp.getHours();
        int n3 = timestamp.getMinutes();
        int n4 = timestamp.getSeconds();
        char[] cArray = new char[8];
        int n5 = 48;
        cArray[0] = (char)(n2 / 10 + n5);
        cArray[1] = (char)(n2 % 10 + n5);
        cArray[2] = 58;
        cArray[3] = (char)(n3 / 10 + n5);
        cArray[4] = (char)(n3 % 10 + n5);
        cArray[5] = 58;
        cArray[6] = (char)(n4 / 10 + n5);
        cArray[7] = (char)(n4 % 10 + n5);
        byte[] byArray2 = new String(cArray).getBytes("UTF8");
        System.arraycopy(byArray2, 0, byArray, n, 8);
        return 8;
    }

    public static final int dateToTimestampBytes(byte[] byArray, int n, Date date) throws ConversionException, UnsupportedEncodingException {
        int n2 = date.getYear() + 1900;
        if (n2 > 9999) {
            throw new ConversionException("Year exceeds the maximum \"9999\".");
        }
        int n3 = date.getMonth() + 1;
        int n4 = date.getDate();
        char[] cArray = new char[26];
        int n5 = 48;
        cArray[0] = (char)(n2 / 1000 + n5);
        cArray[1] = (char)(n2 % 1000 / 100 + n5);
        cArray[2] = (char)(n2 % 100 / 10 + n5);
        cArray[3] = (char)(n2 % 10 + n5);
        cArray[4] = 45;
        cArray[5] = (char)(n3 / 10 + n5);
        cArray[6] = (char)(n3 % 10 + n5);
        cArray[7] = 45;
        cArray[8] = (char)(n4 / 10 + n5);
        cArray[9] = (char)(n4 % 10 + n5);
        cArray[10] = 45;
        cArray[11] = 48;
        cArray[12] = 48;
        cArray[13] = 46;
        cArray[14] = 48;
        cArray[15] = 48;
        cArray[16] = 46;
        cArray[17] = 48;
        cArray[18] = 48;
        cArray[19] = 46;
        cArray[20] = 48;
        cArray[21] = 48;
        cArray[22] = 48;
        cArray[23] = 48;
        cArray[24] = 48;
        cArray[25] = 48;
        byte[] byArray2 = new String(cArray).getBytes("UTF8");
        System.arraycopy(byArray2, 0, byArray, n, 26);
        return 26;
    }

    public static final int timeToTimestampBytes(byte[] byArray, int n, Time time) throws UnsupportedEncodingException {
        int n2 = time.getHours();
        int n3 = time.getMinutes();
        int n4 = time.getSeconds();
        char[] cArray = new char[26];
        int n5 = 48;
        cArray[0] = 49;
        cArray[1] = 57;
        cArray[2] = 48;
        cArray[3] = 48;
        cArray[4] = 45;
        cArray[5] = 48;
        cArray[6] = 49;
        cArray[7] = 45;
        cArray[8] = 48;
        cArray[9] = 49;
        cArray[10] = 45;
        cArray[11] = (char)(n2 / 10 + n5);
        cArray[12] = (char)(n2 % 10 + n5);
        cArray[13] = 46;
        cArray[14] = (char)(n3 / 10 + n5);
        cArray[15] = (char)(n3 % 10 + n5);
        cArray[16] = 46;
        cArray[17] = (char)(n4 / 10 + n5);
        cArray[18] = (char)(n4 % 10 + n5);
        cArray[19] = 46;
        cArray[20] = 48;
        cArray[21] = 48;
        cArray[22] = 48;
        cArray[23] = 48;
        cArray[24] = 48;
        cArray[25] = 48;
        byte[] byArray2 = new String(cArray).getBytes("UTF8");
        System.arraycopy(byArray2, 0, byArray, n, 26);
        return 26;
    }
}

