/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.anttasks;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.greenstone.anttasks.RegexSearchReplaceJob;

public class RegexSearchReplace
extends Task {
    private File file = null;
    private ArrayList jobs = null;
    private FileSet fileset = null;
    private String pattern = null;
    private String replacement = null;
    private int verbosity = 1;
    private int fromLine = -1;
    private int toLine = -1;
    private boolean winPath = false;

    public static void main(String[] stringArray) {
        RegexSearchReplace regexSearchReplace = new RegexSearchReplace();
        regexSearchReplace.setFile(new File(stringArray[0]));
        regexSearchReplace.setPattern(stringArray[1]);
        regexSearchReplace.setReplacement(stringArray[2]);
        regexSearchReplace.setLines(stringArray[3]);
        regexSearchReplace.execute();
    }

    public void execute() {
        int n;
        if (this.file == null && this.fileset == null) {
            throw new BuildException("Error - No file or fileset specified !!");
        }
        if (this.file != null && !this.file.exists()) {
            throw new BuildException("Error - File not found !!");
        }
        DirectoryScanner directoryScanner = null;
        if (this.fileset != null) {
            directoryScanner = this.fileset.getDirectoryScanner(this.project);
            directoryScanner.scan();
        }
        if (this.jobs == null && this.pattern == null) {
            throw new BuildException("Error - No pattern attribute and no nested jobs !!");
        }
        if (this.jobs != null && this.pattern != null) {
            throw new BuildException("Error - Both pattern attribute and nested jobs given !!");
        }
        if (this.pattern != null && this.replacement == null) {
            throw new BuildException("Error - pattern attribute given but no replacement attribute given !!");
        }
        if (this.jobs != null) {
            for (int i = 0; i < this.jobs.size(); ++i) {
                if (((RegexSearchReplaceJob)((Object)this.jobs.get(i))).getPattern() == null) {
                    throw new BuildException("Error - One of the jobs lacks a pattern!!");
                }
                if (((RegexSearchReplaceJob)((Object)this.jobs.get(i))).getReplacement() != null) continue;
                throw new BuildException("Error - One of the jobs lacks a replacement!!");
            }
        }
        File[] fileArray = null;
        if (this.file != null) {
            fileArray = new File[]{this.file};
        } else {
            String[] stringArray = directoryScanner.getIncludedFiles();
            fileArray = new File[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                fileArray[n] = new File(directoryScanner.getBasedir() + File.separator + stringArray[n]);
            }
        }
        if (this.verbosity >= 3) {
            System.out.println("--------------------");
            System.out.println(" RegexSearchReplace ");
            System.out.println("--------------------");
            System.out.println("Replacements:");
            if (this.pattern != null) {
                System.out.println(" " + this.pattern + " -> " + this.replacement);
            } else {
                for (int i = 0; i < this.jobs.size(); ++i) {
                    System.out.println(" " + ((RegexSearchReplaceJob)((Object)this.jobs.get(i))).getPattern() + " -> " + ((RegexSearchReplaceJob)((Object)this.jobs.get(i))).getReplacement());
                }
            }
            System.out.println();
            if (this.fromLine != -1 || this.toLine != -1) {
                System.out.println("Lines: " + (this.fromLine == -1 ? "Start" : Integer.toString(this.fromLine)) + " ~ " + (this.toLine == -1 ? "End" : Integer.toString(this.toLine)));
                System.out.println();
            }
        }
        if (this.verbosity == 1) {
            if (fileArray.length == 1) {
                System.out.println("Regex Search and Replace on file: ");
            } else {
                System.out.println("Regex Search and Replace on files: ");
            }
        } else if (this.verbosity > 1) {
            System.out.println("File(s): ");
        }
        for (int i = 0; i < fileArray.length; ++i) {
            FileOutputStream fileOutputStream;
            Object object;
            Object object2;
            n = 0;
            File file = fileArray[i];
            if (this.verbosity >= 1) {
                System.out.println(" " + file);
            }
            BufferedWriter bufferedWriter = null;
            File file2 = null;
            try {
                file2 = File.createTempFile("rsr", ".tmp");
                file2.deleteOnExit();
                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF8"));
            }
            catch (IOException iOException) {
                throw new BuildException("Error - Couldn't create or open the temp file");
            }
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            }
            catch (Exception exception) {
                throw new BuildException("Error - Couldn't open the specified file");
            }
            String string = null;
            int n2 = 1;
            boolean bl = true;
            while (bl) {
                try {
                    string = bufferedReader.readLine();
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                    throw new BuildException("Error - Couldn't read from the specified file");
                }
                if (string == null) {
                    bl = false;
                } else {
                    if (!(this.fromLine != -1 && n2 < this.fromLine || this.toLine != -1 && n2 >= this.toLine)) {
                        object2 = string;
                        if (this.pattern != null) {
                            String string2 = this.replacement;
                            if (this.winPath) {
                                string2 = string2.replaceAll("\\\\", "\\\\\\\\");
                            }
                            string = string.replaceAll(this.pattern, string2);
                        } else {
                            for (int j = 0; j < this.jobs.size(); ++j) {
                                object = ((RegexSearchReplaceJob)((Object)this.jobs.get(j))).getReplacement();
                                if (((RegexSearchReplaceJob)((Object)this.jobs.get(j))).getWinPath()) {
                                    object = ((String)object).replaceAll("\\\\", "\\\\\\\\");
                                }
                                string = string.replaceAll(((RegexSearchReplaceJob)((Object)this.jobs.get(j))).getPattern(), (String)object);
                            }
                        }
                        if (!((String)object2).equals(string)) {
                            ++n;
                        }
                    }
                    try {
                        bufferedWriter.write(string);
                        bufferedWriter.newLine();
                    }
                    catch (Exception exception) {
                        throw new BuildException("Error - Couldn't write to the temp file");
                    }
                }
                ++n2;
            }
            try {
                bufferedReader.close();
                bufferedWriter.close();
            }
            catch (Exception exception) {
                throw new BuildException("Error - Couldn't close a file");
            }
            try {
                object2 = new FileInputStream(file2);
                fileOutputStream = new FileOutputStream(file);
            }
            catch (Exception exception) {
                throw new BuildException("Error - Couldn't open the temp file");
            }
            try {
                int n3;
                object = new byte[1024];
                while ((n3 = ((InputStream)object2).read((byte[])object)) > 0) {
                    ((OutputStream)fileOutputStream).write((byte[])object, 0, n3);
                }
                ((InputStream)object2).close();
                ((OutputStream)fileOutputStream).close();
            }
            catch (Exception exception) {
                throw new BuildException("Error - Couldn't write to the specified file");
            }
            if (this.verbosity < 2) continue;
            if (n == 0) {
                System.out.println(" No Changes Made");
            } else if (n == 1) {
                System.out.println(" Successfully changed 1 line");
            } else {
                System.out.println(" Successfully changed " + n + " lines");
            }
            System.out.println();
        }
    }

    public void setFile(File file) {
        if (this.fileset != null || this.file != null) {
            throw new BuildException("Error - Only one file or one fileset may be given!!");
        }
        this.file = file;
    }

    public void setLines(String string) {
        string.replaceAll("\\s", "");
        if (string == "") {
            throw new BuildException("Error - no line number(s) given in lines attribute!! ");
        }
        String[] stringArray = string.split("-", 2);
        try {
            if (stringArray.length == 1) {
                this.fromLine = Integer.parseInt(stringArray[0]);
                this.toLine = this.fromLine + 1;
            } else {
                if (!stringArray[0].equals("")) {
                    this.fromLine = Integer.parseInt(stringArray[0]);
                }
                if (!stringArray[1].equals("")) {
                    this.toLine = Integer.parseInt(stringArray[1]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new BuildException("Error - invalid line numbers given in lines attribute!! '" + stringArray[0] + "' - '" + stringArray[1] + "'");
        }
    }

    public void setVerbosity(String string) {
        string.replaceAll("\\s", "");
        if (string == "") {
            throw new BuildException("Error - no value found in 'verbosity' attribute!");
        }
        try {
            this.verbosity = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BuildException("Error - invalid line numbers given in 'verbosity' attribute! '" + string + "'");
        }
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public void setReplacement(String string) {
        this.replacement = string = string.replaceAll("\\\\", "\\\\\\\\");
    }

    public void setWinPath(boolean bl) {
        this.winPath = bl;
    }

    public RegexSearchReplaceJob createJob() {
        RegexSearchReplaceJob regexSearchReplaceJob = new RegexSearchReplaceJob();
        if (this.jobs == null) {
            this.jobs = new ArrayList();
        }
        this.jobs.add(regexSearchReplaceJob);
        return regexSearchReplaceJob;
    }

    public FileSet createFileset() {
        if (this.fileset != null || this.file != null) {
            throw new BuildException("Error - Only one file or one fileset may be given!!");
        }
        this.fileset = new FileSet();
        return this.fileset;
    }
}

