/*
 * Decompiled with CFR 0.152.
 */
package ise.library;

import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;

public class TableArray
implements Map,
Serializable,
Cloneable {
    private TreeMap table = new TreeMap(new PointComparator());
    private Object _default = null;

    public TableArray() {
        this(null);
    }

    public TableArray(Object default_value) {
        this._default = default_value;
    }

    public void setDefaultValue(Object value) {
        this._default = value;
    }

    public Object getDefaultValue() {
        return this._default;
    }

    public Object put(int x, int y, Object o) {
        Object old_object = this.get(x, y);
        Point p = new Point(x, y);
        if (o != null && o.equals(this.getDefaultValue())) {
            this.remove(p);
        } else if (o == null && this.getDefaultValue() == null) {
            this.remove(p);
        } else {
            this.table.put(p, o);
        }
        return old_object;
    }

    public Object put(Object o, int x, int y) {
        return this.put(x, y, o);
    }

    public Object get(int x, int y) {
        Point p = new Point(x, y);
        Object o = this.table.get(p);
        if (o == null) {
            o = this._default;
        }
        return o;
    }

    public int getWidth() {
        if (this.table.size() == 0) {
            return 0;
        }
        return this.getMaxX() - this.getMinX() + 1;
    }

    public int getColumnCount() {
        return this.getWidth();
    }

    public int getHeight() {
        if (this.table.size() == 0) {
            return 0;
        }
        return this.getMaxY() - this.getMinY() + 1;
    }

    public int getRowCount() {
        return this.getHeight();
    }

    public int getMinX() {
        Point p;
        if (this.table.size() == 0) {
            return 0;
        }
        int smallest_x = 0;
        Iterator it = this.table.keySet().iterator();
        if (it.hasNext()) {
            p = (Point)it.next();
            smallest_x = p.x;
        }
        while (it.hasNext()) {
            p = (Point)it.next();
            if (p.x >= smallest_x) continue;
            smallest_x = p.x;
        }
        return smallest_x;
    }

    public int getMinY() {
        if (this.table.size() == 0) {
            return 0;
        }
        Point p = (Point)this.table.firstKey();
        return p.y;
    }

    public int getMaxX() {
        Point p;
        if (this.table.size() == 0) {
            return 0;
        }
        int largest_x = 0;
        Iterator it = this.table.keySet().iterator();
        if (it.hasNext()) {
            p = (Point)it.next();
            largest_x = p.x;
        }
        while (it.hasNext()) {
            p = (Point)it.next();
            if (p.x <= largest_x) continue;
            largest_x = p.x;
        }
        return largest_x;
    }

    public int getMaxY() {
        if (this.table.size() == 0) {
            return 0;
        }
        Point p = (Point)this.table.lastKey();
        return p.y;
    }

    public void clear() {
        this.table.clear();
    }

    public boolean containsKey(Object key) {
        return this.table.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.table.containsValue(value);
    }

    public Set entrySet() {
        return this.table.entrySet();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        try {
            TableArray ta = (TableArray)o;
            if (ta.size() != this.size()) {
                return false;
            }
            Iterator it = this.pointIterator();
            while (it.hasNext()) {
                Point p = (Point)it.next();
                if (this.get(p).equals(ta.get(p))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public Object get(Object key) {
        Point p = (Point)key;
        return this.get(p.x, p.y);
    }

    public List getRow(int row) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int x = this.getMinX(); x <= this.getMaxX(); ++x) {
            list.add(this.get(x, row));
        }
        return list;
    }

    public void putRow(int row, List data) {
        this.removeRow(row);
        Iterator it = data.iterator();
        int x = 0;
        while (it.hasNext()) {
            this.put(x + this.getMinX(), row, it.next());
            ++x;
        }
    }

    public List getColumn(int col) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int y = this.getMinY(); y <= this.getMaxY(); ++y) {
            list.add(this.get(col, y));
        }
        return list;
    }

    public void putColumn(int col, List data) {
        for (int y = this.getMinY(); y <= this.getMaxY(); ++y) {
            this.remove(col, y);
        }
        Iterator it = data.iterator();
        int y = this.getMinY();
        while (it.hasNext()) {
            this.put(col, y, it.next());
            ++y;
        }
    }

    public int hashCode() {
        return this.table.hashCode();
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public Set keySet() {
        return this.table.keySet();
    }

    public Set pointSet() {
        return this.keySet();
    }

    public Iterator pointIterator() {
        return new Iterator(){
            private int min_x;
            private int min_y;
            private int max_x;
            private int max_y;
            private int x;
            private int y;
            {
                this.min_x = TableArray.this.getMinX();
                this.min_y = TableArray.this.getMinY();
                this.max_x = TableArray.this.getMaxX();
                this.max_y = TableArray.this.getMaxY();
                this.x = this.min_x;
                this.y = this.min_y;
            }

            public boolean hasNext() {
                return this.x <= this.max_x && this.y <= this.max_y;
            }

            public Object next() {
                if (this.hasNext()) {
                    Point p = new Point(this.x, this.y);
                    ++this.x;
                    if (this.x > this.max_x) {
                        this.x = this.min_x;
                        ++this.y;
                    }
                    return p;
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator valueIterator() {
        return new Iterator(){
            private int min_x;
            private int min_y;
            private int max_x;
            private int max_y;
            private int x;
            private int y;
            {
                this.min_x = TableArray.this.getMinX();
                this.min_y = TableArray.this.getMinY();
                this.max_x = TableArray.this.getMaxX();
                this.max_y = TableArray.this.getMaxY();
                this.x = this.min_x;
                this.y = this.min_y;
            }

            public boolean hasNext() {
                return this.x <= this.max_x && this.y <= this.max_y;
            }

            public Object next() {
                if (this.hasNext()) {
                    Object o = TableArray.this.get(this.x, this.y);
                    ++this.x;
                    if (this.x > this.max_x) {
                        this.x = this.min_x;
                        ++this.y;
                    }
                    return o;
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator columnIterator(int col) {
        final int c = col;
        return new Iterator(){
            private int min_y;
            private int max_y;
            private int y;
            {
                this.min_y = TableArray.this.getMinY();
                this.max_y = TableArray.this.getMaxY();
                this.y = this.min_y;
            }

            public boolean hasNext() {
                return this.y <= this.max_y;
            }

            public Object next() {
                if (this.hasNext()) {
                    Object o = TableArray.this.get(c, this.y);
                    ++this.y;
                    return o;
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator rowIterator(int row) {
        final int r = row;
        return new Iterator(){
            private int min_x;
            private int max_x;
            private int x;
            {
                this.min_x = TableArray.this.getMinX();
                this.max_x = TableArray.this.getMaxX();
                this.x = this.min_x;
            }

            public boolean hasNext() {
                return this.x <= this.max_x;
            }

            public Object next() {
                if (this.hasNext()) {
                    Object o = TableArray.this.get(this.x, r);
                    ++this.x;
                    return o;
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Object put(Object key, Object value) {
        return this.put(((Point)key).x, ((Point)key).y, value);
    }

    public void putAll(Map t) {
        Iterator it = t.keySet().iterator();
        while (it.hasNext()) {
            Point key = (Point)it.next();
            Object value = t.get(key);
            this.put(key.x, key.y, value);
        }
    }

    public Object remove(Object key) {
        return this.table.remove(key);
    }

    public Object remove(int row, int col) {
        return this.remove(new Point(row, col));
    }

    public void removeRow(int row) {
        for (int x = this.getMinX(); x < this.getMaxX(); ++x) {
            this.remove(x, row);
        }
    }

    public void removeColumn(int col) {
        for (int y = this.getMinY(); y < this.getMaxY(); ++y) {
            this.remove(col, y);
        }
    }

    public int size() {
        return this.table.size();
    }

    public int getSize() {
        return this.size();
    }

    public int getCellCount() {
        return this.getWidth() * this.getHeight();
    }

    public Collection values() {
        return this.table.values();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TableArray [(").append(this.getMinX()).append(",").append(this.getMinY()).append("), (").append(this.getMaxX()).append(",").append(this.getMaxY()).append("), w=").append(this.getWidth()).append(", h=").append(this.getHeight()).append(", size=").append(this.size()).append("]");
        if (this.size() > 0) {
            sb.append(System.getProperty("line.separator")).append(this.dataToString());
        } else {
            sb.append("[empty]");
        }
        return sb.toString();
    }

    public String dataToString() {
        StringBuffer table_data = new StringBuffer();
        String ls = System.getProperty("line.separator");
        for (int y = this.getMinY(); y <= this.getMaxY(); ++y) {
            StringBuffer row = new StringBuffer();
            row.append("[");
            for (int x = this.getMinX(); x <= this.getMaxX(); ++x) {
                Object o = this.get(x, y);
                if (o == null) {
                    o = "";
                }
                row.append(o.toString());
                if (x >= this.getMaxX()) continue;
                row.append(",");
            }
            row.append("]").append(ls);
            table_data.append(row);
        }
        return table_data.toString();
    }

    public Object clone() {
        TableArray ta = new TableArray();
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            Point p = (Point)it.next();
            ta.put(p, this.get(p.x, p.y));
        }
        return ta;
    }

    class PointComparator
    implements Comparator,
    Serializable {
        PointComparator() {
        }

        public int compare(Object a, Object b) {
            Point p1 = (Point)a;
            Point p2 = (Point)b;
            if (p1.x == p2.x && p1.y == p2.y) {
                return 0;
            }
            if (p1.y < p2.y) {
                return -1;
            }
            if (p1.y == p2.y && p1.x < p2.x) {
                return -1;
            }
            return 1;
        }
    }
}

