/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.PreloadStats;
import com.sleepycat.je.PreloadStatus;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.utilint.CmdUtil;
import java.io.File;
import java.io.PrintStream;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Random;

public class DbCacheSize {
    private static final NumberFormat INT_FORMAT = NumberFormat.getIntegerInstance();
    private static final String MAIN_HEADER = "   Cache Size       Btree Size    Description\n---------------  ---------------  -----------";
    private static final String LEVELS_HEADER = " Minimum Bytes    Maximum Bytes      Nodes    Level\n---------------  ---------------  ----------  -----";
    private static final int COLUMN_WIDTH = 15;
    private static final String COLUMN_SEPARATOR = "  ";
    private static final int MAX_LEVELS = 9;
    private final long records;
    private final int keySize;
    private final int dataSize;
    private final int nodeMax;
    private int binMax;
    private final int density;
    private final long overhead;
    private long minInBtreeSize;
    private long maxInBtreeSize;
    private long minInCacheSize;
    private long maxInCacheSize;
    private long maxInBtreeSizeWithData;
    private long maxInCacheSizeWithData;
    private long minInBtreeSizeWithData;
    private long minInCacheSizeWithData;
    private int nLevels;
    private final long[] numLevel = new long[9];
    private final long[] minLevel = new long[9];
    private final long[] maxLevel = new long[9];
    private long totalNum;

    public DbCacheSize(long records, int keySize, int dataSize, int nodeMax, int density, long overhead) {
        this.records = records;
        this.keySize = keySize;
        this.dataSize = dataSize;
        this.nodeMax = nodeMax;
        this.density = density;
        this.overhead = overhead;
    }

    private void setBinMax(int binMax) {
        this.binMax = binMax;
    }

    public long getMinCacheSizeInternalNodesOnly() {
        return this.minInCacheSize;
    }

    public long getMaxCacheSizeInternalNodesOnly() {
        return this.maxInCacheSize;
    }

    public long getMinBtreeSizeInternalNodesOnly() {
        return this.minInBtreeSize;
    }

    public long getMaxBtreeSizeInternalNodesOnly() {
        return this.maxInBtreeSize;
    }

    public long getMinCacheSizeWithData() {
        return this.minInCacheSizeWithData;
    }

    public long getMaxCacheSizeWithData() {
        return this.maxInCacheSizeWithData;
    }

    public long getMinBtreeSizeWithData() {
        return this.minInBtreeSizeWithData;
    }

    public long getMaxBtreeSizeWithData() {
        return this.maxInBtreeSizeWithData;
    }

    public int getNLevels() {
        return this.nLevels;
    }

    public static void main(String[] args) {
        try {
            long records = 0L;
            int keySize = 0;
            int dataSize = -1;
            int nodeMax = 128;
            int binMax = -1;
            int density = 80;
            long overhead = 0L;
            File measureDir = null;
            boolean measureRandom = false;
            for (int i = 0; i < args.length; ++i) {
                String name = args[i];
                String val = null;
                if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                    val = args[++i];
                }
                if (name.equals("-records")) {
                    if (val == null) {
                        DbCacheSize.usage("No value after -records");
                    }
                    try {
                        records = Long.parseLong(val);
                    }
                    catch (NumberFormatException e) {
                        DbCacheSize.usage(val + " is not a number");
                    }
                    if (records > 0L) continue;
                    DbCacheSize.usage(val + " is not a positive integer");
                    continue;
                }
                if (name.equals("-key")) {
                    if (val == null) {
                        DbCacheSize.usage("No value after -key");
                    }
                    try {
                        keySize = Integer.parseInt(val);
                    }
                    catch (NumberFormatException e) {
                        DbCacheSize.usage(val + " is not a number");
                    }
                    if (keySize > 0) continue;
                    DbCacheSize.usage(val + " is not a positive integer");
                    continue;
                }
                if (name.equals("-data")) {
                    if (val == null) {
                        DbCacheSize.usage("No value after -data");
                    }
                    try {
                        dataSize = Integer.parseInt(val);
                    }
                    catch (NumberFormatException e) {
                        DbCacheSize.usage(val + " is not a number");
                    }
                    if (dataSize >= 0) continue;
                    DbCacheSize.usage(val + " is not a non-negative integer");
                    continue;
                }
                if (name.equals("-nodemax")) {
                    if (val == null) {
                        DbCacheSize.usage("No value after -nodemax");
                    }
                    try {
                        nodeMax = Integer.parseInt(val);
                    }
                    catch (NumberFormatException e) {
                        DbCacheSize.usage(val + " is not a number");
                    }
                    if (nodeMax > 0) continue;
                    DbCacheSize.usage(val + " is not a positive integer");
                    continue;
                }
                if (name.equals("-binmax")) {
                    if (val == null) {
                        DbCacheSize.usage("No value after -binmax");
                    }
                    try {
                        binMax = Integer.parseInt(val);
                    }
                    catch (NumberFormatException e) {
                        DbCacheSize.usage(val + " is not a number");
                    }
                    if (binMax > 0) continue;
                    DbCacheSize.usage(val + " is not a positive integer");
                    continue;
                }
                if (name.equals("-density")) {
                    if (val == null) {
                        DbCacheSize.usage("No value after -density");
                    }
                    try {
                        density = Integer.parseInt(val);
                    }
                    catch (NumberFormatException e) {
                        DbCacheSize.usage(val + " is not a number");
                    }
                    if (density >= 1 && density <= 100) continue;
                    DbCacheSize.usage(val + " is not betwen 1 and 100");
                    continue;
                }
                if (name.equals("-overhead")) {
                    if (val == null) {
                        DbCacheSize.usage("No value after -overhead");
                    }
                    try {
                        overhead = Long.parseLong(val);
                    }
                    catch (NumberFormatException e) {
                        DbCacheSize.usage(val + " is not a number");
                    }
                    if (overhead >= 0L) continue;
                    DbCacheSize.usage(val + " is not a non-negative integer");
                    continue;
                }
                if (name.equals("-measure")) {
                    if (val == null) {
                        DbCacheSize.usage("No value after -measure");
                    }
                    measureDir = new File(val);
                    continue;
                }
                if (name.equals("-measurerandom")) {
                    measureRandom = true;
                    continue;
                }
                DbCacheSize.usage("Unknown arg: " + name);
            }
            if (records == 0L) {
                DbCacheSize.usage("-records not specified");
            }
            if (keySize == 0) {
                DbCacheSize.usage("-key not specified");
            }
            DbCacheSize dbCacheSize = new DbCacheSize(records, keySize, dataSize, nodeMax, density, overhead);
            dbCacheSize.setBinMax(binMax > 0 ? binMax : nodeMax);
            dbCacheSize.caclulateCacheSizes();
            dbCacheSize.printCacheSizes(System.out);
            if (measureDir != null) {
                dbCacheSize.measure(System.out, measureDir, measureRandom);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.out);
        }
    }

    private static void usage(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        System.out.println("usage:\njava " + CmdUtil.getJavaCommand(DbCacheSize.class) + "\n   -records <count>" + "\n      # Total records (key/data pairs); required" + "\n   -key <bytes> " + "\n      # Average key bytes per record; required" + "\n  [-data <bytes>]" + "\n      # Average data bytes per record; if omitted no leaf" + "\n      # node sizes are included in the output" + "\n  [-nodemax <entries>]" + "\n      # Number of entries per Btree node; default: 128" + "\n  [-density <percentage>]" + "\n      # Percentage of node entries occupied; default: 80" + "\n  [-overhead <bytes>]" + "\n      # Overhead of non-Btree objects (log buffers, locks," + "\n      # etc); default: 10% of total cache size" + "\n  [-measure <environmentHomeDirectory>]" + "\n      # An empty directory used to write a database to find" + "\n      # the actual cache size; default: do not measure;" + "\n      # without -data, measures internal nodes only" + "\n  [-measurerandom" + "\n      # With -measure insert randomly generated keys;" + "\n      # default: insert sequential keys");
        System.exit(2);
    }

    private void caclulateCacheSizes() {
        long nBinNodes;
        double nodeAvg = (double)(this.nodeMax * this.density) / 100.0;
        double binAvg = (double)(this.binMax * this.density) / 100.0;
        this.numLevel[0] = nBinNodes = (long)((double)this.records / binAvg);
        this.minLevel[0] = nBinNodes * (long)this.calcInSize(this.binMax, binAvg, this.keySize, true);
        this.maxLevel[0] = nBinNodes * (long)this.calcInSize(this.binMax, binAvg, this.keySize, false);
        this.nLevels = 1;
        long nodes = (long)((double)nBinNodes / nodeAvg);
        while (true) {
            if (this.nLevels >= 9) {
                throw new IllegalArgumentException("Maximum levels (9) exceeded.");
            }
            if (nodes == 0L) {
                nodes = 1L;
            }
            this.numLevel[this.nLevels] = nodes;
            this.minLevel[this.nLevels] = nodes * (long)this.calcInSize(this.nodeMax, nodeAvg, this.keySize, true);
            this.maxLevel[this.nLevels] = nodes * (long)this.calcInSize(this.nodeMax, nodeAvg, this.keySize, false);
            ++this.nLevels;
            if (nodes == 1L) break;
            nodes = (long)((double)nodes / nodeAvg);
        }
        for (int level = 0; level < this.nLevels; ++level) {
            this.totalNum += this.numLevel[level];
            this.minInBtreeSize += this.minLevel[level];
            this.maxInBtreeSize += this.maxLevel[level];
        }
        this.minInCacheSize = this.calculateOverhead(this.minInBtreeSize, this.overhead);
        this.maxInCacheSize = this.calculateOverhead(this.maxInBtreeSize, this.overhead);
        long lnSize = 0L;
        if (this.dataSize >= 0) {
            lnSize = this.records * (long)this.calcLnSize(this.dataSize);
        }
        this.maxInBtreeSizeWithData = this.maxInBtreeSize + lnSize;
        this.maxInCacheSizeWithData = this.calculateOverhead(this.maxInBtreeSizeWithData, this.overhead);
        this.minInBtreeSizeWithData = this.minInBtreeSize + lnSize;
        this.minInCacheSizeWithData = this.calculateOverhead(this.minInBtreeSizeWithData, this.overhead);
    }

    private void printCacheSizes(PrintStream out) {
        out.println("Inputs: records=" + this.records + " keySize=" + this.keySize + " dataSize=" + this.dataSize + " nodeMax=" + this.nodeMax + " binMax=" + this.binMax + " density=" + this.density + '%' + " overhead=" + (this.overhead > 0L ? this.overhead : 10L) + "%");
        out.println();
        out.println("=== Cache Sizing Summary ===");
        out.println();
        out.println(MAIN_HEADER);
        out.println(this.line(this.minInBtreeSize, this.minInCacheSize, "Minimum, internal nodes only"));
        out.println(this.line(this.maxInBtreeSize, this.maxInCacheSize, "Maximum, internal nodes only"));
        if (this.dataSize >= 0) {
            out.println(this.line(this.minInBtreeSizeWithData, this.minInCacheSizeWithData, "Minimum, internal nodes and leaf nodes"));
            out.println(this.line(this.maxInBtreeSizeWithData, this.maxInCacheSizeWithData, "Maximum, internal nodes and leaf nodes"));
        } else {
            out.println("\nTo get leaf node sizing specify -data");
        }
        out.println();
        out.println("=== Memory Usage by Btree Level ===");
        out.println();
        out.println(LEVELS_HEADER);
        for (int level = 0; level < this.nLevels; ++level) {
            StringBuffer buf = new StringBuffer();
            buf.append(INT_FORMAT.format(this.numLevel[level]));
            buf.append("    ");
            buf.append(level + 1);
            String lastCol = buf.toString();
            out.println(this.line(this.maxLevel[level], this.minLevel[level], lastCol));
        }
    }

    private int calcInSize(int nodeMax, double nodeAvg, int keySize, boolean lsnCompression) {
        int size = MemoryBudget.IN_FIXED_OVERHEAD;
        size += MemoryBudget.byteArraySize(nodeMax) + nodeMax * (2 * MemoryBudget.OBJECT_ARRAY_ITEM_OVERHEAD);
        size = lsnCompression ? (size += MemoryBudget.byteArraySize(nodeMax * 2)) : (size += MemoryBudget.ARRAY_OVERHEAD + nodeMax * 8);
        return size += (int)(nodeAvg * (double)MemoryBudget.byteArraySize(keySize));
    }

    private int calcLnSize(int dataSize) {
        return MemoryBudget.LN_OVERHEAD + MemoryBudget.byteArraySize(dataSize);
    }

    private long calculateOverhead(long btreeSize, long overhead) {
        long cacheSize = overhead == 0L ? 100L * btreeSize / 90L : btreeSize + overhead;
        return cacheSize;
    }

    private String line(long btreeSize, long cacheSize, String comment) {
        StringBuffer buf = new StringBuffer(100);
        this.column(buf, INT_FORMAT.format(cacheSize));
        buf.append(COLUMN_SEPARATOR);
        this.column(buf, INT_FORMAT.format(btreeSize));
        buf.append(COLUMN_SEPARATOR);
        this.column(buf, comment);
        return buf.toString();
    }

    private void column(StringBuffer buf, String str) {
        int start = buf.length();
        while (buf.length() - start + str.length() < 15) {
            buf.append(' ');
        }
        buf.append(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void measure(PrintStream out, File dir, boolean randomKeys) throws Exception {
        String[] fileNames = dir.list();
        if (fileNames != null && fileNames.length > 0) {
            DbCacheSize.usage("Directory is not empty: " + dir);
        }
        Environment env = DbCacheSize.openEnvironment(dir, true);
        Database db = DbCacheSize.openDatabase(env, this.nodeMax, true);
        try {
            out.println("\nMeasuring with cache size: " + INT_FORMAT.format(env.getConfig().getCacheSize()));
            this.insertRecords(out, env, db, randomKeys);
            DbCacheSize.printStats(out, env, "Stats after insert");
            db.close();
            db = null;
            env.close();
            env = null;
            env = DbCacheSize.openEnvironment(dir, false);
            db = DbCacheSize.openDatabase(env, this.nodeMax, false);
            out.println("\nPreloading with cache size: " + INT_FORMAT.format(env.getConfig().getCacheSize()));
            PreloadStatus status = DbCacheSize.preloadRecords(out, db, false);
            DbCacheSize.printStats(out, env, "Stats for internal nodes only after preload (" + status + ")");
            if (this.dataSize >= 0) {
                status = DbCacheSize.preloadRecords(out, db, true);
                DbCacheSize.printStats(out, env, "Stats for all nodes after preload (" + status + ")");
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                if (db != null) {
                    db.close();
                }
                if (env != null) {
                    env.close();
                }
            }
            catch (Exception e) {
                out.println("During close: " + e);
            }
            throw throwable;
        }
        try {
            if (db != null) {
                db.close();
            }
            if (env != null) {
                env.close();
            }
        }
        catch (Exception e) {
            out.println("During close: " + e);
        }
    }

    private static Environment openEnvironment(File dir, boolean allowCreate) throws Exception {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(allowCreate);
        envConfig.setCachePercent(90);
        envConfig.setConfigParam("je.env.runCleaner", "false");
        envConfig.setConfigParam("je.env.runCheckpointer", "false");
        return new Environment(dir, envConfig);
    }

    private static Database openDatabase(Environment env, int nodeMax, boolean allowCreate) throws Exception {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(allowCreate);
        dbConfig.setNodeMaxEntries(nodeMax);
        return env.openDatabase(null, "foo", dbConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insertRecords(PrintStream out, Environment env, Database db, boolean randomKeys) throws Exception {
        Cursor cursor;
        block17: {
            block16: {
                block15: {
                    block14: {
                        DatabaseEntry key = new DatabaseEntry();
                        DatabaseEntry data = new DatabaseEntry(new byte[Math.max(0, this.dataSize)]);
                        BigInteger bigInt = BigInteger.ZERO;
                        Random rnd = new Random(123L);
                        cursor = db.openCursor(null, null);
                        try {
                            int i = 0;
                            while ((long)i < this.records) {
                                byte[] a;
                                if (randomKeys) {
                                    a = new byte[this.keySize];
                                    rnd.nextBytes(a);
                                    key.setData(a);
                                } else {
                                    a = (bigInt = bigInt.add(BigInteger.ONE)).toByteArray();
                                    if (a.length < this.keySize) {
                                        byte[] a2 = new byte[this.keySize];
                                        System.arraycopy(a, 0, a2, a2.length - a.length, a.length);
                                        a = a2;
                                    } else if (a.length > this.keySize) {
                                        out.println("*** Key doesn't fit value=" + bigInt + " byte length=" + a.length);
                                        Object var14_13 = null;
                                        break block14;
                                    }
                                    key.setData(a);
                                }
                                OperationStatus status = cursor.putNoOverwrite(key, data);
                                if (status == OperationStatus.KEYEXIST && randomKeys) {
                                    --i;
                                    out.println("Random key already exists -- retrying");
                                } else {
                                    if (status != OperationStatus.SUCCESS) {
                                        out.println("*** " + (Object)((Object)status));
                                        break block15;
                                    }
                                    if (this.dataSize < 0) {
                                        DbInternal.getCursorImpl(cursor).evict();
                                    }
                                    if (i % 10000 == 0) {
                                        EnvironmentStats stats = env.getStats(null);
                                        if (stats.getNNodesScanned() > 0L) {
                                            out.println("*** Ran out of cache memory at record " + i + " -- try increasing Java heap size ***");
                                            break block16;
                                        }
                                        out.print(".");
                                        out.flush();
                                    }
                                }
                                ++i;
                            }
                            break block17;
                        }
                        catch (Throwable throwable) {
                            Object var14_17 = null;
                            cursor.close();
                            throw throwable;
                        }
                    }
                    cursor.close();
                    return;
                }
                Object var14_14 = null;
                cursor.close();
                return;
            }
            Object var14_15 = null;
            cursor.close();
            return;
        }
        Object var14_16 = null;
        cursor.close();
        env.checkpoint(new CheckpointConfig().setForce(true));
    }

    private static PreloadStatus preloadRecords(final PrintStream out, Database db, boolean loadLNs) throws Exception {
        Thread thread = new Thread(){

            public void run() {
                try {
                    while (true) {
                        out.print(".");
                        out.flush();
                        Thread.sleep(5000L);
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        };
        thread.start();
        PreloadStats stats = db.preload(new PreloadConfig().setLoadLNs(loadLNs));
        thread.interrupt();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace(out);
        }
        db.getEnvironment().checkpoint(new CheckpointConfig().setForce(true));
        return stats.getStatus();
    }

    private static void printStats(PrintStream out, Environment env, String msg) throws Exception {
        out.println();
        out.println(msg + ':');
        EnvironmentStats stats = env.getStats(null);
        long btreeSize = DbInternal.getEnvironmentImpl(env).getMemoryBudget().getTreeMemoryUsage();
        out.println("CacheSize=" + INT_FORMAT.format(stats.getCacheTotalBytes()) + " BtreeSize=" + INT_FORMAT.format(btreeSize) + " NCacheMiss=" + INT_FORMAT.format(stats.getNCacheMiss()));
        if (stats.getNNodesScanned() > 0L) {
            out.println("*** All records did not fit in the cache ***");
        }
    }
}

