/**********************************************************************
 *
 * dbclass.h -- 
 * Copyright (C) 1999-2008  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef DBCLASS_H
#define DBCLASS_H


#include "text_t.h"
#include "infodbclass.h"

#if defined(GSDL_USE_OBJECTSPACE)
#  include <ospace\std\iostream>
#  include <ospace\std\fstream>
#elif defined(GSDL_USE_IOS_H)
#  include <iostream.h>
#  include <fstream.h>
#else
#  include <iostream>
#  include <fstream>
#endif


#define DB_READER         1
#define DB_WRITER         2
#define DB_WRITER_CREATE  3


class dbclass
{
public:
  dbclass(const text_t& gsdlhome) { logout = &cerr; }
  virtual ~dbclass();

  void setlogout (ostream *logout_arg) { logout = logout_arg; }


  // -----------------------------------------------------------------------------------------------
  // These functions MUST be implemented by subclasses, as they are database-specific

  // returns true if opened
  virtual bool opendatabase (const text_t &filename, int mode, int num_retrys, bool need_filelock) = 0;

  virtual void closedatabase () = 0;

  virtual void deletekey (const text_t &key) = 0;

  // returns file extension string
  virtual text_t getfileextension () = 0;

  // returns true on success
  virtual bool getkeydata (const text_t& key, text_t &data) = 0;

  // returns array of keys
  virtual text_tarray getkeys () = 0;

  // returns true on success
  virtual bool setkeydata (const text_t &key, const text_t &data) = 0;


  // -----------------------------------------------------------------------------------------------
  // These functions may be overwritten by subclasses, but a default implementation is provided

  // returns true if exists
  virtual bool exists (const text_t& key);

  // returns true on success
  virtual bool getinfo (const text_t& key, infodbclass &info);

  // returns true on success
  virtual bool setinfo (const text_t &key, const infodbclass &info);


  // replaces the .c, .p, .n, .l syntax (child, parent, next, previous) 
  // it expects child, parent, etc. to exist if syntax has been used
  // so you should test before using
  text_t translate_OID(const text_t &OID, infodbclass &info);

protected:
  ostream *logout;

  // returns true on success
  bool getinfoline (text_t::iterator &here, text_t::iterator end, text_t &key, text_t &value);

  void get_first_child (text_t &OID, infodbclass &info);
  void get_last_child (text_t &OID, infodbclass &info);
  void get_next_sibling (text_t &OID, infodbclass &info);
  void get_previous_sibling (text_t &OID, infodbclass &info);
};


#endif
