###########################################################################
#
# win32 makefile -- gdbm
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 1999  The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

DEBUG = 0

AR = lib
CC = cl


!IF $(DEBUG)
CXXFLAGS = -DEBUG -Z7 /errorReport:prompt
LDFLAGS = -DEBUG -Z7 /errorReport:prompt
!ELSE
CXXFLAGS =
LDFLAGS =
!ENDIF

DEFS = -D__WIN32__ -D_CRT_SECURE_NO_DEPRECATE
INCLUDES = -I"windows"

COMPILE = $(CC) -nologo -c $(CXXFLAGS) $(DEFS) $(INCLUDES)

o = .obj

.SUFFIXES:
.SUFFIXES: .c $o

.c$o:
	$(COMPILE) $<

HEADERS = gdbmdefs.h extern.h gdbmerrno.h systems.h gdbmconst.h \
          proto.h

SOURCES = gdbmopen.c gdbmdelete.c gdbmfetch.c  gdbmstore.c gdbmclose.c \
	  gdbmreorg.c gdbmseq.c gdbmsync.c gdbmerrno.c gdbmexists.c gdbmsetopt.c \
	  bucket.c falloc.c findkey.c global.c hash.c update.c \
	  version.c gsdlmods.c

OBJECTS = gdbmopen$o gdbmdelete$o gdbmfetch$o  gdbmstore$o gdbmclose$o \
	  gdbmreorg$o gdbmseq$o gdbmsync$o gdbmerrno$o gdbmexists$o gdbmsetopt$o \
	  bucket$o falloc$o findkey$o global$o hash$o update$o \
	  version$o gsdlmods$o

all: gdbm.lib

gdbm.lib: $(OBJECTS)
	  if EXIST gdbm.lib del gdbm.lib
	  $(AR) -nologo /out:gdbm.lib $(OBJECTS) 

install:

clean:
	del gdbm.lib
	del *$o