package org.greenstone.mgpp;

import java.util.Vector;

/** TermInfo 'struct' class for a search result from mgpp
 * used by MGPPQueryResult
 * 
 *
 *@see MGPPQueryResult
 */
public class MGPPTermInfo {

    /** the term itself */
    public String term_=null;
    /** the tag - level or metadata - for which the query was done */
    public String tag_=null;
    /** what stem and casefold method was used
	0 = none
	1 = casefold only
	2 = stem only
	3 = casefold and stem */
    public int stem_method_=0;
    /** the number of documents containing this term (where document is defined by the tag data */
    public long match_docs_=0;
    /** overall term freq  - word level*/
    public long term_freq_=0;
    /** list of stemmed and casefolded equivalent terms - if stem_method_ is non-zero 
      - Vector of Strings */
    public Vector equiv_terms_=null;

    public MGPPTermInfo() {
	equiv_terms_ = new Vector();
    }
	
    /** output the class as a string */
    public String toString() {
	String result="";
	result +="<"+tag_+">\""+term_+"\"stem("+stem_method_+")docs("+match_docs_;
	result +=")freq("+term_freq_+")equiv terms(";
	for (int i=0; i<equiv_terms_.size(); i++) {
	    result += (String)equiv_terms_.elementAt(i)+", ";
	}
	result += ")";
	return result;
    }
}
