/*
 *    MGPPRetrieveWrapper.java
 *    Copyright (C) 2007 New Zealand Digital Library, http://www.nzdl.org
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package org.greenstone.mgpp;



/** java wrapper class for access to mgpp document retrieval mgpp in C++
 *
 * the native side is implemented in MGPPSearchWrapperImpl.cpp
 * the result of getDocument is a String
 * uses jni
 *
 */
public class MGPPRetrieveWrapper {
  
    static {
	String gsdlos = System.getenv("GSDLOS");
	if (gsdlos!=null && gsdlos.equals("darwin")) {
	    // As of MacOX 10.11 (El Capitan), effectivly supresses DYLD_LIBRARY_PATH (does
	    // not propagate it to child processes).  This is a result of changes to their
	    // security model, and seems to come into effect for 'untrusted' executables.
	    // Greenstone run as a regular user, is 'unstrusted'.  It is possible, with
	    // admin rights, to override this, however that is not really a viable solution
	    // for our project.  Hence the change here to use Systen.load() with an
	    // absolute pathname, rather than rely of System.loadLibrary().

	    String gsdl3srchome = System.getenv("GSDL3SRCHOME");
	    String full_jni_library = gsdl3srchome + "/lib/jni/libmgppretrievejni.jnilib";
	    System.load(full_jni_library);
	}
	else {
	    System.loadLibrary("mgppretrievejni");
	}
    }
    
    public MGPPRetrieveWrapper() {
    }

    /** returns a document: number docnum at level level 
     * text_path path should provide
     * the absolute location of the mgpp text files eg ..../index/text/demo
     * returns the doc in utf-8
     */
    public native String getDocument(String text_path,
				     String level,
				     long docnum );

}
