#include "stdafx.h"
#include "Debug.h"

//---------------------------------------------------------------
//
// AssertFailed
//
//---------------------------------------------------------------
#if DEBUG || ASSERTS_THROW
void AssertFailed(const char* expr, const char* file, int line)
{
	/*
	_TCHAR mesg[512];							

	const char* fileName = file + strlen(file);		// strip off path
	while (fileName > file && fileName[-1] != '\\')
		--fileName;

	_stprintf(mesg, _T("ASSERT(%s) in '%s' at line %d failed."), expr, fileName, line);
	
	MSG msg;							// remove pending quit messages so the message box displays
	bool quitting = (bool) ::PeekMessage(&msg, NULL, WM_QUIT, WM_QUIT, PM_REMOVE);

	UINT32 flags = MB_OK +				// just an OK button
				   MB_ICONERROR +		// display the icon for errors
				   MB_DEFBUTTON1 +		// select the OK button
				   MB_TASKMODAL +		// don't let the user do anything else in the app
				   MB_SETFOREGROUND;	// bring the app to the front

	(void) MessageBox(NULL, mesg, NULL, flags);
//#if DEBUG
//	if (gBreakOnAssert)
//		BreakStrToDebugger(mesg);
//#endif

//#if ASSERTS_THROW
	CString text = L"Internal (Assert) Error: ";
	AfxThrowUserException( ); 
//#endif
*/
}
#endif	// DEBUG || ASSERTS_THROW


//---------------------------------------------------------------
//
// RequireFailed
//
//---------------------------------------------------------------
#if !DEBUG
void RequireFailed(const char* expr, const char* file, int line)
{
	/*
	char mesg[512];							

	const char* fileName = file + strlen(file);		// strip off path
	while (fileName > file && fileName[-1] != '\\')
		--fileName;

	sprintf(mesg, "There has been a fatal error in '%s' at line %d.", fileName, line);

	MSG msg;							// remove pending quit messages so the message box displays
	bool quitting = (bool) ::PeekMessage(&msg, NULL, WM_QUIT, WM_QUIT, PM_REMOVE);

	UINT32 flags = MB_OK +				// just an OK button
				   MB_ICONERROR +		// display the icon for errors
				   MB_DEFBUTTON1 +		// select the OK button
				   MB_TASKMODAL +		// don't let the user do anything else in the app
				   MB_SETFOREGROUND;	// bring the app to the front

	(void) MessageBox(NULL, mesg, NULL, flags);

	abort();
	*/
}
#endif // !DEBUG

//---------------------------------------------------------------
//
// ToStr (bool)
//
//---------------------------------------------------------------
std::wstring ToStr(bool value)
{
	return value ? L"true" : L"false";
}


//---------------------------------------------------------------
//
// ToStr (char)
//
//---------------------------------------------------------------
std::wstring ToStr(char value)
{
	wchar_t str[32];							
	::swprintf(str, L"%c", value);
	
	return str;
}


//---------------------------------------------------------------
//
// ToStr (int16, int32)
//
//---------------------------------------------------------------
std::wstring ToStr(int16_t value, int32_t fieldWidth)
{
	wchar_t str[32];							
	::swprintf(str, L"%*d", fieldWidth, value);
	
	return str;
}


//---------------------------------------------------------------
//
// ToStr (uint16, int32)
//
//---------------------------------------------------------------
std::wstring ToStr(uint16_t value, int32_t fieldWidth)
{
	wchar_t str[32];							
	::swprintf(str, L"%*d", fieldWidth, value);
	
	return str;
}


//---------------------------------------------------------------
//
// ToStr (int32, int32)
//
//---------------------------------------------------------------
std::wstring ToStr(int32_t value, int32_t fieldWidth)
{
	wchar_t str[32];							
	::swprintf(str, L"%*ld", fieldWidth, value);
	
	return str;
}


//---------------------------------------------------------------
//
// ToStr (uint32, int32)
//
//---------------------------------------------------------------
std::wstring ToStr(uint32_t value, int32_t fieldWidth)
{
	wchar_t str[32];							
	::swprintf(str, L"%*lu", fieldWidth, value);
	
	return str;
}


//---------------------------------------------------------------
//
// ToStr (float, int32)
//
//---------------------------------------------------------------
std::wstring ToStr(float value, int32_t precision)
{
	wchar_t str[32];							
	::swprintf(str, L"%.*f", precision, value);
	
	return str;
}


//---------------------------------------------------------------
//
// ToStr (double, int32)
//
//---------------------------------------------------------------
std::wstring ToStr(double_t value, int32_t precision)
{
	wchar_t str[32];							
	::swprintf(str, L"%.*f", precision, value);
	
	return str;
}


//---------------------------------------------------------------
//
// ToStr (const char*)
//
//---------------------------------------------------------------
std::wstring ToStr(const char* value)
{
	wchar_t str[2048];							
	::swprintf(str, L"%s", value);
	
	return str;
}


//---------------------------------------------------------------
//
// ToStr (std::string)
//
//---------------------------------------------------------------
std::wstring ToStr(const std::string& value)
{
	wchar_t str[2048];							
	::swprintf(str, L"%s", value.c_str());
	
	return str;
}

