/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * <BR><BR>
 *
 * Author: John Thompson, Greenstone Digital Library, University of Waikato
 *
 * <BR><BR>
 *
 * Copyright (C) 1999 New Zealand Digital Library Project
 *
 * <BR><BR>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * <BR><BR>
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * <BR><BR>
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.shell;

import org.greenstone.gatherer.gui.GProgressBar;
import java.util.ArrayList;
import java.awt.Component;

public class GDefaultProgressMonitor implements GShellProgressMonitor{
    private GProgressBar progress_bar = null; 
    private boolean signalledStop = false;    

    public void addProgressBar(GProgressBar progressBar){
	progress_bar =  progressBar; 
     }

    public int exitValue(){
	if (signalledStop){
	    return 0;
	}
	return 1;
      }

    public GProgressBar getSharedProgress(){
         return progress_bar;
     }

    public Component getProgress(){
        return null;
    }

    public void messageOnProgressBar(String message){

    }

    public boolean hasSignalledStop(){
	return signalledStop;
    }
   
    public void increment(){}

    public void process(ArrayList queue){}

    public void reset(){}

    public void saving(){}
   
    public void setStop(boolean state){
        signalledStop = state; 
    }

    public void start(){}

    public void stop(){}

}
