/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * Author: Michael Dewsnip, Greenstone Digital Library, University of Waikato
 *
 * Copyright (C) 2006 New Zealand Digital Library Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.file.WorkspaceTree;


public class CreateShortcutPrompt	
    extends JDialog
    implements ActionListener, KeyListener
{
    /** The default size of a special mapping dialog. */
    static final Dimension DIALOG_SIZE = new Dimension(400, 120);

    private boolean cancelled = false;
    private JButton cancel_button = null;
    private JButton ok_button = null;
    private JTextField name_field = null;


    public CreateShortcutPrompt(WorkspaceTree workspace_tree, File file)
    {
	super(Gatherer.g_man);
        this.setComponentOrientation(Dictionary.getOrientation());
	setModal(true);
	setSize(DIALOG_SIZE);
	setTitle(Dictionary.get("MappingPrompt.Title"));
	
	// Creation
	JPanel content_pane = (JPanel) getContentPane();
        content_pane.setComponentOrientation(Dictionary.getOrientation());
	JPanel center_pane = new JPanel();
        center_pane.setComponentOrientation(Dictionary.getOrientation());
	JPanel labels_pane = new JPanel();
        labels_pane.setComponentOrientation(Dictionary.getOrientation());
	JPanel fields_pane = new JPanel();
        fields_pane.setComponentOrientation(Dictionary.getOrientation());

	JLabel file_label = new JLabel(Dictionary.get("MappingPrompt.File"));
	file_label.setComponentOrientation(Dictionary.getOrientation());
        JLabel file_field = new JLabel(file.getAbsolutePath());
        file_field.setComponentOrientation(Dictionary.getOrientation());
        
	JLabel name_label = new JLabel(Dictionary.get("MappingPrompt.Name"));
	name_label.setComponentOrientation(Dictionary.getOrientation());                
        name_field = new JTextField(file.getName());
        name_field.setComponentOrientation(Dictionary.getOrientation());
        
	JPanel button_pane = new JPanel();
        button_pane.setComponentOrientation(Dictionary.getOrientation());
	ok_button = new GLIButton(Dictionary.get("General.OK"), Dictionary.get("General.OK_Tooltip"));
	ok_button.setEnabled(name_field.getText().length() > 0);
	cancel_button = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("General.Cancel_Tooltip"));
	
	// Connection
	cancel_button.addActionListener(this);
	ok_button.addActionListener(this);
	name_field.addKeyListener(this);

	// Layout
	labels_pane.setLayout(new GridLayout(2,1,5,0));
	labels_pane.add(file_label);
	labels_pane.add(name_label);
    
	fields_pane.setLayout(new GridLayout(2,1,5,0));
	fields_pane.add(file_field);
	fields_pane.add(name_field);

	center_pane.setBorder(BorderFactory.createEmptyBorder(0,0,5,0));
	center_pane.setLayout(new BorderLayout(5,0));
	center_pane.add(labels_pane, BorderLayout.LINE_START);
	center_pane.add(fields_pane, BorderLayout.CENTER);

	button_pane.setLayout(new GridLayout(1,2,5,5));
	button_pane.add(ok_button);
	button_pane.add(cancel_button);

	content_pane.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
	content_pane.setLayout(new BorderLayout());
	content_pane.add(center_pane, BorderLayout.CENTER);
	content_pane.add(button_pane, BorderLayout.SOUTH);

	// Display
	Dimension screen_size = Configuration.screen_size;
	setLocation((screen_size.width - DIALOG_SIZE.width) / 2, (screen_size.height - DIALOG_SIZE.height) / 2);
	setVisible(true);

	// If not cancelled create mapping.
	if (!cancelled) {
	    workspace_tree.addDirectoryMapping(name_field.getText(), file);
	}
    }


    public void actionPerformed(ActionEvent event)
    {
	if (event.getSource() == cancel_button) {
	    cancelled = true;
	}
	dispose();
    }


    public void destroy()
    {
	cancel_button = null;
	ok_button = null;
	name_field = null;
    }


    public void keyPressed(KeyEvent event) { }

    public void keyReleased(KeyEvent event)
    {
	ok_button.setEnabled(name_field.getText().length() > 0);
    }

    public void keyTyped(KeyEvent event) { }
}
