package org.greenstone.gatherer.feedback;

import java.io.*;
import java.util.jar.*;
import java.util.zip.*;

/**
 * This class will help to zip and unzip files.
 * @author Veronica Liesaputra
 */
public class ZipFile 
{
    /**
     * This is the specified buffer size.
     */
    private static final int BUFFER = 2048;
    
    public ZipFile ()
    {}

    /**
     * This method will unzip the MyZipFile.zip file and delete the file.
     */
    public void unZipFile ()
    {
	try
	    {
		BufferedOutputStream dest;
		dest = null;
		FileInputStream fis;
		fis = new FileInputStream("MyZipFile.zip");
		ZipInputStream zis;
		zis = new ZipInputStream(new BufferedInputStream(fis));
		ZipEntry entry;
		while((entry = zis.getNextEntry()) != null) 
		    {
			int count;
			byte data[];
			data = new byte[BUFFER];
			// write the files to the disk
			File f;
			f = new File(entry.getName());
			if (isRightLogExtension(f) == true)
			    {
				FileOutputStream fos;
				fos = new FileOutputStream(entry.getName());
				dest = new BufferedOutputStream(fos, BUFFER);
				while ((count = zis.read(data, 0, BUFFER)) != -1) 
				    {
					dest.write(data, 0, count);
				    }
				dest.flush();
				dest.close();
			    }
		    }
		zis.close();
		File f3;
		f3 = new File("MyZipFile.zip");
		f3.delete();
	    } 
	catch (FileNotFoundException fexp) {}
	catch(Exception e) 
	    {
		e.printStackTrace();
	    }
    } 

    /**
     * This method will zip all the xml files into one Jar file.
     */
    public void sendZipXMLFile ()
     {
	try 
	    {
		String dirname;
		dirname = "xmlfeedback/";
		BufferedInputStream origin;
		origin = null;
		FileOutputStream dest;
		dest = new FileOutputStream(dirname + "Jar" + 
					    FeedbackInterface.getCode() + 
					    "File.jar");
		JarOutputStream out;
		out = new JarOutputStream(new BufferedOutputStream(dest));
		out.setMethod(ZipOutputStream.DEFLATED);
		byte data[];
		data = new byte[BUFFER];
		
		File f;
		f = new File(dirname + ".");
		File[] fileList;
		fileList = f.listFiles();
		File[] files;
		files = new File[fileList.length + 8];
		
		int index,j,i;
		index = 0;
		for (j = 0 ; j < fileList.length ; j++)
		    {
			String name;
			name = fileList[j].getName();
			
			if (isRightXMLExtension(fileList[j]) == true)
			    {
				files[index] = fileList[j];
				index++;
			    }
		    }
		
		for ( i = 0; i < index; i++) 
		    {
			FileInputStream fi;
			fi = new FileInputStream(files[i]);
			origin = new BufferedInputStream(fi, BUFFER);
			ZipEntry entry;
			entry = new ZipEntry(files[i].getName());
			out.putNextEntry(entry);
			int count;
			while((count = origin.read(data, 0,BUFFER)) != -1) 
			    {
				out.write(data, 0, count);
			    }
			origin.close();
		    }	

		out.close();
	    } 
	catch(Exception e) 
	    {
		e.printStackTrace();
	    }
    }

    /**
     * This method will zip all .log file to MyZipFile.zip file and it will
     * delete the history.log file.
     */
    public void sendZipFile ()
    {
	try 
	    {
		BufferedInputStream origin;
		origin = null;
		FileOutputStream dest;
		dest = new FileOutputStream("MyZipFile.zip");
		ZipOutputStream out;
		out = new ZipOutputStream(new BufferedOutputStream(dest));
		out.setMethod(ZipOutputStream.DEFLATED);
		byte data[];
		data = new byte[BUFFER];
		
		File f;
		f = new File(".");
		File[] fileList;
		fileList = f.listFiles();
		File[] files;
		files = new File[fileList.length];
		
		int index,i,j;
		index = 0;
		for ( j = 0 ; j < fileList.length ; j++)
		    {
			if (isRightLogExtension(fileList[j]) == true)
			    {
				files[index] = fileList[j];
				index++;
			    }
		    }
		
		for (i = 0; i < index; i++) 
		    {
			FileInputStream fi;
			fi = new FileInputStream(files[i]);
			origin = new BufferedInputStream(fi, BUFFER);
			ZipEntry entry;
			entry = new ZipEntry(files[i].getName());
			out.putNextEntry(entry);
			int count;
			while((count = origin.read(data, 0,BUFFER)) != -1) 
			    {
				out.write(data, 0, count);
			    }
			origin.close();
		    }
		out.close();
		File f2;
		f2 = new File("history.log");
		f2.delete();
	    } 
	catch(Exception e) 
	    {
		e.printStackTrace();
	    }
    }
    
    /**
     * This method will get the extension of the given file.
     * @param f the file we want to know the extension.
     * @return  the file extension.
     */
    public String getExtension(File f)
    {
        String ext;
	ext = null;
        String s;
	s = f.getName();
        int i;
	i = s.lastIndexOf('.');
	
        if (i > 0 &&  i < s.length() - 1)
	    {
		ext = s.substring(i+1).toLowerCase();
	    }
        return ext;
    }
   
    /**
     * This method will check whether or not the give file has
     * an .xml extension.
     * @param f the file we want to check the extension.
     * @return  whether or not the file has xml as its file extension.
     */
    public boolean isRightXMLExtension(File f)
    {
	if (f.isDirectory() == true)
	    {
		return false;
	    }
	String ext;
	ext = getExtension(f);
	if ((ext != null) && (ext.compareTo("xml") == 0))
	    return true;
	else
	    return false;
    }

    /**
     * This method will check whether or not the give file has
     * an .log extension.
     * @param f the file we want to check the extension.
     * @return  whether or not the file has log as its file extension.
     */
    public boolean isRightLogExtension(File f)
    {
	if (f.isDirectory() == true)
	    return false;
	
	String ext;
	ext = getExtension(f);
	
	if ((ext != null) && (ext.compareTo("log") == 0))
	    return true;
	else
	    return false;
    }
}










