package org.greenstone.gatherer.feedback;

import java.awt.image.*;
import java.io.*;// SAX classes.
import javax.imageio.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;//JAXP 1.1
import javax.xml.parsers.*;
import javax.xml.transform.*;
import javax.xml.transform.stream.*;
import javax.xml.transform.sax.*; 
import java.util.Locale;
import java.util.ResourceBundle;
import java.text.MessageFormat;
import java.util.*;

/**
 * This class will make xml files from the information given.
 * @author Veronica Liesaputra
 */
public class SaveToXML
{
    /**
     * This is the file where the xml file will be saved.
     */
    private FileOutputStream fos;
    /**
     * This is the transformer handler for the xml file.
     */
    private TransformerHandler hd;
    /**
     * This is the attribute implementation for the xml file.
     */
    private AttributesImpl atts;
     /**
     * This variable will hold the resource of the words that is stored in Messages.properties file.
     * The calling using messages.getString(someString) will caused someString to be translated
     * into some other string that is hold in that file.usually it will caused it to be translated
     * to the language that the user use or choose to have as stated in Locale.
     */
    private static ResourceBundle messages;

    /**
     * This constructor will setup what languange should be use.
     * @param msg will hold the resource of the words that is stored in Messages.properties file.
     */
    public SaveToXML(ResourceBundle msg)
    {
	messages = msg;
    }

    /**
     * This will save the image, image filename,width and height to the xml file.
     * @param image    image
     * @param filename image's filename
     * @param width    image's width
     * @param height   image's height
     */
    public void saveImage (String image,String filename,String width,String height)
    {
	try
	    {
		hd.startElement("","","Title",atts);
		hd.characters(filename.toCharArray(),0,filename.length());
		hd.endElement("","","Title");
		hd.startElement("","","Size",atts);
		hd.startElement("","","Width",atts);
		hd.characters(width.toCharArray(),0,width.length());
		hd.endElement("","","Width");
		hd.startElement("","","Height",atts);
		hd.characters(height.toCharArray(),0,height.length());
		hd.endElement("","","Height");
		hd.endElement("","","Size");
		hd.startElement("","","View",atts);
		hd.characters(image.toCharArray(),0,image.length());
		hd.endElement("","","View");
	    }
	catch(SAXException sax) {}
    }

    /**
     * This method will create and setup the xml file.
     * @param xmlname this is the file name for the xml file.
     * @param type    this is the first tag that open the xml file.
     */
    public void open (String xmlname,String type)
    {
	try
	    {
		File f;
		f = new File(xmlname);
		fos = new FileOutputStream(f);
		PrintWriter out;
		out = new PrintWriter(fos);
		StreamResult streamResult;
		streamResult = new StreamResult(out);
		SAXTransformerFactory tf;
		tf = (SAXTransformerFactory) SAXTransformerFactory.newInstance();
		hd = tf.newTransformerHandler();
		Transformer serializer;
		serializer = hd.getTransformer();
		
		serializer.setOutputProperty(OutputKeys.ENCODING,"UTF-8");
		//serializer.setOutputProperty(OutputKeys.DOCTYPE_SYSTEM,dtdname);
		serializer.setOutputProperty(OutputKeys.INDENT,"yes");
			
		hd.setResult(streamResult);
		atts = new AttributesImpl();
		
		hd.startDocument();
		
		hd.startElement("","",type,atts);   
	    }
	catch (IOException e){
	    System.err.println ("Unable to write to file");
	    System.exit(-1);
	}catch (TransformerConfigurationException tce){
	    System.err.println("Error in: TransformerConfigurationException");
	}catch (SAXException spe) {
	    // Error generated by the parser
	    System.err.println("Error in: (SAXException");
	    // Use the contained exception, if any
	    Exception  x = spe;
	    if (spe.getException() != null)
		x = spe.getException();
	    x.printStackTrace();
	}
    }

    /**
     * This method will setup to close the xml file.
     * @param type    this is the last tag that close the xml file.
     */
    public void close(String type)
    {
	try
	    {
		hd.endElement("","",type);
		hd.endDocument();
		fos.close(); 
	    }
	catch (IOException e){
	    System.err.println ("Unable to write to file");
	    System.exit(-1);
	}catch (SAXException spe) {
	    // Error generated by the parser
	    System.err.println("Error in: (SAXException");
	    // Use the contained exception, if any
	    Exception  x = spe;
	    if (spe.getException() != null)
		x = spe.getException();
	    x.printStackTrace();
	}
    }

    /**
     * This method will add the open tag according to the number.
     * @param num the number to say which type of tag it is.
     */
    public void startContent (int num)
    {
	try
	    {
		switch(num)
		    {
		    case 0: hd.startElement("","","COMPONENT",atts);
			break;
		    case 1: hd.startElement("","","Type",atts);
			break;
		    case 2: hd.startElement("","","Title",atts);
			break;
		    case 3: hd.startElement("","","Content",atts);
			break;
		    case 4: hd.startElement("","","Selected",atts);
			break;
		    case 5: hd.startElement("","","Visible",atts);  
			break;
		    case 6: hd.startElement("","","Image",atts);
			break;
		    case 7: hd.startElement("","","Date",atts);
			break;
		    case 8: hd.startElement("","","Command",atts);
			break;
		    case 9: hd.startElement("","","COMPONENTS",atts);
			break;
		    case 10:hd.startElement("","","LOG",atts);
			break;
		    case 11:hd.startElement("","","Icon",atts);
			break;
		    case 12:hd.startElement("","","ToolTipText",atts);
			break;
		    case 13:hd.startElement("","","Comment",atts);
			break;
		    }
	    }
	catch (SAXException spe) {
	    // Error generated by the parser
	    System.err.println("Error in: (SAXException");
	    // Use the contained exception, if any
	    Exception  x;
	    x = spe;
	    if (spe.getException() != null)
		x = spe.getException();
	    x.printStackTrace();
	}
    }

    /**
     * This method will add the text to the tag.
     * @param text is the text to be saved in xml files.
     */
    public void saveContent (String text)
    {
	try
	    {
		if (text == null)
		    text = "\t";
		hd.characters(text.toCharArray(),0,text.length());
	    }
	catch (SAXException spe) {
	    // Error generated by the parser
	    System.err.println("Error in: (SAXException");
	    // Use the contained exception, if any
	    Exception  x;
	    x = spe;
	    if (spe.getException() != null)
		x = spe.getException();
	    x.printStackTrace();
	}
    }

    /**
     * This method will add the close tag according to the number.
     * @param num the number to say which type of tag it is.
     */
    public void closeContent (int num)
    {
	try
	    {
		switch(num)
		    {
		    case 0: hd.endElement("","","COMPONENT");
			break;
		    case 1: hd.endElement("","","Type");
			break;
		    case 2: hd.endElement("","","Title");
			break;
		    case 3: hd.endElement("","","Content");
			break;
		    case 4: hd.endElement("","","Selected");
			break;
		    case 5: hd.endElement("","","Visible");
			break;
		    case 6: hd.endElement("","","Image");
			break;
		    case 7: hd.endElement("","","Date");
			break;
		    case 8: hd.endElement("","","Command");
			break;
		    case 9: hd.endElement("","","COMPONENTS");
			break;
		    case 10:hd.endElement("","","LOG");
			break;
		    case 11:hd.endElement("","","Icon");
			break;
		    case 12:hd.endElement("","","ToolTipText");
			break;
		    case 13:hd.endElement("","","Comment");
			break;
		    }
	    }
	catch (SAXException spe) {
	    // Error generated by the parser
	    System.err.println("Error in: (SAXException");
	    // Use the contained exception, if any
	    Exception  x;
	    x = spe;
	    if (spe.getException() != null)
		x = spe.getException();
	    x.printStackTrace();
	}
    }

    /**
     * This method save to xml all the information taken when user did the Feedback form.
     * @param err_details is the information taken when user did the Feedback form.
     * @param img         is the images taken when user did the Feedback form
     */ 
    public void saveFeedback (String[] err_details,String[] img)
    {
	try
	    {
		String dirname;
		dirname = "xmlfeedback/";
		FileOutputStream fos;
		fos = new FileOutputStream(dirname + "feedback" + err_details[0] + 
					   ".xml");
		PrintWriter out;
		out = new PrintWriter(fos);
		StreamResult streamResult;
		streamResult = new StreamResult(out);
		SAXTransformerFactory tf;
		tf = (SAXTransformerFactory) SAXTransformerFactory.newInstance();
		hd = tf.newTransformerHandler();
		Transformer serializer;
		serializer = hd.getTransformer();
		serializer.setOutputProperty(OutputKeys.ENCODING,"UTF-8");
		serializer.setOutputProperty(OutputKeys.INDENT,"yes");
		hd.setResult(streamResult);
		
		
		hd.startDocument();
		atts = new AttributesImpl();
		hd.startElement("","","BUGS",atts);
		
		hd.startElement("","","IDCode",atts);
		hd.characters(err_details[0].toCharArray(),0,err_details[0].length());
		hd.endElement("","","IDCode");
		
		hd.startElement("","","LastViewedWindow",atts);
		hd.characters(err_details[1].toCharArray(),0,err_details[1].length());
		hd.endElement("","","LastViewedWindow");

		hd.startElement("","","Optionals",atts);
		
		hd.startElement("","","Type",atts);
		hd.characters(err_details[3].toCharArray(),0,err_details[3].length());
		hd.endElement("","","Type");
		
		hd.startElement("","","Urgency",atts);
		hd.characters(err_details[4].toCharArray(),0,err_details[4].length());
		hd.endElement("","","Urgency");
		hd.endElement("","","Optionals");

		hd.startElement("","","User",atts);
		hd.startElement("","","Name",atts);
		hd.characters(err_details[5].toCharArray(),0,err_details[5].length());
		hd.endElement("","","Name");

		hd.startElement("","","HomeDirectory",atts);
		hd.characters(err_details[6].toCharArray(),0,err_details[6].length());
		hd.endElement("","","HomeDirectory");

		hd.startElement("","","WorkingDirectory",atts);
		hd.characters(err_details[7].toCharArray(),0,err_details[7].length());
		hd.endElement("","","WorkingDirectory");

		hd.startElement("","","SMTP",atts);
		hd.characters(err_details[19].toCharArray(),0,err_details[19].length());
		hd.endElement("","","SMTP");

		hd.startElement("","","Email",atts);
		hd.characters(err_details[20].toCharArray(),0,err_details[20].length());
		hd.endElement("","","Email");

		hd.endElement("","","User");

		hd.startElement("","","OpenFormTime",atts);
		hd.characters(err_details[8].toCharArray(),0,err_details[8].length());
		hd.endElement("","","OpenFormTime");

		hd.startElement("","","SendFormTime",atts);
		hd.characters(err_details[9].toCharArray(),0,err_details[9].length());
		hd.endElement("","","SendFormTime");

		hd.startElement("","","OperatingSystem",atts);
		hd.characters(err_details[10].toCharArray(),0,err_details[10].length());
		hd.endElement("","","OperatingSystem");

		hd.startElement("","","Java",atts);

		hd.startElement("","","JavaInformation",atts);
		hd.characters(err_details[11].toCharArray(),0,err_details[11].length());
		hd.endElement("","","JavaInformation");

		hd.startElement("","","TotalMemory",atts);
		hd.characters(err_details[21].toCharArray(),0,err_details[21].length());
		hd.endElement("","","TotalMemory");

		hd.startElement("","","MaxMemory",atts);
		hd.characters(err_details[22].toCharArray(),0,err_details[22].length());
		hd.endElement("","","MaxMemory");

		hd.startElement("","","FreeMemory",atts);
		hd.characters(err_details[23].toCharArray(),0,err_details[23].length());
		hd.endElement("","","FreeMemory");

		hd.startElement("","","DefaultLocale",atts);
		hd.characters(err_details[12].toCharArray(),0,err_details[12].length());
		hd.endElement("","","DefaultLocale");
		
		hd.endElement("","","Java");

		hd.startElement("","","Browser",atts);
		hd.characters(err_details[13].toCharArray(),0,err_details[13].length());
		hd.endElement("","","Browser");

		hd.startElement("","","LocalHostName",atts);
		hd.characters(err_details[14].toCharArray(),0,err_details[14].length());
		hd.endElement("","","LocalHostName");

		hd.startElement("","","LocalHostAddress",atts);
		hd.characters(err_details[15].toCharArray(),0,err_details[15].length());
		hd.endElement("","","LocalHostAddress");

		hd.startElement("","","ScreenResolution",atts);
		hd.characters(err_details[16].toCharArray(),0,err_details[16].length());
		hd.endElement("","","ScreenResolution");

		if (img!= null)
		    {
			hd.startElement("","","Sequences",atts);
			int i;
			for ( i = 0 ; i < img.length ; i= i + 10)
			    {
				hd.startElement("","","Sequence",atts);
				
				hd.startElement("","","Title",atts);
				hd.characters(img[i].toCharArray(),0,img[i].length());
				hd.endElement("","","Title");
				
				hd.startElement("","","Details",atts);
				hd.characters(img[i+9].toCharArray(),0,img[i+9].length());
				hd.endElement("","","Details");
				
				hd.startElement("","","ImageDescription",atts);
				
				hd.startElement("","","ScreenShot",atts);
				hd.startElement("","","Image",atts);
				saveImage(img[i+1],img[i+2],img[i+7],img[i+8]);
				hd.endElement("","","Image");
				hd.endElement("","","ScreenShot");
				
				hd.startElement("","","ErrorLineAndScreenShot",atts);
				hd.startElement("","","Image",atts);
				saveImage(img[i+3],img[i+4],img[i+7],img[i+8]);
				hd.endElement("","","Image");
				hd.endElement("","","ErrorLineAndScreenShot");
				
				hd.startElement("","","ErrorLineForScreenShot",atts);
				hd.startElement("","","Image",atts);
				saveImage(img[i+5],img[i+6],img[i+7],img[i+8]); 
				hd.endElement("","","Image");
				hd.endElement("","","ErrorLineForScreenShot");
				
				hd.endElement("","","ImageDescription");
				
				hd.endElement("","","Sequence");
			    }
			hd.endElement("","","Sequences");
		    }

		hd.endElement("","","BUGS");
		hd.endDocument();
		fos.close();
	    }
	catch (IOException e){
	    System.err.println ("Unable to write to file");
	    System.exit(-1);
	}catch (TransformerConfigurationException tce){
	    System.err.println("Error in: TransformerConfigurationException");
	}catch (SAXException spe) {
	    // Error generated by the parser
	    System.err.println("Error in: (SAXException");
	    // Use the contained exception, if any
	    Exception  x;
	    x = spe;
	    if (spe.getException() != null)
		x = spe.getException();
	    x.printStackTrace();
	}
    }
}









