/*
 *    UTF8Control.java
 *    Copyright (C) 2005 New Zealand Digital Library, http://www.nzdl.org
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// Based on: https://stackoverflow.com/questions/4659929/how-to-use-utf-8-in-resource-properties-with-resourcebundle

package org.greenstone.gsdl3.util;

import java.util.ResourceBundle;
import java.util.ResourceBundle.Control;
import java.util.Locale;
import java.util.Enumeration;
import java.util.PropertyResourceBundle;

import java.io.*;
import java.net.*;

import org.apache.log4j.*;

public class UTF8Control extends Control
{
	static Logger logger = Logger.getLogger(org.greenstone.gsdl3.util.UTF8Control.class.getName());

    public ResourceBundle newBundle
	(String baseName, Locale locale, String format, ClassLoader loader, boolean reload)
	throws IllegalAccessException, InstantiationException, IOException
    {
	// The below is a copy of the default implementation.
	String bundleName = toBundleName(baseName, locale);
	String resourceName = toResourceName(bundleName, "properties");
	ResourceBundle bundle = null;
	InputStream stream = null;
	if (reload) {
	    URL url = loader.getResource(resourceName);
	    if (url != null) {
		URLConnection connection = url.openConnection();
		if (connection != null) {
		    connection.setUseCaches(false);
		    stream = connection.getInputStream();
		}
	    }
	} else {
	    stream = loader.getResourceAsStream(resourceName);
	}
	if (stream != null) {
	    try {
		// Only this line is changed to make it to read properties files as UTF-8.
		bundle = new PropertyResourceBundle(new InputStreamReader(stream, "UTF-8"));
	    } finally {
		stream.close();
	    }
	}
	return bundle;
    }
}
