/*
 *    GSConstants.java
 *    Copyright (C) 2008 New Zealand Digital Library, http://www.nzdl.org
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package org.greenstone.gsdl3.util;

/** these constants are used for servlet args, and config variables */
public class GSConstants
{
	public static final String GSDL3_HOME = "gsdl3_home";
	public static final String INTERFACE_NAME = "interface_name";
	public static final String SITE_NAME      = "site_name";
	public static final String LIBRARY_NAME   = "library_name";
  public static final String WEBSWING_CONTEXT = "webswing_context";
  
        public static final String SERVLET_PROTOCOL  = "servlet_protocol";
        public static final String SERVLET_DOMAIN    = "servlet_domain";
        public static final String SERVLET_OPT_PORT  = "servlet_opt_port";
        public static final String SERVLET_CONTEXT   = "servlet_context";

	public static final String BASE_INTERFACES = "base_interfaces";
	public static final String DEFAULT_LANG = "default_lang";
	public static final String USE_CLIENT_SIDE_XSLT = "use_client_side_xslt";

  public static final String REMOTE_SITE_NAME = "remote_site_name";
  public static final String REMOTE_SITE_TYPE = "remote_site_type";
  public static final String REMOTE_SITE_ADDRESS = "remote_site_address";
  public static final String RECEPTIONIST_CLASS = "receptionist_class";

  //public static final String CLIENT_SIDE_XSLT_INTERFACE_SUFFIX = "-client-xslt";

	public static final String META_RELATION_SEP = "_";
	public static final String META_SEPARATOR_SEP = "*";
	public static final String META_FIRST = "first";
	public static final String META_LAST = "last";
	public static final String META_POS = "pos";

    public static final String UTF8="UTF-8";
    // The default encoding Greenstone expects when reading in its XML files
	public static final String XML_FILE_ENCODING = UTF8;
	
	/**
	 * Gets the name of the cookie consent servlet parameter.
	 */
	public static final String COOKIE_CONSENT = "cookie_consent";
}
