#!/bin/bash


jar_list=`cat jar-list.txt | egrep -v "^#"`


echo ""

src_jar_list=""


for j in $jar_list ; do
    num_matches=`find google-*-client -name "*$j" | wc -l`

    if [ $num_matches != "0" ] ; then
	found_jar_file=`find google-*-client -name "*$j" | head -n 1`
	src_jar_list="$src_jar_list $found_jar_file"
    else
	echo "" 1>&2
	echo "Error, failed to find:" 1>&2
	echo "  $j" 1>&2
	echo "" 1>&2
	exit 1
    fi

done

echo $src_jar_list > located-jar-list.txt

echo "Generate list of located jar dependencies in:"
echo "  located-jar-list.txt"


echo ""
